/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.package_info;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PackageInfo
extends JFrame {
    private JScrollPane jScrollPane1;
    private JTextArea myTextArea;

    private void pkgInfo(JTextArea textArea, ClassLoader classLoader, String pkgName, String className) {
        try {
            classLoader.loadClass(pkgName + "." + className);
            Package p = Package.getPackage(pkgName);
            if (p == null) {
                textArea.append("WARNING: Package.getPackage(" + pkgName + ") is null\n");
            } else {
                textArea.append(p.toString() + "\n");
                textArea.append("Specification Title = " + p.getSpecificationTitle() + "\n");
                textArea.append("Specification Vendor = " + p.getSpecificationVendor() + "\n");
                textArea.append("Specification Version = " + p.getSpecificationVersion() + "\n");
                textArea.append("Implementation Vendor = " + p.getImplementationVendor() + "\n");
                textArea.append("Implementation Version = " + p.getImplementationVersion() + "\n");
            }
        }
        catch (ClassNotFoundException e) {
            textArea.append("Unable to load " + pkgName + "\n");
        }
        textArea.append("\n");
    }

    public PackageInfo() {
        this.initComponents();
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.pkgInfo(this.myTextArea, classLoader, "javax.vecmath", "Point3d");
        this.pkgInfo(this.myTextArea, classLoader, "javax.media.j3d", "SceneGraphObject");
        this.pkgInfo(this.myTextArea, classLoader, "com.sun.j3d.utils.universe", "SimpleUniverse");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.myTextArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("Package Info");
        this.jScrollPane1.setPreferredSize(new Dimension(400, 400));
        this.myTextArea.setColumns(20);
        this.myTextArea.setEditable(false);
        this.myTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.myTextArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PackageInfo().setVisible(true);
            }
        });
    }
}

