/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.package_info;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class QueryProperties
extends JFrame {
    private JScrollPane jScrollPane1;
    private JTextArea myTextArea;

    public static void printProps(JTextArea textArea, Map map, String[] propList) {
        ArrayList keyList = new ArrayList(map.keySet());
        Collections.sort(keyList);
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < propList.length; ++i) {
            int len = propList[i].length();
            int idxWild = propList[i].indexOf(42);
            if (idxWild < 0) {
                String key = propList[i];
                if (hs.contains(key)) continue;
                textArea.append(key + " = " + map.get(key) + "\n");
                hs.add(key);
                continue;
            }
            if (idxWild == len - 1) {
                String pattern = propList[i].substring(0, len - 1);
                for (String key : keyList) {
                    if (!key.startsWith(pattern) || hs.contains(key)) continue;
                    textArea.append(key + " = " + map.get(key) + "\n");
                    hs.add(key);
                }
                continue;
            }
            textArea.append(propList[i] + " = ERROR: KEY WITH EMBEDDED WILD CARD IGNORED\n");
        }
        for (String key : keyList) {
            if (hs.contains(key)) continue;
            textArea.append(key + " = " + map.get(key) + "\n");
        }
    }

    public QueryProperties() {
        this.initComponents();
        VirtualUniverse vu = new VirtualUniverse();
        Map vuMap = vu.getProperties();
        String[] vuPropList = new String[]{"j3d.version", "j3d.vendor", "j3d.specification.version", "j3d.specification.vendor", "j3d.*"};
        QueryProperties.printProps(this.myTextArea, vuMap, vuPropList);
        this.myTextArea.append("\n");
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setStereo(2);
        template.setSceneAntialiasing(2);
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
        Map c3dMap = new Canvas3D(config).queryProperties();
        String[] c3dPropList = new String[]{"native.*", "doubleBufferAvailable", "stereoAvailable", "sceneAntialiasing*", "compressedGeometry.majorVersionNumber", "compressedGeometry.minorVersionNumber", "compressedGeometry.*", "textureUnitStateMax", "textureWidthMax", "textureHeightMax"};
        QueryProperties.printProps(this.myTextArea, c3dMap, c3dPropList);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.myTextArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("QueryProperties");
        this.jScrollPane1.setPreferredSize(new Dimension(400, 500));
        this.myTextArea.setColumns(20);
        this.myTextArea.setEditable(false);
        this.myTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.myTextArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new QueryProperties().setVisible(true);
            }
        });
    }
}

