/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.picking;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.behaviors.PickRotateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickTranslateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickZoomBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

public class PickText3DBounds
extends Applet {
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph(Canvas3D canvas) {
        Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f objColor = new Color3f(0.6f, 0.6f, 0.6f);
        Color3f lColor1 = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f lColor2 = new Color3f(0.0f, 1.0f, 0.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objScale.addChild((Node)bg);
        Material m = new Material(objColor, eColor, objColor, sColor, 100.0f);
        Appearance a = new Appearance();
        m.setLightingEnable(true);
        a.setMaterial(m);
        Font3D f3d = new Font3D(new Font("TestFont", 0, 1), new FontExtrusion());
        Text3D txt = new Text3D(f3d, new String("TEXT3D"), new Point3f(-2.0f, 0.0f, 0.0f));
        Shape3D s3D = new Shape3D();
        s3D.setGeometry((Geometry)txt);
        s3D.setAppearance(a);
        TransformGroup spinTg = new TransformGroup();
        spinTg.setCapability(18);
        spinTg.setCapability(17);
        spinTg.setCapability(1);
        spinTg.addChild((Node)s3D);
        objScale.addChild((Node)spinTg);
        Transform3D t = new Transform3D();
        Vector3d lPos1 = new Vector3d(0.0, 0.0, 2.0);
        t.set(lPos1);
        TransformGroup l1Trans = new TransformGroup(t);
        l1Trans.setCapability(18);
        l1Trans.setCapability(17);
        l1Trans.setCapability(1);
        objScale.addChild((Node)l1Trans);
        t = new Transform3D();
        Vector3d lPos2 = new Vector3d(0.5, 0.8, 2.0);
        t.set(lPos2);
        TransformGroup l2Trans = new TransformGroup(t);
        l2Trans.setCapability(18);
        l2Trans.setCapability(17);
        l2Trans.setCapability(1);
        objScale.addChild((Node)l2Trans);
        ColoringAttributes caL1 = new ColoringAttributes();
        ColoringAttributes caL2 = new ColoringAttributes();
        caL1.setColor(lColor1);
        caL2.setColor(lColor2);
        Appearance appL1 = new Appearance();
        Appearance appL2 = new Appearance();
        appL1.setColoringAttributes(caL1);
        appL2.setColoringAttributes(caL2);
        l1Trans.addChild((Node)new Sphere(0.05f, 1, 15, appL1));
        l2Trans.addChild((Node)new Sphere(0.05f, 1, 15, appL2));
        AmbientLight aLgt = new AmbientLight(alColor);
        Point3f lPoint = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f atten = new Point3f(1.0f, 0.0f, 0.0f);
        PointLight lgt1 = new PointLight(lColor1, lPoint, atten);
        PointLight lgt2 = new PointLight(lColor2, lPoint, atten);
        aLgt.setInfluencingBounds((Bounds)bounds);
        lgt1.setInfluencingBounds((Bounds)bounds);
        lgt2.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)aLgt);
        l1Trans.addChild((Node)lgt1);
        l2Trans.addChild((Node)lgt2);
        PickRotateBehavior behavior1 = new PickRotateBehavior(objRoot, canvas, (Bounds)bounds);
        behavior1.setMode(512);
        objRoot.addChild((Node)behavior1);
        PickZoomBehavior behavior2 = new PickZoomBehavior(objRoot, canvas, (Bounds)bounds);
        behavior2.setMode(512);
        objRoot.addChild((Node)behavior2);
        PickTranslateBehavior behavior3 = new PickTranslateBehavior(objRoot, canvas, (Bounds)bounds);
        behavior3.setMode(512);
        objRoot.addChild((Node)behavior3);
        objRoot.compile();
        return objRoot;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        this.u = new SimpleUniverse(c);
        BranchGroup scene = this.createSceneGraph(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new PickText3DBounds(), 700, 700);
    }
}

