/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.picking;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.behaviors.PickRotateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickTranslateBehavior;
import com.sun.j3d.utils.picking.behaviors.PickZoomBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

public class PickText3DGeometry
extends Applet {
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph(Canvas3D canvas) {
        Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f objColor = new Color3f(0.6f, 0.6f, 0.6f);
        Color3f lColor1 = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f lColor2 = new Color3f(0.0f, 1.0f, 0.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objScale.addChild((Node)bg);
        Material m = new Material(objColor, eColor, objColor, sColor, 100.0f);
        Appearance a = new Appearance();
        m.setLightingEnable(true);
        a.setMaterial(m);
        Font3D f3d = new Font3D(new Font("TestFont", 0, 1), new FontExtrusion());
        Text3D text3D = new Text3D(f3d, new String("TEXT3D"), new Point3f(-2.0f, 0.7f, 0.0f));
        text3D.setCapability(18);
        Shape3D s3D1 = new Shape3D();
        s3D1.setGeometry((Geometry)text3D);
        s3D1.setAppearance(a);
        TransformGroup spinTg1 = new TransformGroup();
        spinTg1.setCapability(18);
        spinTg1.setCapability(17);
        spinTg1.setCapability(1);
        spinTg1.addChild((Node)s3D1);
        objScale.addChild((Node)spinTg1);
        Text3D pick = new Text3D(f3d, new String("Pick me"), new Point3f(-2.0f, -0.7f, 0.0f));
        pick.setCapability(18);
        Shape3D s3D2 = new Shape3D();
        s3D2.setGeometry((Geometry)pick);
        s3D2.setAppearance(a);
        TransformGroup spinTg2 = new TransformGroup();
        spinTg2.setCapability(18);
        spinTg2.setCapability(17);
        spinTg2.setCapability(1);
        spinTg2.addChild((Node)s3D2);
        objScale.addChild((Node)spinTg2);
        Transform3D t = new Transform3D();
        Vector3d lPos1 = new Vector3d(0.0, 0.0, 2.0);
        t.set(lPos1);
        TransformGroup l1Trans = new TransformGroup(t);
        l1Trans.setCapability(18);
        l1Trans.setCapability(17);
        l1Trans.setCapability(1);
        objScale.addChild((Node)l1Trans);
        t = new Transform3D();
        Vector3d lPos2 = new Vector3d(0.5, 1.2, 2.0);
        t.set(lPos2);
        TransformGroup l2Trans = new TransformGroup(t);
        l2Trans.setCapability(18);
        l2Trans.setCapability(17);
        l2Trans.setCapability(1);
        objScale.addChild((Node)l2Trans);
        ColoringAttributes caL1 = new ColoringAttributes();
        ColoringAttributes caL2 = new ColoringAttributes();
        caL1.setColor(lColor1);
        caL2.setColor(lColor2);
        Appearance appL1 = new Appearance();
        Appearance appL2 = new Appearance();
        appL1.setColoringAttributes(caL1);
        appL2.setColoringAttributes(caL2);
        l1Trans.addChild((Node)new Sphere(0.05f, 33, 15, appL1));
        l2Trans.addChild((Node)new Sphere(0.05f, 33, 15, appL2));
        AmbientLight aLgt = new AmbientLight(alColor);
        Point3f lPoint = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f atten = new Point3f(1.0f, 0.0f, 0.0f);
        PointLight lgt1 = new PointLight(lColor1, lPoint, atten);
        PointLight lgt2 = new PointLight(lColor2, lPoint, atten);
        aLgt.setInfluencingBounds((Bounds)bounds);
        lgt1.setInfluencingBounds((Bounds)bounds);
        lgt2.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)aLgt);
        l1Trans.addChild((Node)lgt1);
        l2Trans.addChild((Node)lgt2);
        PickRotateBehavior behavior1 = new PickRotateBehavior(objRoot, canvas, (Bounds)bounds);
        behavior1.setMode(256);
        behavior1.setTolerance(0.0f);
        objRoot.addChild((Node)behavior1);
        PickZoomBehavior behavior2 = new PickZoomBehavior(objRoot, canvas, (Bounds)bounds);
        behavior2.setMode(256);
        behavior2.setTolerance(0.0f);
        objRoot.addChild((Node)behavior2);
        PickTranslateBehavior behavior3 = new PickTranslateBehavior(objRoot, canvas, (Bounds)bounds);
        behavior3.setMode(256);
        behavior3.setTolerance(0.0f);
        objRoot.addChild((Node)behavior3);
        objRoot.compile();
        return objRoot;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        this.u = new SimpleUniverse(c);
        BranchGroup scene = this.createSceneGraph(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new PickText3DGeometry(), 700, 700);
    }
}

