/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.print_canvas3d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

class ImagePrinter
implements Printable,
ImageObserver {
    BufferedImage bImage;

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform t2d = new AffineTransform();
        t2d.translate(pf.getImageableX(), pf.getImageableY());
        double xscale = pf.getImageableWidth() / (double)this.bImage.getWidth();
        double yscale = pf.getImageableHeight() / (double)this.bImage.getHeight();
        double scale = Math.min(xscale, yscale);
        t2d.scale(scale, scale);
        try {
            g2d.drawImage(this.bImage, t2d, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 1;
        }
        return 0;
    }

    void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printJob.defaultPage();
        pageFormat.setOrientation(0);
        pageFormat = printJob.validatePage(pageFormat);
        printJob.setPrintable(this, pageFormat);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    ImagePrinter(BufferedImage bImage) {
        this.bImage = bImage;
    }
}

