/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.pure_immediate;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.Transform3D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PureImmediate
extends JFrame
implements Runnable {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private Canvas3D canvas;
    private GraphicsContext3D gc = null;
    private Geometry cube = null;
    private Transform3D cmt = new Transform3D();
    private Alpha rotAlpha = new Alpha(-1, 6000L);
    private JPanel drawingPanel;

    public void render() {
        if (this.gc == null) {
            this.gc = this.canvas.getGraphicsContext3D();
            this.gc.setAppearance(new Appearance());
            this.cube = new ColorCube(0.4).getGeometry();
        }
        double angle = (double)this.rotAlpha.value() * 2.0 * Math.PI;
        this.cmt.rotY(angle);
        this.gc.clear();
        this.gc.setModelTransform(this.cmt);
        this.gc.draw(this.cube);
        this.canvas.swap();
    }

    public void run() {
        System.out.println("PureImmediate.run: starting main loop");
        while (true) {
            this.render();
            Thread.yield();
        }
    }

    private void createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.canvas = new Canvas3D(config);
        this.canvas.stopRenderer();
        this.univ = new SimpleUniverse(this.canvas);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
    }

    public PureImmediate() {
        this.initComponents();
        this.createUniverse();
        this.drawingPanel.add((Component)this.canvas, "Center");
        new Thread(this).start();
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("PureImmediate");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(250, 250));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PureImmediate().setVisible(true);
            }
        });
    }
}

