/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.pure_immediate;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.Map;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.Light;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class PureImmediateStereo
extends JFrame
implements Runnable {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    public static String defaultSharedStereoZbuffer = Boolean.TRUE.toString();
    private boolean sharedStereoZbuffer;
    private boolean stereoSupport;
    private Canvas3D canvas;
    private GraphicsContext3D gc;
    private Shape3D leftConeBody;
    private Shape3D rightConeBody;
    private Shape3D leftConeCap;
    private Shape3D rightConeCap;
    private Transform3D cmt = new Transform3D();
    private Vector3f leftTrans;
    private Vector3f rightTrans;
    private Alpha rotAlpha = new Alpha(-1, 6000L);
    private double angle;
    private JPanel drawingPanel;

    void computeSharedData() {
        this.angle = (double)this.rotAlpha.value() * 2.0 * Math.PI;
        this.cmt.rotY(this.angle);
    }

    void renderLeft() {
        this.cmt.setTranslation(this.leftTrans);
        this.gc.setModelTransform(this.cmt);
        if (this.sharedStereoZbuffer) {
            this.gc.clear();
        }
        this.gc.draw(this.leftConeBody);
        this.gc.draw(this.leftConeCap);
    }

    void renderRight() {
        this.cmt.setTranslation(this.rightTrans);
        this.gc.setModelTransform(this.cmt);
        if (this.sharedStereoZbuffer) {
            this.gc.clear();
        }
        this.gc.draw(this.rightConeBody);
        this.gc.draw(this.rightConeCap);
    }

    public void run() {
        this.gc = this.canvas.getGraphicsContext3D();
        this.gc.setBufferOverride(true);
        Color3f lightColor = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f lightDir = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight light = new DirectionalLight(lightColor, lightDir);
        this.gc.addLight((Light)light);
        Appearance redApp = new Appearance();
        Appearance greenApp = new Appearance();
        Color3f ambientColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f emissiveColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f diffuseColor = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f specularColor = new Color3f(1.0f, 1.0f, 1.0f);
        redApp.setMaterial(new Material(ambientColor, emissiveColor, diffuseColor, specularColor, 5.0f));
        diffuseColor = new Color3f(0.0f, 1.0f, 0.0f);
        greenApp.setMaterial(new Material(ambientColor, emissiveColor, diffuseColor, specularColor, 5.0f));
        Cone leftCone = new Cone(0.4f, 0.6f, 1, redApp);
        Cone rightCone = new Cone(0.4f, 0.6f, 1, greenApp);
        this.leftConeBody = leftCone.getShape(0);
        this.leftConeCap = leftCone.getShape(1);
        this.rightConeBody = rightCone.getShape(0);
        this.rightConeCap = rightCone.getShape(1);
        this.leftTrans = new Vector3f(-0.6f, 0.0f, 0.0f);
        this.rightTrans = new Vector3f(0.6f, 0.0f, 0.0f);
        while (true) {
            this.computeSharedData();
            if (this.stereoSupport) {
                if (!this.sharedStereoZbuffer) {
                    this.gc.setStereoMode(2);
                    this.gc.clear();
                }
                this.gc.setStereoMode(0);
                this.renderLeft();
                this.gc.setStereoMode(1);
                this.renderRight();
            } else {
                this.gc.clear();
                this.renderLeft();
            }
            this.canvas.swap();
            Thread.yield();
        }
    }

    private void createUniverse() {
        GraphicsConfigTemplate3D gct = new GraphicsConfigTemplate3D();
        gct.setStereo(2);
        GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)gct);
        this.canvas = new Canvas3D(config);
        Map map = this.canvas.queryProperties();
        this.stereoSupport = this.canvas.getStereoAvailable();
        if (this.stereoSupport) {
            System.out.println("This machine support stereo, you should see a red cone on the left and green cone on the right.");
            String str = System.getProperty("j3d.sharedstereozbuffer", defaultSharedStereoZbuffer);
            this.sharedStereoZbuffer = new Boolean(str);
        } else {
            System.out.println("Stereo is not support, you should only see the left red cone.");
        }
        if (!this.canvas.getDoubleBufferAvailable()) {
            System.out.println("Double buffer is not support !");
        }
        this.canvas.stopRenderer();
        this.univ = new SimpleUniverse(this.canvas);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        new Thread(this).start();
    }

    public PureImmediateStereo() {
        this.initComponents();
        this.createUniverse();
        this.drawingPanel.add((Component)this.canvas, "Center");
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("PureImmediateStereo");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(512, 256));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PureImmediateStereo().setVisible(true);
            }
        });
    }
}

