/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.sound;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BackgroundSound;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PointSound;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.sound.SimpleSoundsBehavior;

public class SimpleSounds
extends Applet {
    private static URL[] url = new URL[3];
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        objTrans.addChild((Node)new ColorCube(0.4));
        Transform3D yAxis = new Transform3D();
        Alpha rotation = new Alpha(-1, 1, 0L, 0L, 20000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotation, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        BackgroundSound sound1 = new BackgroundSound();
        PointSound sound2 = new PointSound();
        PointSound sound3 = new PointSound();
        sound1.setCapability(23);
        sound1.setCapability(15);
        sound1.setCapability(13);
        sound1.setCapability(25);
        sound1.setCapability(21);
        sound1.setCapability(19);
        sound1.setCapability(28);
        sound1.setCapability(30);
        sound1.setCapability(17);
        sound2.setCapability(23);
        sound2.setCapability(15);
        sound2.setCapability(13);
        sound2.setCapability(25);
        sound2.setCapability(21);
        sound2.setCapability(19);
        sound2.setCapability(28);
        sound2.setCapability(30);
        sound2.setCapability(33);
        sound2.setCapability(17);
        sound3.setCapability(23);
        sound3.setCapability(15);
        sound3.setCapability(13);
        sound3.setCapability(25);
        sound3.setCapability(21);
        sound3.setCapability(19);
        sound3.setCapability(28);
        sound3.setCapability(30);
        sound3.setCapability(33);
        BoundingSphere soundBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        sound1.setSchedulingBounds((Bounds)soundBounds);
        sound2.setSchedulingBounds((Bounds)soundBounds);
        sound3.setSchedulingBounds((Bounds)soundBounds);
        objTrans.addChild((Node)sound1);
        objTrans.addChild((Node)sound2);
        objTrans.addChild((Node)sound3);
        SimpleSoundsBehavior player = new SimpleSoundsBehavior(sound1, sound2, sound3, url[0], url[1], url[2], soundBounds);
        player.setSchedulingBounds((Bounds)soundBounds);
        objTrans.addChild((Node)player);
        objRoot.compile();
        return objRoot;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        SimpleSounds.url[0] = Resources.getResource("resources/audio/techno_machine.au");
        if (url == null) {
            System.err.println("resources/audio/techno_machine.au not found");
            System.exit(1);
        }
        SimpleSounds.url[1] = Resources.getResource("resources/audio/hello_universe.au");
        if (url == null) {
            System.err.println("resources/audio/hello_universe.au not found");
            System.exit(1);
        }
        SimpleSounds.url[2] = Resources.getResource("resources/audio/roar.au");
        if (url == null) {
            System.err.println("resources/audio/roar.au not found");
            System.exit(1);
        }
        this.u = new SimpleUniverse(c);
        AudioDevice audioDev = this.u.getViewer().createAudioDevice();
        BranchGroup scene = this.createSceneGraph();
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
        JOptionPane.showMessageDialog(this, "This program is still a work in progress.\nPlease check back in Java 3D 1.5.\n", "Incomplete Work", 1);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new SimpleSounds(), args, 256, 256);
    }
}

