/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.sphere_motion;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.PositionInterpolator;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class SphereMotion
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private static final int DIRECTIONAL_LIGHT = 0;
    private static final int POINT_LIGHT = 1;
    private static final int SPOT_LIGHT = 2;
    private static int lightType = 1;
    private JPanel drawingPanel;

    public BranchGroup createSceneGraph() {
        Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f objColor = new Color3f(0.6f, 0.6f, 0.6f);
        Color3f lColor1 = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f lColor2 = new Color3f(0.0f, 1.0f, 0.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objScale.addChild((Node)bg);
        Material m = new Material(objColor, eColor, objColor, sColor, 100.0f);
        Appearance a = new Appearance();
        m.setLightingEnable(true);
        a.setMaterial(m);
        Sphere sph = new Sphere(1.0f, 1, 80, a);
        objScale.addChild((Node)sph);
        TransformGroup l1RotTrans = new TransformGroup();
        l1RotTrans.setCapability(18);
        objScale.addChild((Node)l1RotTrans);
        TransformGroup l2RotTrans = new TransformGroup();
        l2RotTrans.setCapability(18);
        objScale.addChild((Node)l2RotTrans);
        Transform3D t = new Transform3D();
        Vector3d lPos1 = new Vector3d(0.0, 0.0, 2.0);
        t.set(lPos1);
        TransformGroup l1Trans = new TransformGroup(t);
        l1RotTrans.addChild((Node)l1Trans);
        t = new Transform3D();
        Vector3d lPos2 = new Vector3d(0.5, 0.8, 2.0);
        t.set(lPos2);
        TransformGroup l2Trans = new TransformGroup(t);
        l2RotTrans.addChild((Node)l2Trans);
        ColoringAttributes caL1 = new ColoringAttributes();
        ColoringAttributes caL2 = new ColoringAttributes();
        caL1.setColor(lColor1);
        caL2.setColor(lColor2);
        Appearance appL1 = new Appearance();
        Appearance appL2 = new Appearance();
        appL1.setColoringAttributes(caL1);
        appL2.setColoringAttributes(caL2);
        l1Trans.addChild((Node)new Sphere(0.05f, appL1));
        l2Trans.addChild((Node)new Sphere(0.05f, appL2));
        AmbientLight aLgt = new AmbientLight(alColor);
        DirectionalLight lgt1 = null;
        DirectionalLight lgt2 = null;
        Point3f lPoint = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f atten = new Point3f(1.0f, 0.0f, 0.0f);
        Vector3f lDirect1 = new Vector3f(lPos1);
        Vector3f lDirect2 = new Vector3f(lPos2);
        lDirect1.negate();
        lDirect2.negate();
        switch (lightType) {
            case 0: {
                lgt1 = new DirectionalLight(lColor1, lDirect1);
                lgt2 = new DirectionalLight(lColor2, lDirect2);
                break;
            }
            case 1: {
                lgt1 = new PointLight(lColor1, lPoint, atten);
                lgt2 = new PointLight(lColor2, lPoint, atten);
                break;
            }
            case 2: {
                lgt1 = new SpotLight(lColor1, lPoint, atten, lDirect1, 0.43633232f, 10.0f);
                lgt2 = new SpotLight(lColor2, lPoint, atten, lDirect2, 0.43633232f, 10.0f);
            }
        }
        aLgt.setInfluencingBounds((Bounds)bounds);
        lgt1.setInfluencingBounds((Bounds)bounds);
        lgt2.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)aLgt);
        l1Trans.addChild((Node)lgt1);
        l2Trans.addChild((Node)lgt2);
        Transform3D yAxis = new Transform3D();
        Alpha rotor1Alpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator1 = new RotationInterpolator(rotor1Alpha, l1RotTrans, yAxis, 0.0f, (float)Math.PI * 2);
        rotator1.setSchedulingBounds((Bounds)bounds);
        l1RotTrans.addChild((Node)rotator1);
        Alpha rotor2Alpha = new Alpha(-1, 1, 0L, 0L, 1000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator2 = new RotationInterpolator(rotor2Alpha, l2RotTrans, yAxis, 0.0f, 0.0f);
        bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator2.setSchedulingBounds((Bounds)bounds);
        l2RotTrans.addChild((Node)rotator2);
        TransformGroup vpTrans = this.univ.getViewingPlatform().getViewPlatformTransform();
        Transform3D axisOfTranslation = new Transform3D();
        Alpha transAlpha = new Alpha(-1, 3, 0L, 0L, 5000L, 0L, 0L, 5000L, 0L, 0L);
        axisOfTranslation.rotY(-1.5707963267948966);
        PositionInterpolator translator = new PositionInterpolator(transAlpha, vpTrans, axisOfTranslation, 2.0f, 3.5f);
        translator.setSchedulingBounds((Bounds)bounds);
        objScale.addChild((Node)translator);
        objRoot.compile();
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public SphereMotion(String[] args) {
        String usage = "Usage: java SphereMotion [-point | -spot | -dir]";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-point")) {
                    System.out.println("Using point lights");
                    lightType = 1;
                    continue;
                }
                if (args[i].equals("-spot")) {
                    System.out.println("Using spot lights");
                    lightType = 2;
                    continue;
                }
                if (args[i].equals("-dir")) {
                    System.out.println("Using directional lights");
                    lightType = 0;
                    continue;
                }
                System.out.println(usage);
                System.exit(0);
                continue;
            }
            System.out.println(usage);
            System.exit(0);
        }
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("SphereMotion");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SphereMotion sphereMotion = new SphereMotion(args);
                sphereMotion.setVisible(true);
            }
        });
    }
}

