/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.text3d;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Text3DLoad
extends Applet
implements ActionListener {
    private String fontName = "TestFont";
    private String textString = null;
    private double tessellation = 0.0;
    private SimpleUniverse u;
    private Button button;
    private boolean behaviorsOn = false;
    private OrbitBehavior orbit;

    public BranchGroup createSceneGraph() {
        float sl = this.textString.length();
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(1.2 / (double)sl);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objScale.addChild((Node)objTrans);
        Font3D f3d = this.tessellation > 0.0 ? new Font3D(new Font(this.fontName, 0, 2), this.tessellation, new FontExtrusion()) : new Font3D(new Font(this.fontName, 0, 2), new FontExtrusion());
        Text3D txt = new Text3D(f3d, this.textString, new Point3f(-sl / 2.0f, -1.0f, -1.0f));
        Shape3D sh = new Shape3D();
        Appearance app = new Appearance();
        Material mm = new Material();
        mm.setLightingEnable(true);
        app.setMaterial(mm);
        sh.setGeometry((Geometry)txt);
        sh.setAppearance(app);
        objTrans.addChild((Node)sh);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bgNode);
        Color3f ambientColor = new Color3f(0.3f, 0.3f, 0.3f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light2);
        return objRoot;
    }

    private void usage() {
        System.out.println("Usage: java Text3DLoad [-f fontname] [-t tessellation] [<text>]");
        System.exit(0);
    }

    public Text3DLoad() {
    }

    public Text3DLoad(String[] args) {
        if (args.length == 0) {
            this.textString = "Java3D";
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    if (args[i].equals("-f")) {
                        if (i < args.length - 1) {
                            this.fontName = args[++i];
                            continue;
                        }
                        this.usage();
                        continue;
                    }
                    if (args[i].equals("-t")) {
                        if (i < args.length - 1) {
                            this.tessellation = Double.parseDouble(args[++i]);
                            continue;
                        }
                        this.usage();
                        continue;
                    }
                    System.err.println("Argument '" + args[i] + "' ignored.");
                    continue;
                }
                this.textString = args[i];
            }
        }
        if (this.textString == null) {
            this.usage();
        }
    }

    public void init() {
        if (this.textString == null) {
            this.textString = "Java3D";
        }
        this.setLayout(new BorderLayout());
        this.button = new Button("remove behaviors");
        this.button.addActionListener(this);
        Panel p = new Panel();
        p.add(this.button);
        this.add("South", p);
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        this.orbit = new OrbitBehavior(c, 368);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)this.orbit);
        this.behaviorsOn = true;
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            ViewingPlatform v = this.u.getViewingPlatform();
            if (this.behaviorsOn) {
                v.setViewPlatformBehavior(null);
                this.button.setLabel("add behaviors");
                this.behaviorsOn = false;
            } else {
                v.setViewPlatformBehavior((ViewPlatformBehavior)this.orbit);
                this.button.setLabel("remove behaviors");
                this.behaviorsOn = true;
            }
        }
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new Text3DLoad(args), 700, 700);
    }
}

