/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.texture;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;

public class MultiTextureTest
extends Applet
implements ItemListener {
    Choice choice;
    TextureUnitState[] textureUnitState = new TextureUnitState[2];
    Texture stoneTex;
    Texture skyTex;
    Texture lightTex;
    private URL stoneImage = null;
    private URL skyImage = null;
    private SimpleUniverse u = null;

    public Texture createLightMap() {
        int width = 128;
        int height = 128;
        BufferedImage bimage = new BufferedImage(width, height, 1);
        int[] rgbArray = new int[width * height];
        int rgbInc = 256 / (width / 2 - 20);
        int rgbValue = 0;
        int k = width / 2 - 5;
        int rgb = 255;
        rgbValue = rgb | rgb << 8 | rgb << 16 | rgb << 24;
        int i = width / 2 - 1;
        int j = 0;
        while (j < 10) {
            rgbArray[i] = rgbValue;
            ++j;
            --i;
        }
        while (i > 8) {
            rgbArray[i] = rgbValue = rgb | rgb << 8 | rgb << 16 | rgb << 24;
            --i;
            rgb -= rgbInc;
        }
        while (i >= 0) {
            rgbArray[i] = rgbValue;
            --i;
        }
        for (i = 0; i < width / 2; ++i) {
            rgbValue = rgbArray[i];
            int index = i;
            int index2 = width - i - 1;
            for (j = 0; j < height; ++j) {
                rgbArray[index] = rgbArray[index2] = rgbValue;
                index += width;
                index2 += width;
            }
        }
        bimage.setRGB(0, 0, width, height, rgbArray, 0, width);
        ImageComponent2D grayImage = new ImageComponent2D(1, bimage, true, true);
        this.lightTex = new Texture2D(1, 5, width, height);
        this.lightTex.setImage(0, (ImageComponent)grayImage);
        return this.lightTex;
    }

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objTrans.setCapability(1);
        objScale.addChild((Node)objTrans);
        Appearance ap = new Appearance();
        TextureAttributes texAttr1 = new TextureAttributes();
        texAttr1.setTextureMode(3);
        TextureAttributes texAttr2 = new TextureAttributes();
        texAttr2.setTextureMode(2);
        TextureLoader tex = new TextureLoader(this.stoneImage, new String("RGB"), (Component)this);
        if (tex == null) {
            return null;
        }
        this.stoneTex = tex.getTexture();
        tex = new TextureLoader(this.skyImage, new String("RGB"), (Component)this);
        if (tex == null) {
            return null;
        }
        this.skyTex = tex.getTexture();
        this.lightTex = this.createLightMap();
        this.textureUnitState[0] = new TextureUnitState(this.stoneTex, texAttr1, null);
        this.textureUnitState[0].setCapability(1);
        this.textureUnitState[1] = new TextureUnitState(this.lightTex, texAttr2, null);
        this.textureUnitState[1].setCapability(1);
        ap.setTextureUnitState(this.textureUnitState);
        Box BoxObj = new Box(1.5f, 1.5f, 0.8f, 3, ap, 2);
        objTrans.addChild((Node)BoxObj);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Color3f lColor2 = new Color3f(0.2f, 0.2f, 0.1f);
        Vector3f lDir1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        Vector3f lDir2 = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        DirectionalLight lgt2 = new DirectionalLight(lColor2, lDir2);
        lgt1.setInfluencingBounds((Bounds)bounds);
        lgt2.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)lgt1);
        objScale.addChild((Node)lgt2);
        objRoot.compile();
        return objRoot;
    }

    public MultiTextureTest() {
    }

    public MultiTextureTest(URL stoneURL, URL skyURL) {
        this.stoneImage = stoneURL;
        this.skyImage = skyURL;
    }

    public void init() {
        if (this.stoneImage == null) {
            this.stoneImage = Resources.getResource("resources/images/stone.jpg");
            if (this.stoneImage == null) {
                System.err.println("resources/images/stone.jpg not found");
                System.exit(1);
            }
            if (this.skyImage == null) {
                this.skyImage = Resources.getResource("resources/images/bg.jpg");
                if (this.skyImage == null) {
                    System.err.println("resources/images/bg.jpg not found");
                    System.exit(1);
                }
            }
        }
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(c, 1136);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.u.addBranchGraph(scene);
        this.choice = new Choice();
        this.choice.addItem("stone + light");
        this.choice.addItem("stone");
        this.choice.addItem("lightMap");
        this.choice.addItem("sky");
        this.choice.addItem("stone + sky");
        this.choice.addItemListener(this);
        this.add("North", this.choice);
    }

    public void destroy() {
        this.textureUnitState = new TextureUnitState[2];
        this.u.cleanup();
    }

    public void itemStateChanged(ItemEvent e) {
        int index = this.choice.getSelectedIndex();
        switch (index) {
            case 0: {
                this.textureUnitState[0].setTexture(this.stoneTex);
                this.textureUnitState[1].setTexture(this.lightTex);
                break;
            }
            case 1: {
                this.textureUnitState[0].setTexture(this.stoneTex);
                this.textureUnitState[1].setTexture(null);
                break;
            }
            case 2: {
                this.textureUnitState[0].setTexture(null);
                this.textureUnitState[1].setTexture(this.lightTex);
                break;
            }
            case 3: {
                this.textureUnitState[0].setTexture(null);
                this.textureUnitState[1].setTexture(this.skyTex);
                break;
            }
            case 4: {
                this.textureUnitState[0].setTexture(this.stoneTex);
                this.textureUnitState[1].setTexture(this.skyTex);
                break;
            }
        }
    }

    public static void main(String[] argv) {
        URL stoneURL = null;
        URL skyURL = null;
        stoneURL = Resources.getResource("resources/images/stone.jpg");
        if (stoneURL == null) {
            System.err.println("resources/images/stone.jpg not found");
            System.exit(1);
        }
        if ((skyURL = Resources.getResource("resources/images/bg.jpg")) == null) {
            System.err.println("resources/images/bg.jpg not found");
            System.exit(1);
        }
        new MainFrame((Applet)new MultiTextureTest(stoneURL, skyURL), 750, 750);
    }
}

