/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.texture;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.ScaleInterpolator;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.examples.Resources;

public class TextureImageNPOT
extends Applet {
    private static final String defaultFileName = "resources/images/Java3d.jpg";
    private URL texImage = null;
    private SimpleUniverse u = null;
    private boolean allowNonPowerOfTwo = true;
    private boolean mipmap = true;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        TransformGroup objScale = new TransformGroup();
        objScale.setCapability(18);
        objTrans.addChild((Node)objScale);
        Appearance app = new Appearance();
        int flags = 0;
        if (this.allowNonPowerOfTwo) {
            flags |= 8;
        }
        if (this.mipmap) {
            flags |= 1;
        }
        Texture tex = new TextureLoader(this.texImage, flags, (Component)this).getTexture();
        tex.setMagFilter(3);
        if (this.mipmap) {
            tex.setMinFilter(5);
        } else {
            tex.setMinFilter(3);
        }
        app.setTexture(tex);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        app.setTextureAttributes(texAttr);
        Box textureCube = new Box(0.4f, 0.4f, 0.4f, 2, app);
        objScale.addChild((Node)textureCube);
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 50000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        Alpha scaleAlpha = new Alpha(-1, 3, 0L, 0L, 8000L, 0L, 0L, 8000L, 0L, 0L);
        ScaleInterpolator scaler = new ScaleInterpolator(scaleAlpha, objScale, yAxis, 0.01f, 1.5f);
        scaler.setSchedulingBounds((Bounds)bounds);
        objScale.addChild((Node)scaler);
        objRoot.compile();
        return objRoot;
    }

    public TextureImageNPOT() {
    }

    public TextureImageNPOT(URL url) {
        this.texImage = url;
    }

    public void init() {
        if (this.texImage == null) {
            this.texImage = Resources.getResource(defaultFileName);
            if (this.texImage == null) {
                System.err.println("resources/images/Java3d.jpg not found");
                System.exit(1);
            }
        }
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        Map map = c.queryProperties();
        Boolean value = (Boolean)map.get("textureNonPowerOfTwoAvailable");
        String errorStr = null;
        if (value == null) {
            errorStr = "Canvas3D: textureNonPowerOfTwoAvailable property not found";
        } else if (!value.booleanValue()) {
            errorStr = "Non-power-of-two textures are not available";
        }
        if (errorStr != null) {
            String errorMessage = errorStr + "\n" + "You should expect to see a white cube as a result";
            JOptionPane.showMessageDialog(this, errorMessage, "Insufficient Capabilities", 0);
        }
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        URL url = null;
        if (args.length > 0) {
            try {
                url = new URL("file:" + args[0]);
            }
            catch (MalformedURLException ex) {
                System.out.println(ex.getMessage());
                System.exit(1);
            }
        } else {
            url = Resources.getResource(defaultFileName);
            if (url == null) {
                System.err.println("resources/images/Java3d.jpg not found");
                System.exit(1);
            }
        }
        new MainFrame((Applet)new TextureImageNPOT(url), 512, 512);
    }
}

