/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.texture_by_ref;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.texture_by_ref.AnimateTexturesBehavior;
import org.jdesktop.j3d.examples.texture_by_ref.ImageOps;
import org.jdesktop.j3d.examples.texture_by_ref.Tetrahedron;

public class TextureByReference
extends Applet
implements ItemListener,
ActionListener,
ChangeListener {
    private AnimateTexturesBehavior animate;
    private Tetrahedron tetra;
    private JCheckBox flipB;
    private JRadioButton texByRef;
    private JRadioButton texByCopy;
    private JRadioButton geomByRef;
    private JRadioButton geomByCopy;
    private JRadioButton img4ByteABGR;
    private JRadioButton img3ByteBGR;
    private JRadioButton imgIntARGB;
    private JRadioButton imgCustomRGBA;
    private JRadioButton imgCustomRGB;
    private JRadioButton yUp;
    private JRadioButton yDown;
    private JButton animationB;
    private JSlider frameDelay;
    private SimpleUniverse universe = null;
    public static final String[] defaultFiles = new String[]{"resources/images/animation1.gif", "resources/images/animation2.gif", "resources/images/animation3.gif", "resources/images/animation4.gif", "resources/images/animation5.gif", "resources/images/animation6.gif", "resources/images/animation7.gif", "resources/images/animation8.gif", "resources/images/animation9.gif", "resources/images/animation10.gif"};
    private URL[] urls = null;

    public TextureByReference() {
    }

    public TextureByReference(URL[] fnamesP) {
        this.urls = fnamesP;
    }

    public void init() {
        if (this.urls == null) {
            this.urls = new URL[defaultFiles.length];
            for (int i = 0; i < defaultFiles.length; ++i) {
                this.urls[i] = Resources.getResource(defaultFiles[i]);
                if (this.urls[i] != null) continue;
                System.err.println(defaultFiles[i] + " not found");
                System.exit(1);
            }
        }
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(config);
        this.add("Center", (Component)canvas);
        BranchGroup scene = this.createSceneGraph();
        this.universe = new SimpleUniverse(canvas);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.universe.addBranchGraph(scene);
        JPanel gui = this.buildGui();
        this.add("South", gui);
    }

    public void destroy() {
        this.universe.cleanup();
    }

    public JPanel buildGui() {
        this.flipB = new JCheckBox("flip image", true);
        this.flipB.addItemListener(this);
        Box flipBox = new Box(1);
        flipBox.add(this.flipB);
        Component strut1 = Box.createVerticalStrut(this.flipB.getPreferredSize().height);
        Component strut2 = Box.createVerticalStrut(this.flipB.getPreferredSize().height);
        Component strut3 = Box.createVerticalStrut(this.flipB.getPreferredSize().height);
        Component strut4 = Box.createVerticalStrut(this.flipB.getPreferredSize().height);
        Component strut5 = Box.createVerticalStrut(this.flipB.getPreferredSize().height);
        flipBox.add(strut1);
        flipBox.add(strut2);
        flipBox.add(strut3);
        flipBox.add(strut4);
        flipBox.add(strut5);
        this.yUp = new JRadioButton("y up");
        this.yUp.addActionListener(this);
        this.yUp.setSelected(true);
        this.yDown = new JRadioButton("y down");
        this.yDown.addActionListener(this);
        ButtonGroup yGroup = new ButtonGroup();
        yGroup.add(this.yUp);
        yGroup.add(this.yDown);
        JLabel yLabel = new JLabel("Image Orientation:");
        Box yBox = new Box(1);
        yBox.add(yLabel);
        yBox.add(this.yUp);
        yBox.add(this.yDown);
        strut1 = Box.createVerticalStrut(this.yUp.getPreferredSize().height);
        strut2 = Box.createVerticalStrut(this.yUp.getPreferredSize().height);
        strut3 = Box.createVerticalStrut(this.yUp.getPreferredSize().height);
        yBox.add(strut1);
        yBox.add(strut2);
        yBox.add(strut3);
        this.texByRef = new JRadioButton("by reference");
        this.texByRef.addActionListener(this);
        this.texByRef.setSelected(true);
        this.texByCopy = new JRadioButton("by copy");
        this.texByCopy.addActionListener(this);
        ButtonGroup texGroup = new ButtonGroup();
        texGroup.add(this.texByRef);
        texGroup.add(this.texByCopy);
        JLabel texLabel = new JLabel("Texture:*");
        Box texBox = new Box(1);
        texBox.add(texLabel);
        texBox.add(this.texByRef);
        texBox.add(this.texByCopy);
        strut1 = Box.createVerticalStrut(this.texByRef.getPreferredSize().height);
        strut2 = Box.createVerticalStrut(this.texByRef.getPreferredSize().height);
        strut3 = Box.createVerticalStrut(this.texByRef.getPreferredSize().height);
        texBox.add(strut1);
        texBox.add(strut2);
        texBox.add(strut3);
        this.geomByRef = new JRadioButton("by reference");
        this.geomByRef.addActionListener(this);
        this.geomByRef.setSelected(true);
        this.geomByCopy = new JRadioButton("by copy");
        this.geomByCopy.addActionListener(this);
        ButtonGroup geomGroup = new ButtonGroup();
        geomGroup.add(this.geomByRef);
        geomGroup.add(this.geomByCopy);
        JLabel geomLabel = new JLabel("Geometry:");
        Box geomBox = new Box(1);
        geomBox.add(geomLabel);
        geomBox.add(this.geomByRef);
        geomBox.add(this.geomByCopy);
        strut1 = Box.createVerticalStrut(this.geomByRef.getPreferredSize().height);
        strut2 = Box.createVerticalStrut(this.geomByRef.getPreferredSize().height);
        strut3 = Box.createVerticalStrut(this.geomByRef.getPreferredSize().height);
        geomBox.add(strut1);
        geomBox.add(strut2);
        geomBox.add(strut3);
        this.img4ByteABGR = new JRadioButton("TYPE_4BYTE_ABGR");
        this.img4ByteABGR.addActionListener(this);
        this.img4ByteABGR.setSelected(true);
        this.img3ByteBGR = new JRadioButton("TYPE_3BYTE_BGR");
        this.img3ByteBGR.addActionListener(this);
        this.imgIntARGB = new JRadioButton("TYPE_INT_ARGB");
        this.imgIntARGB.addActionListener(this);
        this.imgCustomRGBA = new JRadioButton("TYPE_CUSTOM RGBA");
        this.imgCustomRGBA.addActionListener(this);
        this.imgCustomRGB = new JRadioButton("TYPE_CUSTOM RGB");
        this.imgCustomRGB.addActionListener(this);
        ButtonGroup imgGroup = new ButtonGroup();
        imgGroup.add(this.img4ByteABGR);
        imgGroup.add(this.img3ByteBGR);
        imgGroup.add(this.imgIntARGB);
        imgGroup.add(this.imgCustomRGBA);
        imgGroup.add(this.imgCustomRGB);
        JLabel imgLabel = new JLabel("Image Type:*");
        Box imgBox = new Box(1);
        imgBox.add(imgLabel);
        imgBox.add(this.img4ByteABGR);
        imgBox.add(this.img3ByteBGR);
        imgBox.add(this.imgIntARGB);
        imgBox.add(this.imgCustomRGBA);
        imgBox.add(this.imgCustomRGB);
        Box topBox = new Box(0);
        topBox.add(flipBox);
        topBox.add(texBox);
        topBox.add(geomBox);
        topBox.add(yBox);
        Component strut = Box.createRigidArea(new Dimension(10, 10));
        topBox.add(strut);
        topBox.add(imgBox);
        this.frameDelay = new JSlider(0, 50, 0);
        this.frameDelay.addChangeListener(this);
        this.frameDelay.setSnapToTicks(true);
        this.frameDelay.setPaintTicks(true);
        this.frameDelay.setPaintLabels(true);
        this.frameDelay.setMajorTickSpacing(10);
        this.frameDelay.setMinorTickSpacing(1);
        this.frameDelay.setValue(20);
        JLabel delayL = new JLabel("frame delay");
        Box delayBox = new Box(0);
        delayBox.add(delayL);
        delayBox.add(this.frameDelay);
        this.animationB = new JButton(" stop animation ");
        this.animationB.addActionListener(this);
        JLabel texInfo1 = new JLabel("*To use ImageComponent by reference feature, use TYPE_4BYTE_ABGR on Solaris");
        JLabel texInfo2 = new JLabel("and TYPE_3BYTE_BGR on Windows");
        JPanel buttonP = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        buttonP.setLayout(gridbag);
        c.anchor = 10;
        c.gridwidth = 0;
        gridbag.setConstraints(topBox, c);
        buttonP.add(topBox);
        gridbag.setConstraints(delayBox, c);
        buttonP.add(delayBox);
        gridbag.setConstraints(this.animationB, c);
        buttonP.add(this.animationB);
        gridbag.setConstraints(texInfo1, c);
        buttonP.add(texInfo1);
        gridbag.setConstraints(texInfo2, c);
        buttonP.add(texInfo2);
        return buttonP;
    }

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        Transform3D rotate = new Transform3D();
        TransformGroup objTrans = new TransformGroup(rotate);
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Vector3f lDir1 = new Vector3f(-1.0f, -0.5f, -1.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds((Bounds)bounds);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)aLgt);
        objRoot.addChild((Node)lgt1);
        Appearance appearance = new Appearance();
        appearance.setCapability(3);
        TextureLoader loader = new TextureLoader(this.urls[0], 6, (Component)this);
        Texture2D tex = (Texture2D)loader.getTexture();
        ImageComponent2D imageComp = (ImageComponent2D)tex.getImage(0);
        BufferedImage bImage = imageComp.getImage();
        bImage = ImageOps.convertImage(bImage, 6);
        ImageOps.flipImage(bImage);
        imageComp.set(bImage);
        tex.setCapability(7);
        tex.setBoundaryModeS(2);
        tex.setBoundaryModeT(2);
        tex.setBoundaryColor(1.0f, 1.0f, 1.0f, 1.0f);
        tex.setImage(0, (ImageComponent)imageComp);
        appearance.setTexture((Texture)tex);
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        appearance.setTextureAttributes(texAttr);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        appearance.setMaterial(new Material(white, black, white, black, 1.0f));
        Transform3D scale = new Transform3D();
        scale.set(0.6);
        TransformGroup objScale = new TransformGroup(scale);
        objTrans.addChild((Node)objScale);
        this.tetra = new Tetrahedron(true);
        this.tetra.setAppearance(appearance);
        objScale.addChild((Node)this.tetra);
        this.animate = new AnimateTexturesBehavior(tex, this.urls, appearance, this);
        this.animate.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)this.animate);
        Transform3D yAxis = new Transform3D();
        Alpha rotorAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotorAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        objRoot.compile();
        return objRoot;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.animationB) {
            if (this.animate.getEnable()) {
                this.animate.setEnable(false);
                this.animationB.setText("start animation");
            } else {
                this.animate.setEnable(true);
                this.animationB.setText(" stop animation ");
            }
        } else if (o == this.texByRef && this.texByRef.isSelected()) {
            this.animate.setByReference(true);
        } else if (o == this.texByCopy && this.texByCopy.isSelected()) {
            this.animate.setByReference(false);
        } else if (o == this.yUp && this.yUp.isSelected()) {
            this.animate.setYUp(true);
        } else if (o == this.yDown && this.yDown.isSelected()) {
            this.animate.setYUp(false);
        } else if (o == this.geomByRef) {
            this.tetra.setByReference(true);
        } else if (o == this.geomByCopy) {
            this.tetra.setByReference(false);
        } else if (o == this.imgIntARGB) {
            this.animate.setImageType(2);
        } else if (o == this.img4ByteABGR) {
            this.animate.setImageType(6);
        } else if (o == this.img3ByteBGR) {
            this.animate.setImageType(5);
        } else if (o == this.imgCustomRGBA) {
            this.animate.setImageTypeCustomRGBA();
        } else if (o == this.imgCustomRGB) {
            this.animate.setImageTypeCustomRGB();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object o = e.getSource();
        if (o == this.flipB) {
            if (e.getStateChange() == 2) {
                this.animate.setFlipImages(false);
            } else {
                this.animate.setFlipImages(true);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o == this.frameDelay) {
            this.animate.setFrameDelay(this.frameDelay.getValue());
        }
    }

    public static void main(String[] args) {
        URL[] fnames = null;
        if (args.length > 1) {
            fnames = new URL[args.length];
            for (int i = 0; i < args.length; ++i) {
                try {
                    fnames[i] = new URL("file:" + args[i]);
                    continue;
                }
                catch (MalformedURLException ex) {
                    System.out.println(ex.getMessage());
                }
            }
        } else {
            fnames = new URL[defaultFiles.length];
            for (int i = 0; i < defaultFiles.length; ++i) {
                fnames[i] = Resources.getResource(defaultFiles[i]);
                if (fnames[i] != null) continue;
                System.err.println(defaultFiles[i] + " not found");
                System.exit(1);
            }
        }
        new MainFrame((Applet)new TextureByReference(fnames), 650, 750);
    }
}

