/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.virtual_input_device;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.media.j3d.InputDevice;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.virtual_input_device.PositionControls;

public class ButtonPositionControls
extends Panel
implements PositionControls,
MouseListener {
    private static final int STILL = 0;
    private static final int MOVING_UP = 1;
    private static final int MOVING_DOWN = 2;
    private static final int MOVING_LEFT = 3;
    private static final int MOVING_RIGHT = 4;
    private static final int MOVING_FORWARD = 5;
    private static final int MOVING_BACK = 6;
    private int mode = 0;
    Vector3f position = new Vector3f();
    Vector3f orig_position = new Vector3f();
    private Button leftB = new Button("Move Left");
    private Button rightB = new Button("Move Right");
    private Button upB = new Button("Move Up");
    private Button downB = new Button("Move Down");
    private Button forwardB = new Button("Move Forward");
    private Button backwardB = new Button("Move Back");
    private Button reset = new Button("Reset");
    private InputDevice device;
    private float step_rate = 0.0023f;
    private long time_last_state_change = System.currentTimeMillis();

    public ButtonPositionControls(float x, float y, float z) {
        Panel panPanel = new Panel();
        panPanel.setLayout(new BorderLayout());
        panPanel.add("North", this.upB);
        panPanel.add("East", this.rightB);
        panPanel.add("South", this.downB);
        panPanel.add("West", this.leftB);
        Panel p = new Panel();
        p.setLayout(new GridLayout(0, 1, 0, 0));
        p.add(this.forwardB);
        p.add(this.backwardB);
        p.add(this.reset);
        this.position.x = x;
        this.position.y = y;
        this.position.z = z;
        this.orig_position.set((Tuple3f)this.position);
        this.upB.addMouseListener(this);
        this.downB.addMouseListener(this);
        this.leftB.addMouseListener(this);
        this.rightB.addMouseListener(this);
        this.forwardB.addMouseListener(this);
        this.backwardB.addMouseListener(this);
        this.reset.addMouseListener(this);
        this.setLayout(new BorderLayout());
        this.add("East", p);
        this.add("West", panPanel);
    }

    public void setDevice(InputDevice device) {
        this.device = device;
    }

    public void getPosition(Vector3f pos) {
        this.calculateMotion();
        pos.set((Tuple3f)this.position);
    }

    public void setPosition(Vector3f pos) {
        this.position.set((Tuple3f)pos);
    }

    public void setStepRate(float stepRate) {
        this.step_rate = stepRate;
    }

    private void calculateMotion() {
        long current_time = System.currentTimeMillis();
        long elapsed_time = current_time - this.time_last_state_change;
        switch (this.mode) {
            case 0: {
                break;
            }
            case 3: {
                this.position.x = this.orig_position.x - this.step_rate * (float)elapsed_time;
                break;
            }
            case 4: {
                this.position.x = this.orig_position.x + this.step_rate * (float)elapsed_time;
                break;
            }
            case 1: {
                this.position.y = this.orig_position.y + this.step_rate * (float)elapsed_time;
                break;
            }
            case 2: {
                this.position.y = this.orig_position.y - this.step_rate * (float)elapsed_time;
                break;
            }
            case 5: {
                this.position.z = this.orig_position.z - this.step_rate * (float)elapsed_time;
                break;
            }
            case 6: {
                this.position.z = this.orig_position.z + this.step_rate * (float)elapsed_time;
                break;
            }
            default: {
                throw new RuntimeException("Unknown motion");
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.leftB && this.mode != 3) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 3;
            this.orig_position.set((Tuple3f)this.position);
        } else if (e.getSource() == this.rightB && this.mode != 4) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 4;
            this.orig_position.set((Tuple3f)this.position);
        } else if (e.getSource() == this.upB && this.mode != 1) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 1;
            this.orig_position.set((Tuple3f)this.position);
        } else if (e.getSource() == this.downB && this.mode != 2) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 2;
            this.orig_position.set((Tuple3f)this.position);
        } else if (e.getSource() == this.forwardB && this.mode != 5) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 5;
            this.orig_position.set((Tuple3f)this.position);
        } else if (e.getSource() == this.backwardB && this.mode != 6) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 6;
            this.orig_position.set((Tuple3f)this.position);
        } else if (e.getSource() == this.reset) {
            this.device.setNominalPositionAndOrientation();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mode = 0;
    }
}

