/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.alternate_appearance;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.AlternateAppearance;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.alternate_appearance.SphereGroup;

public class AlternateAppearanceBoundsTest
extends JApplet
implements ActionListener {
    Material mat1;
    Material altMat;
    Appearance app;
    Appearance otherApp;
    JComboBox altAppMaterialColor;
    JComboBox appMaterialColor;
    JCheckBox useBoundingLeaf;
    JCheckBox override;
    JComboBox boundsType;
    private Group content1 = null;
    AlternateAppearance altApp;
    Shape3D[] shapes1;
    boolean boundingLeafOn = false;
    Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
    Color3f green = new Color3f(0.0f, 1.0f, 0.0f);
    Color3f blue = new Color3f(0.0f, 0.0f, 1.0f);
    Color3f[] colors = new Color3f[]{this.white, this.red, this.green, this.blue};
    private Bounds worldBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
    private Bounds smallBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 0.25);
    private Bounds tinyBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 0.05);
    private BoundingLeaf leafBounds = null;
    private int currentBounds = 2;
    private Bounds[] allBounds = new Bounds[]{this.tinyBounds, this.smallBounds, this.worldBounds};
    DirectionalLight light1 = null;
    private int currentPosition = 0;
    private SimpleUniverse u = null;

    public void init() {
        Container contentPane = this.getContentPane();
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        contentPane.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
        JPanel p = new JPanel();
        BoxLayout boxlayout = new BoxLayout(p, 1);
        p.add(this.createBoundsPanel());
        p.add(this.createMaterialPanel());
        p.setLayout(boxlayout);
        contentPane.add("South", p);
    }

    public void destroy() {
        this.u.cleanup();
    }

    BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.otherApp = new Appearance();
        this.altMat = new Material();
        this.altMat.setCapability(1);
        this.altMat.setDiffuseColor(new Color3f(0.0f, 1.0f, 0.0f));
        this.otherApp.setMaterial(this.altMat);
        this.altApp = new AlternateAppearance();
        this.altApp.setAppearance(this.otherApp);
        this.altApp.setCapability(4);
        this.altApp.setCapability(13);
        this.altApp.setInfluencingBounds(this.worldBounds);
        objRoot.addChild((Node)this.altApp);
        Appearance app1 = new Appearance();
        this.mat1 = new Material();
        this.mat1.setCapability(1);
        this.mat1.setDiffuseColor(new Color3f(1.0f, 0.0f, 0.0f));
        app1.setMaterial(this.mat1);
        this.content1 = new SphereGroup(0.05f, 0.15f, 0.15f, 5, 5, app1, true);
        objRoot.addChild((Node)this.content1);
        this.shapes1 = ((SphereGroup)this.content1).getShapes();
        this.light1 = new DirectionalLight();
        this.light1.setEnable(true);
        this.light1.setColor(new Color3f(0.2f, 0.2f, 0.2f));
        this.light1.setDirection(new Vector3f(1.0f, 0.0f, -1.0f));
        this.light1.setInfluencingBounds(this.worldBounds);
        this.light1.setCapability(17);
        this.light1.setCapability(4);
        objRoot.addChild((Node)this.light1);
        AmbientLight ambient = new AmbientLight();
        ambient.setEnable(true);
        ambient.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        ambient.setInfluencingBounds(this.worldBounds);
        objRoot.addChild((Node)ambient);
        this.leafBounds = new BoundingLeaf(this.allBounds[this.currentBounds]);
        this.leafBounds.setCapability(13);
        objRoot.addChild((Node)this.leafBounds);
        if (this.boundingLeafOn) {
            this.altApp.setInfluencingBoundingLeaf(this.leafBounds);
        } else {
            this.altApp.setInfluencingBounds(this.allBounds[this.currentBounds]);
        }
        return objRoot;
    }

    JPanel createBoundsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Scopes"));
        String[] boundsValues = new String[]{"Tiny Bounds", "Small Bounds", "Big Bounds"};
        this.boundsType = new JComboBox<String>(boundsValues);
        this.boundsType.addActionListener(this);
        this.boundsType.setSelectedIndex(2);
        panel.add(new JLabel("Bounds"));
        panel.add(this.boundsType);
        this.useBoundingLeaf = new JCheckBox("Enable BoundingLeaf", this.boundingLeafOn);
        this.useBoundingLeaf.addActionListener(this);
        panel.add(this.useBoundingLeaf);
        this.override = new JCheckBox("Enable App Override", false);
        this.override.addActionListener(this);
        panel.add(this.override);
        return panel;
    }

    JPanel createMaterialPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Appearance Attributes"));
        String[] colorVals = new String[]{"WHITE", "RED", "GREEN", "BLUE"};
        this.altAppMaterialColor = new JComboBox<String>(colorVals);
        this.altAppMaterialColor.addActionListener(this);
        this.altAppMaterialColor.setSelectedIndex(2);
        panel.add(new JLabel("Alternate Appearance MaterialColor"));
        panel.add(this.altAppMaterialColor);
        this.appMaterialColor = new JComboBox<String>(colorVals);
        this.appMaterialColor.addActionListener(this);
        this.appMaterialColor.setSelectedIndex(1);
        panel.add(new JLabel("Normal Appearance MaterialColor"));
        panel.add(this.appMaterialColor);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.altAppMaterialColor) {
            this.altMat.setDiffuseColor(this.colors[this.altAppMaterialColor.getSelectedIndex()]);
        } else if (target == this.useBoundingLeaf) {
            this.boundingLeafOn = this.useBoundingLeaf.isSelected();
            if (this.boundingLeafOn) {
                this.leafBounds.setRegion(this.allBounds[this.currentBounds]);
                this.altApp.setInfluencingBoundingLeaf(this.leafBounds);
            } else {
                this.altApp.setInfluencingBoundingLeaf(null);
                this.altApp.setInfluencingBounds(this.allBounds[this.currentBounds]);
            }
        } else if (target == this.boundsType) {
            this.currentBounds = this.boundsType.getSelectedIndex();
            if (this.boundingLeafOn) {
                this.leafBounds.setRegion(this.allBounds[this.currentBounds]);
                this.altApp.setInfluencingBoundingLeaf(this.leafBounds);
            } else {
                this.altApp.setInfluencingBoundingLeaf(null);
                this.altApp.setInfluencingBounds(this.allBounds[this.currentBounds]);
            }
        } else if (target == this.override) {
            for (int i = 0; i < this.shapes1.length; ++i) {
                this.shapes1[i].setAppearanceOverrideEnable(this.override.isSelected());
            }
        } else if (target == this.appMaterialColor) {
            this.mat1.setDiffuseColor(this.colors[this.appMaterialColor.getSelectedIndex()]);
        }
    }

    public static void main(String[] args) {
        MainFrame frame = new MainFrame((Applet)new AlternateAppearanceBoundsTest(), 800, 800);
    }
}

