/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.appearance;

import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.appearance.Tetrahedron;

public class AppearanceTest
extends JFrame {
    private URL texImage = null;
    private URL bgImage = null;
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private JPanel drawingPanel;

    private BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        TextureLoader bgTexture = new TextureLoader(this.bgImage, (Component)this);
        Background bg = new Background(bgTexture.getImage());
        bg.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bg);
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Vector3f lDir1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds((Bounds)bounds);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)aLgt);
        objRoot.addChild((Node)lgt1);
        Appearance[][] app = new Appearance[3][3];
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                app[row][col] = this.createAppearance(row * 3 + col);
            }
        }
        for (int i = 0; i < 3; ++i) {
            double ypos = (double)(i - 1) * 0.6;
            for (int j = 0; j < 3; ++j) {
                double xpos = (double)(j - 1) * 0.6;
                objRoot.addChild((Node)this.createObject(app[i][j], 0.12, xpos, ypos));
            }
        }
        objRoot.compile();
        return objRoot;
    }

    private Appearance createAppearance(int idx) {
        Appearance app = new Appearance();
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        switch (idx) {
            case 0: {
                Color3f objColor = new Color3f(1.0f, 0.2f, 0.4f);
                ColoringAttributes ca = new ColoringAttributes();
                ca.setColor(objColor);
                app.setColoringAttributes(ca);
                break;
            }
            case 1: {
                Color3f objColor = new Color3f(0.5f, 0.0f, 0.2f);
                ColoringAttributes ca = new ColoringAttributes();
                ca.setColor(objColor);
                app.setColoringAttributes(ca);
                PolygonAttributes pa = new PolygonAttributes();
                pa.setPolygonMode(1);
                pa.setCullFace(0);
                app.setPolygonAttributes(pa);
                break;
            }
            case 2: {
                Color3f objColor = new Color3f(0.2f, 0.2f, 1.0f);
                ColoringAttributes ca = new ColoringAttributes();
                ca.setColor(objColor);
                app.setColoringAttributes(ca);
                PolygonAttributes pa = new PolygonAttributes();
                pa.setPolygonMode(0);
                pa.setCullFace(0);
                app.setPolygonAttributes(pa);
                PointAttributes pta = new PointAttributes();
                pta.setPointSize(5.0f);
                app.setPointAttributes(pta);
                break;
            }
            case 3: {
                Color3f objColor = new Color3f(0.8f, 0.0f, 0.0f);
                app.setMaterial(new Material(objColor, black, objColor, white, 80.0f));
                break;
            }
            case 4: {
                TextureLoader tex = new TextureLoader(this.texImage, (Component)this);
                app.setTexture(tex.getTexture());
                TextureAttributes texAttr = new TextureAttributes();
                texAttr.setTextureMode(2);
                app.setTextureAttributes(texAttr);
                app.setMaterial(new Material(white, black, white, black, 1.0f));
                break;
            }
            case 5: {
                TransparencyAttributes ta = new TransparencyAttributes();
                ta.setTransparencyMode(2);
                ta.setTransparency(0.6f);
                app.setTransparencyAttributes(ta);
                PolygonAttributes pa = new PolygonAttributes();
                pa.setCullFace(0);
                app.setPolygonAttributes(pa);
                Color3f objColor = new Color3f(0.7f, 0.8f, 1.0f);
                app.setMaterial(new Material(objColor, black, objColor, black, 1.0f));
                break;
            }
            case 6: {
                Color3f objColor = new Color3f(0.8f, 0.0f, 0.0f);
                app.setMaterial(new Material(objColor, black, objColor, black, 80.0f));
                break;
            }
            case 7: {
                Color3f objColor = new Color3f(0.8f, 0.0f, 0.0f);
                app.setMaterial(new Material(black, black, black, white, 80.0f));
                break;
            }
            case 8: {
                Color3f objColor = new Color3f(0.8f, 0.8f, 0.0f);
                app.setMaterial(new Material(objColor, black, objColor, white, 80.0f));
                break;
            }
            default: {
                ColoringAttributes ca = new ColoringAttributes();
                ca.setColor(new Color3f(0.0f, 1.0f, 0.0f));
                app.setColoringAttributes(ca);
            }
        }
        return app;
    }

    private Group createObject(Appearance app, double scale, double xpos, double ypos) {
        Transform3D t = new Transform3D();
        t.set(scale, new Vector3d(xpos, ypos, 0.0));
        TransformGroup objTrans = new TransformGroup(t);
        TransformGroup spinTg = new TransformGroup();
        spinTg.setCapability(18);
        Tetrahedron shape = new Tetrahedron();
        shape.setAppearance(app);
        spinTg.addChild((Node)shape);
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 5000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, spinTg, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        objTrans.addChild((Node)spinTg);
        return objTrans;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public AppearanceTest() {
        if (this.bgImage == null) {
            this.bgImage = Resources.getResource("resources/images/bg.jpg");
            if (this.bgImage == null) {
                System.err.println("resources/images/bg.jpg not found");
                System.exit(1);
            }
        }
        if (this.texImage == null) {
            this.texImage = Resources.getResource("resources/images/stone.jpg");
            if (this.texImage == null) {
                System.err.println("resources/images/stone.jpg not found");
                System.exit(1);
            }
        }
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("AppearanceTest");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new AppearanceTest().setVisible(true);
            }
        });
    }
}

