/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.background;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;

public class BackgroundGeometry
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private URL bgImage = null;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
    private JPanel drawingPanel;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objScale.addChild((Node)objTrans);
        Background bg = new Background();
        bg.setApplicationBounds((Bounds)this.bounds);
        BranchGroup backGeoBranch = new BranchGroup();
        Sphere sphereObj = new Sphere(1.0f, 7, 45);
        Appearance backgroundApp = sphereObj.getAppearance();
        backGeoBranch.addChild((Node)sphereObj);
        bg.setGeometry(backGeoBranch);
        objTrans.addChild((Node)bg);
        TextureLoader tex = new TextureLoader(this.bgImage, new String("RGB"), (Component)this);
        if (tex != null) {
            backgroundApp.setTexture(tex.getTexture());
        }
        Vector3f tranlation = new Vector3f(2.0f, 0.0f, 0.0f);
        Transform3D modelTransform = new Transform3D();
        Transform3D tmpTransform = new Transform3D();
        double angleInc = 0.39269908169872414;
        double angle = 0.0;
        int numBoxes = 16;
        float[] scaleX = new float[]{0.1f, 0.2f, 0.2f, 0.3f, 0.2f, 0.1f, 0.2f, 0.3f, 0.1f, 0.3f, 0.2f, 0.3f, 0.1f, 0.3f, 0.2f, 0.3f};
        float[] scaleY = new float[]{0.3f, 0.4f, 0.3f, 0.4f, 0.3f, 0.4f, 0.3f, 0.4f, 0.3f, 0.3f, 0.3f, 0.3f, 0.3f, 0.3f, 0.3f, 0.4f};
        float[] scaleZ = new float[]{0.3f, 0.2f, 0.1f, 0.1f, 0.3f, 0.2f, 0.1f, 0.3f, 0.3f, 0.2f, 0.1f, 0.3f, 0.3f, 0.2f, 0.1f, 0.2f};
        Appearance a1 = new Appearance();
        Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f sColor = new Color3f(0.5f, 0.5f, 1.0f);
        Color3f oColor = new Color3f(0.5f, 0.5f, 0.3f);
        Material m = new Material(oColor, eColor, oColor, sColor, 100.0f);
        m.setLightingEnable(true);
        a1.setMaterial(m);
        int i = 0;
        while (i < numBoxes) {
            modelTransform.rotY(angle);
            tmpTransform.set(tranlation);
            modelTransform.mul(tmpTransform);
            TransformGroup tgroup = new TransformGroup(modelTransform);
            objTrans.addChild((Node)tgroup);
            tgroup.addChild((Node)new Box(scaleX[i], scaleY[i], scaleZ[i], 1, a1));
            ++i;
            angle += angleInc;
        }
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Color3f lColor2 = new Color3f(0.2f, 0.2f, 0.1f);
        Vector3f lDir1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        Vector3f lDir2 = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        DirectionalLight lgt2 = new DirectionalLight(lColor2, lDir2);
        lgt1.setInfluencingBounds((Bounds)this.bounds);
        lgt2.setInfluencingBounds((Bounds)this.bounds);
        objScale.addChild((Node)lgt1);
        objScale.addChild((Node)lgt2);
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        TransformGroup viewTrans = this.univ.getViewingPlatform().getViewPlatformTransform();
        MouseRotate behavior1 = new MouseRotate(viewTrans);
        this.scene.addChild((Node)behavior1);
        behavior1.setSchedulingBounds((Bounds)this.bounds);
        MouseZoom behavior2 = new MouseZoom(viewTrans);
        this.scene.addChild((Node)behavior2);
        behavior2.setSchedulingBounds((Bounds)this.bounds);
        MouseTranslate behavior3 = new MouseTranslate(viewTrans);
        this.scene.addChild((Node)behavior3);
        behavior3.setSchedulingBounds((Bounds)this.bounds);
        return c;
    }

    public BackgroundGeometry() {
        if (this.bgImage == null) {
            this.bgImage = Resources.getResource("resources/images/bg.jpg");
            if (this.bgImage == null) {
                System.err.println("resources/images/bg.jpg not found");
                System.exit(1);
            }
        }
        this.initComponents();
        this.scene = this.createSceneGraph();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene.compile();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("BackgroundGeometry");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setOpaque(false);
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new BackgroundGeometry().setVisible(true);
            }
        });
    }
}

