/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.cg_shader;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.shader.StringIO;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.io.IOException;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CgShaderProgram;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shader;
import javax.media.j3d.ShaderAppearance;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderAttributeValue;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderErrorListener;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.SourceCodeShader;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Vector4f;
import org.jdesktop.j3d.examples.Resources;

public class SamplerTestCg
extends JFrame {
    private static String cloudTexName = "resources/images/bg.jpg";
    private static String earthTexName = "resources/images/earth.jpg";
    private static String fragmentProgName = "cg_shader/multitex_fp.cg";
    private URL cloudURL = null;
    private URL earthURL = null;
    private static final int CLOUD = 0;
    private static final int EARTH = 1;
    SimpleUniverse univ = null;
    private JPanel drawingPanel;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        this.cloudURL = Resources.getResource(cloudTexName);
        Texture cloudTex = new TextureLoader(this.cloudURL, (Component)this).getTexture();
        this.earthURL = Resources.getResource(earthTexName);
        Texture earthTex = new TextureLoader(this.earthURL, (Component)this).getTexture();
        Object vertexProgram = null;
        String fragmentProgram = null;
        try {
            fragmentProgram = StringIO.readFully((URL)Resources.getResource(fragmentProgName));
        }
        catch (IOException e) {
            System.err.println(e);
        }
        Shader[] shaders = new Shader[]{new SourceCodeShader(2, 2, fragmentProgram)};
        String[] shaderAttrNames = new String[]{"cloudFactor"};
        Object[] shaderAttrValues = new Object[]{new Float(0.6f)};
        CgShaderProgram shaderProgram = new CgShaderProgram();
        shaderProgram.setShaders(shaders);
        shaderProgram.setShaderAttrNames(shaderAttrNames);
        ShaderAttributeSet shaderAttributeSet = new ShaderAttributeSet();
        for (int i = 0; i < shaderAttrNames.length; ++i) {
            ShaderAttributeValue shaderAttribute = new ShaderAttributeValue(shaderAttrNames[i], shaderAttrValues[i]);
            shaderAttributeSet.put((ShaderAttribute)shaderAttribute);
        }
        ShaderAppearance app = new ShaderAppearance();
        app.setShaderProgram((ShaderProgram)shaderProgram);
        app.setShaderAttributeSet(shaderAttributeSet);
        Vector4f plane0S = new Vector4f(3.0f, 1.5f, 0.3f, 0.0f);
        Vector4f plane0T = new Vector4f(1.0f, 2.5f, 0.24f, 0.0f);
        TexCoordGeneration tcg0 = new TexCoordGeneration(0, 0, plane0S, plane0T);
        TexCoordGeneration tcg1 = new TexCoordGeneration(2, 0);
        TextureUnitState[] tus = new TextureUnitState[2];
        tus[0] = new TextureUnitState();
        tus[0].setTexture(cloudTex);
        tus[0].setTexCoordGeneration(tcg0);
        tus[1] = new TextureUnitState();
        tus[1].setTexture(earthTex);
        tus[1].setTexCoordGeneration(tcg1);
        app.setTextureUnitState(tus);
        Sphere sph = new Sphere(0.4f, 1, 30, (Appearance)app);
        objTrans.addChild((Node)sph);
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 4000L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)rotator);
        return objRoot;
    }

    private Canvas3D initScene() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        BranchGroup scene = this.createSceneGraph();
        this.univ = new SimpleUniverse(c);
        this.univ.addShaderErrorListener(new ShaderErrorListener(){

            public void errorOccurred(ShaderError error) {
                error.printVerbose();
                JOptionPane.showMessageDialog(SamplerTestCg.this, error.toString(), "ShaderError", 0);
            }
        });
        ViewingPlatform viewingPlatform = this.univ.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        this.univ.addBranchGraph(scene);
        return c;
    }

    public SamplerTestCg() {
        this.initComponents();
        Canvas3D c = this.initScene();
        this.drawingPanel.add((Component)c, "Center");
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("SamplerTestCg");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SamplerTestCg().setVisible(true);
            }
        });
    }
}

