/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.collision;

import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnCollisionEntry;
import javax.media.j3d.WakeupOnCollisionExit;
import javax.vecmath.Color3f;

public class CollisionDetector
extends Behavior {
    private static final Color3f highlightColor = new Color3f(0.0f, 1.0f, 0.0f);
    private static final ColoringAttributes highlight = new ColoringAttributes(highlightColor, 3);
    private boolean inCollision = false;
    private Shape3D shape;
    private ColoringAttributes shapeColoring;
    private Appearance shapeAppearance;
    private WakeupOnCollisionEntry wEnter;
    private WakeupOnCollisionExit wExit;

    public CollisionDetector(Shape3D s) {
        this.shape = s;
        this.shapeAppearance = this.shape.getAppearance();
        this.shapeColoring = this.shapeAppearance.getColoringAttributes();
        this.inCollision = false;
    }

    public void initialize() {
        this.wEnter = new WakeupOnCollisionEntry((Node)this.shape);
        this.wExit = new WakeupOnCollisionExit((Node)this.shape);
        this.wakeupOn((WakeupCondition)this.wEnter);
    }

    public void processStimulus(Enumeration criteria) {
        boolean bl = this.inCollision = !this.inCollision;
        if (this.inCollision) {
            this.shapeAppearance.setColoringAttributes(highlight);
            this.wakeupOn((WakeupCondition)this.wExit);
        } else {
            this.shapeAppearance.setColoringAttributes(this.shapeColoring);
            this.wakeupOn((WakeupCondition)this.wEnter);
        }
    }
}

