/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.collision;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.examples.collision.Box;
import org.jdesktop.j3d.examples.collision.CollisionDetector;

public class TickTockCollision
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private JPanel drawingPanel;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objScale.addChild((Node)bg);
        TransformGroup objTrans1 = new TransformGroup();
        objTrans1.setCapability(18);
        objScale.addChild((Node)objTrans1);
        TransformGroup objTrans2 = new TransformGroup();
        objTrans2.setCapability(18);
        objTrans1.addChild((Node)objTrans2);
        Transform3D t = new Transform3D();
        t.set(0.3, new Vector3d(0.0, -1.5, 0.0));
        TransformGroup objTrans3 = new TransformGroup(t);
        objTrans2.addChild((Node)objTrans3);
        objTrans3.addChild((Node)new ColorCube());
        Transform3D yAxis1 = new Transform3D();
        yAxis1.rotX(1.5707963267948966);
        Alpha tickTockAlpha = new Alpha(-1, 3, 0L, 0L, 5000L, 2500L, 200L, 5000L, 2500L, 200L);
        RotationInterpolator tickTock = new RotationInterpolator(tickTockAlpha, objTrans1, yAxis1, -1.5707964f, 1.5707964f);
        tickTock.setSchedulingBounds((Bounds)bounds);
        objTrans2.addChild((Node)tickTock);
        Transform3D yAxis2 = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans2, yAxis2, 0.0f, (float)Math.PI * 2);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans2.addChild((Node)rotator);
        Group box1 = this.createBox(0.3, new Vector3d(-1.3, 0.0, 0.0));
        Group box2 = this.createBox(0.3, new Vector3d(1.3, 0.0, 0.0));
        objScale.addChild((Node)box1);
        objScale.addChild((Node)box2);
        objRoot.compile();
        return objRoot;
    }

    private Group createBox(double scale, Vector3d pos) {
        Transform3D t = new Transform3D();
        t.set(scale, pos);
        TransformGroup objTrans = new TransformGroup(t);
        Box shape = new Box(0.5, 5.0, 1.0);
        objTrans.addChild((Node)shape);
        Appearance app = shape.getAppearance();
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(0.6f, 0.3f, 0.0f);
        app.setCapability(9);
        app.setColoringAttributes(ca);
        CollisionDetector cd = new CollisionDetector(shape);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        cd.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)cd);
        return objTrans;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public TickTockCollision() {
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("TickTockCollision");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TickTockCollision().setVisible(true);
            }
        });
    }
}

