/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.depth_func;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.ScaleInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.depth_func.DepthFuncTest;

public class RenderFrame
extends JFrame {
    DepthFuncTest dpt;
    SimpleUniverse su;
    RenderingAttributes staticWFBoxRA;
    RenderingAttributes staticBoxRA;
    RenderingAttributes rotatingBoxRA;

    public RenderFrame(DepthFuncTest _dpt) {
        this.dpt = _dpt;
        this.initComponents();
        this.initUniverse();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("J3D frame");
        this.setBounds(400, 0, 640, 480);
    }

    void initUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        this.su = new SimpleUniverse(c);
        this.su.addBranchGraph(this.createScene());
        c.getView().setMinimumFrameCycleTime(10L);
    }

    BranchGroup createScene() {
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        BranchGroup globalBG = new BranchGroup();
        BranchGroup rotObjectBG = new BranchGroup();
        OrderedGroup staticObjectOG = new OrderedGroup();
        BranchGroup lampsBG = new BranchGroup();
        OrderedGroup oGroup = new OrderedGroup();
        TransformGroup staticBoxRotTG = new TransformGroup();
        staticBoxRotTG.addChild((Node)staticObjectOG);
        TransformGroup objectsTGRot = new TransformGroup();
        TransformGroup objectsTGTrans = new TransformGroup();
        Transform3D objectsTGTransT3d = new Transform3D();
        objectsTGTransT3d.setTranslation(new Vector3f(0.0f, 0.0f, -10.0f));
        objectsTGTrans.setTransform(objectsTGTransT3d);
        objectsTGRot.addChild((Node)oGroup);
        objectsTGTrans.addChild((Node)objectsTGRot);
        lampsBG.addChild((Node)objectsTGTrans);
        Appearance globalSphereAppearance = new Appearance();
        PolygonAttributes globalSpherePA = new PolygonAttributes();
        globalSpherePA.setCullFace(2);
        Material globalSphereMaterial = new Material();
        globalSphereMaterial.setEmissiveColor(0.25f, 0.3f, 0.35f);
        globalSphereAppearance.setMaterial(globalSphereMaterial);
        globalSphereAppearance.setPolygonAttributes(globalSpherePA);
        Sphere globalSphere = new Sphere(6.0f);
        globalSphere.setAppearance(globalSphereAppearance);
        globalSphere.setBounds((Bounds)bounds);
        oGroup.addChild((Node)globalSphere);
        globalBG.addChild((Node)lampsBG);
        PointLight frontLamp = new PointLight(new Color3f(1.0f, 1.0f, 1.0f), new Point3f(20.0f, 20.0f, 20.0f), new Point3f(0.0f, 0.0f, 0.0f));
        lampsBG.addChild((Node)frontLamp);
        frontLamp.setBounds((Bounds)bounds);
        frontLamp.setInfluencingBounds((Bounds)bounds);
        PointLight backLamp = new PointLight(new Color3f(1.0f, 0.0f, 0.0f), new Point3f(-20.0f, -20.0f, -20.0f), new Point3f(0.0f, 0.0f, 0.0f));
        lampsBG.addChild((Node)backLamp);
        backLamp.setBounds((Bounds)bounds);
        backLamp.setInfluencingBounds((Bounds)bounds);
        TransformGroup rotBoxTGRot = new TransformGroup();
        rotBoxTGRot.setCapability(18);
        RotationInterpolator rotBoxRotInt = new RotationInterpolator(new Alpha(-1, 20000L), rotBoxTGRot);
        rotBoxRotInt.setSchedulingBounds((Bounds)bounds);
        rotBoxRotInt.setBounds((Bounds)bounds);
        Transform3D scaleBoxt3d = new Transform3D();
        TransformGroup rotBoxTGScale = new TransformGroup();
        rotBoxTGScale.setCapability(18);
        ScaleInterpolator rotBoxScaleInt = new ScaleInterpolator(new Alpha(-1, 3, 0L, 0L, 3000L, 1500L, 0L, 3000L, 1500L, 0L), rotBoxTGScale, new Transform3D(), 0.7f, 1.6f);
        rotBoxScaleInt.setSchedulingBounds((Bounds)bounds);
        rotBoxScaleInt.setBounds((Bounds)bounds);
        Appearance rotBoxApp = new Appearance();
        Material rotBoxMat = new Material();
        rotBoxMat.setDiffuseColor(0.4f, 0.4f, 0.4f);
        rotBoxApp.setMaterial(rotBoxMat);
        Box rotBox = new Box(1.1f, 1.1f, 1.1f, rotBoxApp);
        rotBoxTGScale.addChild((Node)rotBox);
        rotBoxTGRot.addChild((Node)rotBoxTGScale);
        TransformGroup rotBoxTG = new TransformGroup();
        rotBoxTG.addChild((Node)rotBoxTGRot);
        rotObjectBG.addChild((Node)rotBoxTG);
        rotObjectBG.addChild((Node)rotBoxScaleInt);
        rotObjectBG.addChild((Node)rotBoxRotInt);
        rotBox.setBounds((Bounds)bounds);
        this.rotatingBoxRA = new RenderingAttributes();
        this.rotatingBoxRA.setRasterOpEnable(true);
        this.rotatingBoxRA.setCapability(8);
        rotBoxApp.setRenderingAttributes(this.rotatingBoxRA);
        rotBox.setAppearance(rotBoxApp);
        Box staticWFBoxBack = new Box();
        Appearance staticWFBoxApp = new Appearance();
        Material staticWFBoxMat = new Material();
        staticWFBoxMat.setDiffuseColor(0.0f, 0.0f, 0.0f);
        staticWFBoxMat.setEmissiveColor(0.0f, 0.4f, 0.0f);
        staticWFBoxApp.setMaterial(staticWFBoxMat);
        PolygonAttributes staticWFBoxPABack = new PolygonAttributes(1, 2, 0.0f);
        staticWFBoxApp.setPolygonAttributes(staticWFBoxPABack);
        this.staticWFBoxRA = new RenderingAttributes();
        this.staticWFBoxRA.setCapability(13);
        this.staticWFBoxRA.setCapability(11);
        this.staticWFBoxRA.setDepthTestFunction(6);
        this.staticWFBoxRA.setDepthBufferWriteEnable(false);
        staticWFBoxApp.setRenderingAttributes(this.staticWFBoxRA);
        staticWFBoxBack.setAppearance(staticWFBoxApp);
        staticWFBoxBack.setBounds((Bounds)bounds);
        staticObjectOG.addChild((Node)staticWFBoxBack);
        Box staticWFBox = new Box();
        staticWFBoxApp = new Appearance();
        staticWFBoxMat = new Material();
        staticWFBoxMat.setDiffuseColor(0.0f, 0.0f, 0.0f);
        staticWFBoxMat.setEmissiveColor(0.0f, 1.0f, 0.0f);
        staticWFBoxApp.setMaterial(staticWFBoxMat);
        PolygonAttributes staticWFBoxPA = new PolygonAttributes(1, 1, 0.0f);
        staticWFBoxApp.setPolygonAttributes(staticWFBoxPA);
        staticWFBoxApp.setRenderingAttributes(this.staticWFBoxRA);
        staticWFBox.setAppearance(staticWFBoxApp);
        staticWFBox.setBounds((Bounds)bounds);
        staticObjectOG.addChild((Node)staticWFBox);
        Transform3D boxt3d = new Transform3D();
        Transform3D tempt3d = new Transform3D();
        boxt3d.rotZ(0.7853981633974483);
        tempt3d.rotX(0.7853981633974483);
        boxt3d.mul(tempt3d);
        tempt3d.rotY(0.7853981633974483);
        boxt3d.mul(tempt3d);
        staticBoxRotTG.setTransform(boxt3d);
        Box staticBox = new Box();
        staticBox.setBounds((Bounds)bounds);
        Appearance boxApp = new Appearance();
        Material boxMat = new Material();
        boxMat.setDiffuseColor(0.7f, 0.7f, 0.7f);
        boxApp.setMaterial(boxMat);
        this.staticBoxRA = new RenderingAttributes();
        this.staticBoxRA.setCapability(13);
        this.staticBoxRA.setCapability(11);
        this.staticBoxRA.setDepthTestFunction(4);
        this.staticBoxRA.setDepthBufferWriteEnable(false);
        boxApp.setRenderingAttributes(this.staticBoxRA);
        staticBox.setAppearance(boxApp);
        staticObjectOG.addChild((Node)staticBox);
        oGroup.addChild((Node)rotObjectBG);
        oGroup.addChild((Node)staticBoxRotTG);
        MouseRotate behavior = new MouseRotate();
        behavior.setTransformGroup(objectsTGRot);
        objectsTGRot.addChild((Node)behavior);
        objectsTGRot.setCapability(17);
        objectsTGRot.setCapability(18);
        behavior.setSchedulingBounds((Bounds)bounds);
        return globalBG;
    }

    public void setStaticWFObjectTestFunc(int func) {
        this.staticWFBoxRA.setDepthTestFunction(func);
    }

    public void setStaticObjectTestFunc(int func) {
        this.staticBoxRA.setDepthTestFunction(func);
    }

    public void setStaticWFObjectDBWriteStatus(boolean status) {
        this.staticWFBoxRA.setDepthBufferWriteEnable(status);
    }

    public void setStaticObjectDBWriteStatus(boolean status) {
        this.staticBoxRA.setDepthBufferWriteEnable(status);
    }

    public void setRotatingObjectROPMode(int mode) {
        this.rotatingBoxRA.setRasterOp(mode);
    }
}

