/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.four_by_four;

import java.awt.Color;
import java.awt.Graphics;
import org.jdesktop.j3d.examples.four_by_four.Canvas2D;
import org.jdesktop.j3d.examples.four_by_four.FourByFour;
import org.jdesktop.j3d.examples.four_by_four.Positions;

class Board {
    static final int UNOCCUPIED = 0;
    static final int HUMAN = 1;
    static final int MACHINE = 2;
    static final int END = 3;
    private int[] moves;
    private int[] occupied;
    private int[][] combinations;
    private int[][] outside_four;
    private int[][] inside_four;
    private int[][] faces;
    private int[][] pos_to_comb;
    private int[][] best_picks;
    private int num_points;
    private int num_balls;
    private int num_polygons;
    private int num_pt_indexes;
    private int num_normal_indexes;
    private int pt_start;
    private int color_index;
    private int width;
    private int height;
    private int center_x;
    private int center_y;
    private int player;
    private int skill_level;
    private int outside_four_index;
    private int inside_four_index;
    private int face_index;
    private int nmoves;
    private int current_face;
    private int min = 1000;
    private int max = 0;
    private long[] sort_array;
    private long time;
    private long beg_time;
    private long end_time;
    private Color[] color_ramp;
    private Color background;
    private Color label_color;
    private Color red;
    private Color blue;
    private Color white;
    private Color gray;
    private Color yellow;
    private double max_dist;
    private FourByFour panel;
    private boolean debug = false;
    private boolean outside_four_flag;
    private boolean inside_four_flag;
    private boolean face_flag;
    private boolean label_flag;
    private boolean block_chair_flag;
    private boolean undoFlag;
    private boolean[] highlight;
    private int block_chair_next_move;
    private int block_chair_face;
    private Positions positions;
    private Canvas2D canvas;

    Board(FourByFour panel, Positions positions, int width, int height) {
        this.width = width;
        this.height = height;
        this.panel = panel;
        this.positions = positions;
        this.label_flag = false;
        this.outside_four_flag = false;
        this.inside_four_flag = false;
        this.block_chair_flag = false;
        this.undoFlag = false;
        this.num_points = 64;
        this.moves = new int[64];
        this.occupied = new int[64];
        this.combinations = new int[76][7];
        this.outside_four = new int[18][6];
        this.inside_four = new int[18][6];
        this.faces = new int[18][18];
        this.pos_to_comb = new int[64][8];
        this.best_picks = new int[64][8];
        this.highlight = new boolean[18];
        this.init_combinations();
        this.init_faces();
        this.init_outside_four();
        this.init_inside_four();
        this.player = 1;
        this.skill_level = 4;
        this.nmoves = 0;
        this.background = new Color(13, 13, 51);
        this.red = new Color(230, 26, 51);
        this.blue = new Color(51, 51, 230);
        this.white = new Color(255, 255, 255);
        this.gray = new Color(240, 240, 240);
        this.yellow = new Color(240, 240, 0);
        this.beg_time = System.currentTimeMillis();
    }

    public void setCanvas(Canvas2D canvas) {
        this.canvas = canvas;
    }

    public void init_combinations() {
        this.combinations[0][0] = 0;
        this.combinations[1][0] = 0;
        this.combinations[2][0] = 0;
        this.combinations[3][0] = 0;
        this.combinations[0][1] = 0;
        this.combinations[1][1] = 0;
        this.combinations[2][1] = 0;
        this.combinations[3][1] = 0;
        this.combinations[0][2] = 0;
        this.combinations[1][2] = 4;
        this.combinations[2][2] = 8;
        this.combinations[3][2] = 12;
        this.combinations[0][3] = 1;
        this.combinations[1][3] = 5;
        this.combinations[2][3] = 9;
        this.combinations[3][3] = 13;
        this.combinations[0][4] = 2;
        this.combinations[1][4] = 6;
        this.combinations[2][4] = 10;
        this.combinations[3][4] = 14;
        this.combinations[0][5] = 3;
        this.combinations[1][5] = 7;
        this.combinations[2][5] = 11;
        this.combinations[3][5] = 15;
        this.combinations[4][0] = 0;
        this.combinations[5][0] = 0;
        this.combinations[6][0] = 0;
        this.combinations[7][0] = 0;
        this.combinations[4][1] = 0;
        this.combinations[5][1] = 0;
        this.combinations[6][1] = 0;
        this.combinations[7][1] = 0;
        this.combinations[4][2] = 16;
        this.combinations[5][2] = 20;
        this.combinations[6][2] = 24;
        this.combinations[7][2] = 28;
        this.combinations[4][3] = 17;
        this.combinations[5][3] = 21;
        this.combinations[6][3] = 25;
        this.combinations[7][3] = 29;
        this.combinations[4][4] = 18;
        this.combinations[5][4] = 22;
        this.combinations[6][4] = 26;
        this.combinations[7][4] = 30;
        this.combinations[4][5] = 19;
        this.combinations[5][5] = 23;
        this.combinations[6][5] = 27;
        this.combinations[7][5] = 31;
        this.combinations[8][0] = 0;
        this.combinations[9][0] = 0;
        this.combinations[10][0] = 0;
        this.combinations[11][0] = 0;
        this.combinations[8][1] = 0;
        this.combinations[9][1] = 0;
        this.combinations[10][1] = 0;
        this.combinations[11][1] = 0;
        this.combinations[8][2] = 32;
        this.combinations[9][2] = 36;
        this.combinations[10][2] = 40;
        this.combinations[11][2] = 44;
        this.combinations[8][3] = 33;
        this.combinations[9][3] = 37;
        this.combinations[10][3] = 41;
        this.combinations[11][3] = 45;
        this.combinations[8][4] = 34;
        this.combinations[9][4] = 38;
        this.combinations[10][4] = 42;
        this.combinations[11][4] = 46;
        this.combinations[8][5] = 35;
        this.combinations[9][5] = 39;
        this.combinations[10][5] = 43;
        this.combinations[11][5] = 47;
        this.combinations[12][0] = 0;
        this.combinations[13][0] = 0;
        this.combinations[14][0] = 0;
        this.combinations[15][0] = 0;
        this.combinations[12][1] = 0;
        this.combinations[13][1] = 0;
        this.combinations[14][1] = 0;
        this.combinations[15][1] = 0;
        this.combinations[12][2] = 48;
        this.combinations[13][2] = 52;
        this.combinations[14][2] = 56;
        this.combinations[15][2] = 60;
        this.combinations[12][3] = 49;
        this.combinations[13][3] = 53;
        this.combinations[14][3] = 57;
        this.combinations[15][3] = 61;
        this.combinations[12][4] = 50;
        this.combinations[13][4] = 54;
        this.combinations[14][4] = 58;
        this.combinations[15][4] = 62;
        this.combinations[12][5] = 51;
        this.combinations[13][5] = 55;
        this.combinations[14][5] = 59;
        this.combinations[15][5] = 63;
        this.combinations[16][0] = 0;
        this.combinations[17][0] = 0;
        this.combinations[18][0] = 0;
        this.combinations[19][0] = 0;
        this.combinations[16][1] = 0;
        this.combinations[17][1] = 0;
        this.combinations[18][1] = 0;
        this.combinations[19][1] = 0;
        this.combinations[16][2] = 0;
        this.combinations[17][2] = 1;
        this.combinations[18][2] = 2;
        this.combinations[19][2] = 3;
        this.combinations[16][3] = 4;
        this.combinations[17][3] = 5;
        this.combinations[18][3] = 6;
        this.combinations[19][3] = 7;
        this.combinations[16][4] = 8;
        this.combinations[17][4] = 9;
        this.combinations[18][4] = 10;
        this.combinations[19][4] = 11;
        this.combinations[16][5] = 12;
        this.combinations[17][5] = 13;
        this.combinations[18][5] = 14;
        this.combinations[19][5] = 15;
        this.combinations[20][0] = 0;
        this.combinations[21][0] = 0;
        this.combinations[22][0] = 0;
        this.combinations[23][0] = 0;
        this.combinations[20][1] = 0;
        this.combinations[21][1] = 0;
        this.combinations[22][1] = 0;
        this.combinations[23][1] = 0;
        this.combinations[20][2] = 16;
        this.combinations[21][2] = 17;
        this.combinations[22][2] = 18;
        this.combinations[23][2] = 19;
        this.combinations[20][3] = 20;
        this.combinations[21][3] = 21;
        this.combinations[22][3] = 22;
        this.combinations[23][3] = 23;
        this.combinations[20][4] = 24;
        this.combinations[21][4] = 25;
        this.combinations[22][4] = 26;
        this.combinations[23][4] = 27;
        this.combinations[20][5] = 28;
        this.combinations[21][5] = 29;
        this.combinations[22][5] = 30;
        this.combinations[23][5] = 31;
        this.combinations[24][0] = 0;
        this.combinations[25][0] = 0;
        this.combinations[26][0] = 0;
        this.combinations[27][0] = 0;
        this.combinations[24][1] = 0;
        this.combinations[25][1] = 0;
        this.combinations[26][1] = 0;
        this.combinations[27][1] = 0;
        this.combinations[24][2] = 32;
        this.combinations[25][2] = 33;
        this.combinations[26][2] = 34;
        this.combinations[27][2] = 35;
        this.combinations[24][3] = 36;
        this.combinations[25][3] = 37;
        this.combinations[26][3] = 38;
        this.combinations[27][3] = 39;
        this.combinations[24][4] = 40;
        this.combinations[25][4] = 41;
        this.combinations[26][4] = 42;
        this.combinations[27][4] = 43;
        this.combinations[24][5] = 44;
        this.combinations[25][5] = 45;
        this.combinations[26][5] = 46;
        this.combinations[27][5] = 47;
        this.combinations[28][0] = 0;
        this.combinations[29][0] = 0;
        this.combinations[30][0] = 0;
        this.combinations[31][0] = 0;
        this.combinations[28][1] = 0;
        this.combinations[29][1] = 0;
        this.combinations[30][1] = 0;
        this.combinations[31][1] = 0;
        this.combinations[28][2] = 48;
        this.combinations[29][2] = 49;
        this.combinations[30][2] = 50;
        this.combinations[31][2] = 51;
        this.combinations[28][3] = 52;
        this.combinations[29][3] = 53;
        this.combinations[30][3] = 54;
        this.combinations[31][3] = 55;
        this.combinations[28][4] = 56;
        this.combinations[29][4] = 57;
        this.combinations[30][4] = 58;
        this.combinations[31][4] = 59;
        this.combinations[28][5] = 60;
        this.combinations[29][5] = 61;
        this.combinations[30][5] = 62;
        this.combinations[31][5] = 63;
        this.combinations[32][0] = 0;
        this.combinations[33][0] = 0;
        this.combinations[34][0] = 0;
        this.combinations[35][0] = 0;
        this.combinations[32][1] = 0;
        this.combinations[33][1] = 0;
        this.combinations[34][1] = 0;
        this.combinations[35][1] = 0;
        this.combinations[32][2] = 0;
        this.combinations[33][2] = 16;
        this.combinations[34][2] = 32;
        this.combinations[35][2] = 48;
        this.combinations[32][3] = 5;
        this.combinations[33][3] = 21;
        this.combinations[34][3] = 37;
        this.combinations[35][3] = 53;
        this.combinations[32][4] = 10;
        this.combinations[33][4] = 26;
        this.combinations[34][4] = 42;
        this.combinations[35][4] = 58;
        this.combinations[32][5] = 15;
        this.combinations[33][5] = 31;
        this.combinations[34][5] = 47;
        this.combinations[35][5] = 63;
        this.combinations[36][0] = 0;
        this.combinations[37][0] = 0;
        this.combinations[38][0] = 0;
        this.combinations[39][0] = 0;
        this.combinations[36][1] = 0;
        this.combinations[37][1] = 0;
        this.combinations[38][1] = 0;
        this.combinations[39][1] = 0;
        this.combinations[36][2] = 3;
        this.combinations[37][2] = 19;
        this.combinations[38][2] = 35;
        this.combinations[39][2] = 51;
        this.combinations[36][3] = 6;
        this.combinations[37][3] = 22;
        this.combinations[38][3] = 38;
        this.combinations[39][3] = 54;
        this.combinations[36][4] = 9;
        this.combinations[37][4] = 25;
        this.combinations[38][4] = 41;
        this.combinations[39][4] = 57;
        this.combinations[36][5] = 12;
        this.combinations[37][5] = 28;
        this.combinations[38][5] = 44;
        this.combinations[39][5] = 60;
        this.combinations[40][0] = 0;
        this.combinations[41][0] = 0;
        this.combinations[42][0] = 0;
        this.combinations[43][0] = 0;
        this.combinations[40][1] = 0;
        this.combinations[41][1] = 0;
        this.combinations[42][1] = 0;
        this.combinations[43][1] = 0;
        this.combinations[40][2] = 51;
        this.combinations[41][2] = 55;
        this.combinations[42][2] = 59;
        this.combinations[43][2] = 63;
        this.combinations[40][3] = 35;
        this.combinations[41][3] = 39;
        this.combinations[42][3] = 43;
        this.combinations[43][3] = 47;
        this.combinations[40][4] = 19;
        this.combinations[41][4] = 23;
        this.combinations[42][4] = 27;
        this.combinations[43][4] = 31;
        this.combinations[40][5] = 3;
        this.combinations[41][5] = 7;
        this.combinations[42][5] = 11;
        this.combinations[43][5] = 15;
        this.combinations[44][0] = 0;
        this.combinations[45][0] = 0;
        this.combinations[46][0] = 0;
        this.combinations[47][0] = 0;
        this.combinations[44][1] = 0;
        this.combinations[45][1] = 0;
        this.combinations[46][1] = 0;
        this.combinations[47][1] = 0;
        this.combinations[44][2] = 50;
        this.combinations[45][2] = 54;
        this.combinations[46][2] = 58;
        this.combinations[47][2] = 62;
        this.combinations[44][3] = 34;
        this.combinations[45][3] = 38;
        this.combinations[46][3] = 42;
        this.combinations[47][3] = 46;
        this.combinations[44][4] = 18;
        this.combinations[45][4] = 22;
        this.combinations[46][4] = 26;
        this.combinations[47][4] = 30;
        this.combinations[44][5] = 2;
        this.combinations[45][5] = 6;
        this.combinations[46][5] = 10;
        this.combinations[47][5] = 14;
        this.combinations[48][0] = 0;
        this.combinations[49][0] = 0;
        this.combinations[50][0] = 0;
        this.combinations[51][0] = 0;
        this.combinations[48][1] = 0;
        this.combinations[49][1] = 0;
        this.combinations[50][1] = 0;
        this.combinations[51][1] = 0;
        this.combinations[48][2] = 49;
        this.combinations[49][2] = 53;
        this.combinations[50][2] = 57;
        this.combinations[51][2] = 61;
        this.combinations[48][3] = 33;
        this.combinations[49][3] = 37;
        this.combinations[50][3] = 41;
        this.combinations[51][3] = 45;
        this.combinations[48][4] = 17;
        this.combinations[49][4] = 21;
        this.combinations[50][4] = 25;
        this.combinations[51][4] = 29;
        this.combinations[48][5] = 1;
        this.combinations[49][5] = 5;
        this.combinations[50][5] = 9;
        this.combinations[51][5] = 13;
        this.combinations[52][0] = 0;
        this.combinations[53][0] = 0;
        this.combinations[54][0] = 0;
        this.combinations[55][0] = 0;
        this.combinations[52][1] = 0;
        this.combinations[53][1] = 0;
        this.combinations[54][1] = 0;
        this.combinations[55][1] = 0;
        this.combinations[52][2] = 48;
        this.combinations[53][2] = 52;
        this.combinations[54][2] = 56;
        this.combinations[55][2] = 60;
        this.combinations[52][3] = 32;
        this.combinations[53][3] = 36;
        this.combinations[54][3] = 40;
        this.combinations[55][3] = 44;
        this.combinations[52][4] = 16;
        this.combinations[53][4] = 20;
        this.combinations[54][4] = 24;
        this.combinations[55][4] = 28;
        this.combinations[52][5] = 0;
        this.combinations[53][5] = 4;
        this.combinations[54][5] = 8;
        this.combinations[55][5] = 12;
        this.combinations[56][0] = 0;
        this.combinations[57][0] = 0;
        this.combinations[58][0] = 0;
        this.combinations[59][0] = 0;
        this.combinations[56][1] = 0;
        this.combinations[57][1] = 0;
        this.combinations[58][1] = 0;
        this.combinations[59][1] = 0;
        this.combinations[56][2] = 51;
        this.combinations[57][2] = 50;
        this.combinations[58][2] = 49;
        this.combinations[59][2] = 48;
        this.combinations[56][3] = 39;
        this.combinations[57][3] = 38;
        this.combinations[58][3] = 37;
        this.combinations[59][3] = 36;
        this.combinations[56][4] = 27;
        this.combinations[57][4] = 26;
        this.combinations[58][4] = 25;
        this.combinations[59][4] = 24;
        this.combinations[56][5] = 15;
        this.combinations[57][5] = 14;
        this.combinations[58][5] = 13;
        this.combinations[59][5] = 12;
        this.combinations[60][0] = 0;
        this.combinations[61][0] = 0;
        this.combinations[62][0] = 0;
        this.combinations[63][0] = 0;
        this.combinations[60][1] = 0;
        this.combinations[61][1] = 0;
        this.combinations[62][1] = 0;
        this.combinations[63][1] = 0;
        this.combinations[60][2] = 3;
        this.combinations[61][2] = 2;
        this.combinations[62][2] = 1;
        this.combinations[63][2] = 0;
        this.combinations[60][3] = 23;
        this.combinations[61][3] = 22;
        this.combinations[62][3] = 21;
        this.combinations[63][3] = 20;
        this.combinations[60][4] = 43;
        this.combinations[61][4] = 42;
        this.combinations[62][4] = 41;
        this.combinations[63][4] = 40;
        this.combinations[60][5] = 63;
        this.combinations[61][5] = 62;
        this.combinations[62][5] = 61;
        this.combinations[63][5] = 60;
        this.combinations[64][0] = 0;
        this.combinations[65][0] = 0;
        this.combinations[66][0] = 0;
        this.combinations[67][0] = 0;
        this.combinations[64][1] = 0;
        this.combinations[65][1] = 0;
        this.combinations[66][1] = 0;
        this.combinations[67][1] = 0;
        this.combinations[64][2] = 63;
        this.combinations[65][2] = 59;
        this.combinations[66][2] = 55;
        this.combinations[67][2] = 51;
        this.combinations[64][3] = 46;
        this.combinations[65][3] = 42;
        this.combinations[66][3] = 38;
        this.combinations[67][3] = 34;
        this.combinations[64][4] = 29;
        this.combinations[65][4] = 25;
        this.combinations[66][4] = 21;
        this.combinations[67][4] = 17;
        this.combinations[64][5] = 12;
        this.combinations[65][5] = 8;
        this.combinations[66][5] = 4;
        this.combinations[67][5] = 0;
        this.combinations[68][0] = 0;
        this.combinations[69][0] = 0;
        this.combinations[70][0] = 0;
        this.combinations[71][0] = 0;
        this.combinations[68][1] = 0;
        this.combinations[69][1] = 0;
        this.combinations[70][1] = 0;
        this.combinations[71][1] = 0;
        this.combinations[68][2] = 15;
        this.combinations[69][2] = 11;
        this.combinations[70][2] = 7;
        this.combinations[71][2] = 3;
        this.combinations[68][3] = 30;
        this.combinations[69][3] = 26;
        this.combinations[70][3] = 22;
        this.combinations[71][3] = 18;
        this.combinations[68][4] = 45;
        this.combinations[69][4] = 41;
        this.combinations[70][4] = 37;
        this.combinations[71][4] = 33;
        this.combinations[68][5] = 60;
        this.combinations[69][5] = 56;
        this.combinations[70][5] = 52;
        this.combinations[71][5] = 48;
        this.combinations[72][0] = 0;
        this.combinations[73][0] = 0;
        this.combinations[74][0] = 0;
        this.combinations[75][0] = 0;
        this.combinations[72][1] = 0;
        this.combinations[73][1] = 0;
        this.combinations[74][1] = 0;
        this.combinations[75][1] = 0;
        this.combinations[72][2] = 0;
        this.combinations[73][2] = 3;
        this.combinations[74][2] = 12;
        this.combinations[75][2] = 15;
        this.combinations[72][3] = 21;
        this.combinations[73][3] = 22;
        this.combinations[74][3] = 25;
        this.combinations[75][3] = 26;
        this.combinations[72][4] = 42;
        this.combinations[73][4] = 41;
        this.combinations[74][4] = 38;
        this.combinations[75][4] = 37;
        this.combinations[72][5] = 63;
        this.combinations[73][5] = 60;
        this.combinations[74][5] = 51;
        this.combinations[75][5] = 48;
        for (int i = 0; i < 76; ++i) {
            this.combinations[i][6] = 0;
        }
        this.setup_pos_to_comb();
        this.update_best_picks();
    }

    public void init_outside_four() {
        for (int i = 0; i < 18; ++i) {
            this.outside_four[i][0] = 0;
            this.outside_four[i][1] = 0;
            this.outside_four[i][2] = this.faces[i][2];
            this.outside_four[i][3] = this.faces[i][5];
            this.outside_four[i][4] = this.faces[i][14];
            this.outside_four[i][5] = this.faces[i][17];
        }
    }

    public void init_inside_four() {
        for (int i = 0; i < 18; ++i) {
            this.inside_four[i][0] = 0;
            this.inside_four[i][1] = 0;
            this.inside_four[i][2] = this.faces[i][7];
            this.inside_four[i][3] = this.faces[i][8];
            this.inside_four[i][4] = this.faces[i][11];
            this.inside_four[i][5] = this.faces[i][12];
        }
    }

    public void init_faces() {
        this.faces[0][0] = 0;
        this.faces[0][1] = 0;
        this.faces[0][2] = 12;
        this.faces[0][6] = 13;
        this.faces[0][10] = 14;
        this.faces[0][14] = 15;
        this.faces[0][3] = 8;
        this.faces[0][7] = 9;
        this.faces[0][11] = 10;
        this.faces[0][15] = 11;
        this.faces[0][4] = 4;
        this.faces[0][8] = 5;
        this.faces[0][12] = 6;
        this.faces[0][16] = 7;
        this.faces[0][5] = 0;
        this.faces[0][9] = 1;
        this.faces[0][13] = 2;
        this.faces[0][17] = 3;
        this.faces[1][0] = 0;
        this.faces[1][1] = 0;
        this.faces[1][2] = 28;
        this.faces[1][6] = 29;
        this.faces[1][10] = 30;
        this.faces[1][14] = 31;
        this.faces[1][3] = 24;
        this.faces[1][7] = 25;
        this.faces[1][11] = 26;
        this.faces[1][15] = 27;
        this.faces[1][4] = 20;
        this.faces[1][8] = 21;
        this.faces[1][12] = 22;
        this.faces[1][16] = 23;
        this.faces[1][5] = 16;
        this.faces[1][9] = 17;
        this.faces[1][13] = 18;
        this.faces[1][17] = 19;
        this.faces[2][0] = 0;
        this.faces[2][1] = 0;
        this.faces[2][2] = 44;
        this.faces[2][6] = 45;
        this.faces[2][10] = 46;
        this.faces[2][14] = 47;
        this.faces[2][3] = 40;
        this.faces[2][7] = 41;
        this.faces[2][11] = 42;
        this.faces[2][15] = 43;
        this.faces[2][4] = 36;
        this.faces[2][8] = 37;
        this.faces[2][12] = 38;
        this.faces[2][16] = 39;
        this.faces[2][5] = 32;
        this.faces[2][9] = 33;
        this.faces[2][13] = 34;
        this.faces[2][17] = 35;
        this.faces[3][0] = 0;
        this.faces[3][1] = 0;
        this.faces[3][2] = 60;
        this.faces[3][6] = 61;
        this.faces[3][10] = 62;
        this.faces[3][14] = 63;
        this.faces[3][3] = 56;
        this.faces[3][7] = 57;
        this.faces[3][11] = 58;
        this.faces[3][15] = 59;
        this.faces[3][4] = 52;
        this.faces[3][8] = 53;
        this.faces[3][12] = 54;
        this.faces[3][16] = 55;
        this.faces[3][5] = 48;
        this.faces[3][9] = 49;
        this.faces[3][13] = 50;
        this.faces[3][17] = 51;
        this.faces[4][0] = 0;
        this.faces[4][1] = 0;
        this.faces[4][2] = 12;
        this.faces[4][6] = 28;
        this.faces[4][10] = 44;
        this.faces[4][14] = 60;
        this.faces[4][3] = 8;
        this.faces[4][7] = 24;
        this.faces[4][11] = 40;
        this.faces[4][15] = 56;
        this.faces[4][4] = 4;
        this.faces[4][8] = 20;
        this.faces[4][12] = 36;
        this.faces[4][16] = 52;
        this.faces[4][5] = 0;
        this.faces[4][9] = 16;
        this.faces[4][13] = 32;
        this.faces[4][17] = 48;
        this.faces[5][0] = 0;
        this.faces[5][1] = 0;
        this.faces[5][2] = 13;
        this.faces[5][6] = 29;
        this.faces[5][10] = 45;
        this.faces[5][14] = 61;
        this.faces[5][3] = 9;
        this.faces[5][7] = 25;
        this.faces[5][11] = 41;
        this.faces[5][15] = 57;
        this.faces[5][4] = 5;
        this.faces[5][8] = 21;
        this.faces[5][12] = 37;
        this.faces[5][16] = 53;
        this.faces[5][5] = 1;
        this.faces[5][9] = 17;
        this.faces[5][13] = 33;
        this.faces[5][17] = 49;
        this.faces[6][0] = 0;
        this.faces[6][1] = 0;
        this.faces[6][2] = 14;
        this.faces[6][6] = 30;
        this.faces[6][10] = 46;
        this.faces[6][14] = 62;
        this.faces[6][3] = 10;
        this.faces[6][7] = 26;
        this.faces[6][11] = 42;
        this.faces[6][15] = 58;
        this.faces[6][4] = 6;
        this.faces[6][8] = 22;
        this.faces[6][12] = 38;
        this.faces[6][16] = 54;
        this.faces[6][5] = 2;
        this.faces[6][9] = 18;
        this.faces[6][13] = 34;
        this.faces[6][17] = 50;
        this.faces[7][0] = 0;
        this.faces[7][1] = 0;
        this.faces[7][2] = 15;
        this.faces[7][6] = 31;
        this.faces[7][10] = 47;
        this.faces[7][14] = 63;
        this.faces[7][3] = 11;
        this.faces[7][7] = 27;
        this.faces[7][11] = 43;
        this.faces[7][15] = 59;
        this.faces[7][4] = 7;
        this.faces[7][8] = 23;
        this.faces[7][12] = 39;
        this.faces[7][16] = 55;
        this.faces[7][5] = 3;
        this.faces[7][9] = 19;
        this.faces[7][13] = 35;
        this.faces[7][17] = 51;
        this.faces[8][0] = 0;
        this.faces[8][1] = 0;
        this.faces[8][2] = 12;
        this.faces[8][6] = 28;
        this.faces[8][10] = 44;
        this.faces[8][14] = 60;
        this.faces[8][3] = 13;
        this.faces[8][7] = 29;
        this.faces[8][11] = 45;
        this.faces[8][15] = 61;
        this.faces[8][4] = 14;
        this.faces[8][8] = 30;
        this.faces[8][12] = 46;
        this.faces[8][16] = 62;
        this.faces[8][5] = 15;
        this.faces[8][9] = 31;
        this.faces[8][13] = 47;
        this.faces[8][17] = 63;
        this.faces[9][0] = 0;
        this.faces[9][1] = 0;
        this.faces[9][2] = 8;
        this.faces[9][6] = 24;
        this.faces[9][10] = 40;
        this.faces[9][14] = 56;
        this.faces[9][3] = 9;
        this.faces[9][7] = 25;
        this.faces[9][11] = 41;
        this.faces[9][15] = 57;
        this.faces[9][4] = 10;
        this.faces[9][8] = 26;
        this.faces[9][12] = 42;
        this.faces[9][16] = 58;
        this.faces[9][5] = 11;
        this.faces[9][9] = 27;
        this.faces[9][13] = 43;
        this.faces[9][17] = 59;
        this.faces[10][0] = 0;
        this.faces[10][1] = 0;
        this.faces[10][2] = 4;
        this.faces[10][6] = 20;
        this.faces[10][10] = 36;
        this.faces[10][14] = 52;
        this.faces[10][3] = 5;
        this.faces[10][7] = 21;
        this.faces[10][11] = 37;
        this.faces[10][15] = 53;
        this.faces[10][4] = 6;
        this.faces[10][8] = 22;
        this.faces[10][12] = 38;
        this.faces[10][16] = 54;
        this.faces[10][5] = 7;
        this.faces[10][9] = 23;
        this.faces[10][13] = 39;
        this.faces[10][17] = 55;
        this.faces[11][0] = 0;
        this.faces[11][1] = 0;
        this.faces[11][2] = 0;
        this.faces[11][6] = 16;
        this.faces[11][10] = 32;
        this.faces[11][14] = 48;
        this.faces[11][3] = 1;
        this.faces[11][7] = 17;
        this.faces[11][11] = 33;
        this.faces[11][15] = 49;
        this.faces[11][4] = 2;
        this.faces[11][8] = 18;
        this.faces[11][12] = 34;
        this.faces[11][16] = 50;
        this.faces[11][5] = 3;
        this.faces[11][9] = 19;
        this.faces[11][13] = 35;
        this.faces[11][17] = 51;
        this.faces[12][0] = 0;
        this.faces[12][1] = 0;
        this.faces[12][2] = 12;
        this.faces[12][6] = 13;
        this.faces[12][10] = 14;
        this.faces[12][14] = 15;
        this.faces[12][3] = 24;
        this.faces[12][7] = 25;
        this.faces[12][11] = 26;
        this.faces[12][15] = 27;
        this.faces[12][4] = 36;
        this.faces[12][8] = 37;
        this.faces[12][12] = 38;
        this.faces[12][16] = 39;
        this.faces[12][5] = 48;
        this.faces[12][9] = 49;
        this.faces[12][13] = 50;
        this.faces[12][17] = 51;
        this.faces[13][0] = 0;
        this.faces[13][1] = 0;
        this.faces[13][2] = 0;
        this.faces[13][6] = 1;
        this.faces[13][10] = 2;
        this.faces[13][14] = 3;
        this.faces[13][3] = 20;
        this.faces[13][7] = 21;
        this.faces[13][11] = 22;
        this.faces[13][15] = 23;
        this.faces[13][4] = 40;
        this.faces[13][8] = 41;
        this.faces[13][12] = 42;
        this.faces[13][16] = 43;
        this.faces[13][5] = 60;
        this.faces[13][9] = 61;
        this.faces[13][13] = 62;
        this.faces[13][17] = 63;
        this.faces[14][0] = 0;
        this.faces[14][1] = 0;
        this.faces[14][2] = 12;
        this.faces[14][6] = 28;
        this.faces[14][10] = 44;
        this.faces[14][14] = 60;
        this.faces[14][3] = 9;
        this.faces[14][7] = 25;
        this.faces[14][11] = 41;
        this.faces[14][15] = 57;
        this.faces[14][4] = 6;
        this.faces[14][8] = 22;
        this.faces[14][12] = 38;
        this.faces[14][16] = 54;
        this.faces[14][5] = 3;
        this.faces[14][9] = 19;
        this.faces[14][13] = 35;
        this.faces[14][17] = 51;
        this.faces[15][0] = 0;
        this.faces[15][1] = 0;
        this.faces[15][2] = 15;
        this.faces[15][6] = 31;
        this.faces[15][10] = 47;
        this.faces[15][14] = 63;
        this.faces[15][3] = 10;
        this.faces[15][7] = 26;
        this.faces[15][11] = 42;
        this.faces[15][15] = 58;
        this.faces[15][4] = 5;
        this.faces[15][8] = 21;
        this.faces[15][12] = 37;
        this.faces[15][16] = 53;
        this.faces[15][5] = 0;
        this.faces[15][9] = 16;
        this.faces[15][13] = 32;
        this.faces[15][17] = 48;
        this.faces[16][0] = 0;
        this.faces[16][1] = 0;
        this.faces[16][2] = 12;
        this.faces[16][6] = 29;
        this.faces[16][10] = 46;
        this.faces[16][14] = 63;
        this.faces[16][3] = 8;
        this.faces[16][7] = 25;
        this.faces[16][11] = 42;
        this.faces[16][15] = 59;
        this.faces[16][4] = 4;
        this.faces[16][8] = 21;
        this.faces[16][12] = 38;
        this.faces[16][16] = 55;
        this.faces[16][5] = 0;
        this.faces[16][9] = 17;
        this.faces[16][13] = 34;
        this.faces[16][17] = 51;
        this.faces[17][0] = 0;
        this.faces[17][1] = 0;
        this.faces[17][2] = 15;
        this.faces[17][6] = 30;
        this.faces[17][10] = 45;
        this.faces[17][14] = 60;
        this.faces[17][3] = 11;
        this.faces[17][7] = 26;
        this.faces[17][11] = 41;
        this.faces[17][15] = 56;
        this.faces[17][4] = 7;
        this.faces[17][8] = 22;
        this.faces[17][12] = 37;
        this.faces[17][16] = 52;
        this.faces[17][5] = 3;
        this.faces[17][9] = 18;
        this.faces[17][13] = 33;
        this.faces[17][17] = 48;
    }

    public void render2D(Graphics gc) {
        gc.setColor(this.background);
        gc.fillRect(0, 0, this.width, this.height);
        for (int l = 0; l < 3; ++l) {
            float begY = 28.0f + (float)l * 116.5f;
            for (int k = 0; k < 6; ++k) {
                float begX = 11.65f + (float)k * 58.25f;
                int count = 0;
                int face = l * 6 + k;
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        int x = (int)begX + i * 12;
                        int y = (int)begY + j * 12;
                        int id = this.faces[face][count + 2];
                        if (this.occupied[id] == 1) {
                            gc.setColor(this.red);
                            gc.fillRect(x -= 2, y -= 2, 5, 5);
                        } else if (this.occupied[id] == 2) {
                            gc.setColor(this.blue);
                            gc.fillRect(x -= 2, y -= 2, 5, 5);
                        } else {
                            gc.setColor(this.gray);
                            gc.fillRect(--x, --y, 2, 2);
                        }
                        if (this.highlight[face]) {
                            gc.setColor(this.yellow);
                            this.positions.setHighlight(this.faces[face][count + 2]);
                        }
                        ++count;
                    }
                }
                if (this.highlight[face]) {
                    gc.setColor(this.yellow);
                } else {
                    gc.setColor(this.white);
                }
                if (face + 1 < 10) {
                    gc.drawString("Face " + (face + 1), (int)begX - 2, (int)begY + 60);
                    continue;
                }
                gc.drawString("Face " + (face + 1), (int)begX - 4, (int)begY + 60);
            }
        }
    }

    public void checkSelection2D(int x, int y, int player) {
        for (int l = 0; l < 3; ++l) {
            float begY = 28.0f + (float)l * 116.5f;
            for (int k = 0; k < 6; ++k) {
                int j;
                int i;
                float begX = 11.65f + (float)k * 58.25f;
                int count = 0;
                int face = l * 6 + k;
                for (i = 0; i < 4; ++i) {
                    for (j = 0; j < 4; ++j) {
                        int posX = (int)begX + i * 12;
                        int posY = (int)begY + j * 12;
                        if (x > posX - 4 && x < posX + 4 && y > posY - 4 && y < posY + 4) {
                            int id = this.faces[face][count + 2];
                            if (this.occupied[id] == 0) {
                                this.positions.set(id, player);
                                this.selection(id, player);
                                this.canvas.repaint();
                            }
                            return;
                        }
                        ++count;
                    }
                }
                if (!((float)x > begX - 4.0f) || !((float)x < begX + 40.0f) || !((float)y > begY + 45.0f) || !((float)y < begY + 60.0f)) continue;
                count = 0;
                for (i = 0; i < 4; ++i) {
                    for (j = 0; j < 4; ++j) {
                        if (this.highlight[face]) {
                            this.positions.clearHighlight(this.faces[face][count + 2]);
                        }
                        ++count;
                    }
                }
                this.highlight[face] = !this.highlight[face];
                this.canvas.repaint();
            }
        }
    }

    public void selection(int pos, int player) {
        this.player = player;
        if (player == 1) {
            if (this.occupied[pos] != 0) {
                return;
            }
            this.occupied[pos] = 1;
            this.player = this.update_logic_arrays(pos);
            this.choose_move();
        }
    }

    public void choose_move() {
        if (this.player == 2) {
            if (this.skill_level == 0) {
                if (!(this.block_winning_move() || this.pick_7() || this.check_outside_four())) {
                    this.pick_best_position();
                }
            } else if (this.skill_level == 1) {
                if (!(this.block_winning_move() || this.block_intersecting_rows() || this.block_inside_four() || this.block_outside_four())) {
                    this.pick_best_position();
                }
            } else if (this.skill_level == 2) {
                if (!(this.block_winning_move() || this.block_intersecting_rows() || this.block_inside_four() || this.block_outside_four() || this.pick_7())) {
                    this.pick_best_position();
                }
            } else if (this.skill_level == 3) {
                if (!(this.block_winning_move() || this.block_intersecting_rows() || this.block_chair_move() || this.check_face_three() || this.block_central_four() || this.block_inside_four() || this.block_outside_four() || this.take_inside_four() || this.take_outside_four() || this.pick_7() || this.check_outside_four())) {
                    this.pick_best_position();
                }
            } else if (!(this.skill_level != 4 || this.block_winning_move() || this.block_intersecting_rows() || this.block_chair_move() || this.block_walk_move() || this.block_central_four() || this.block_inside_four() || this.block_outside_four() || this.check_face_three() || this.check_intersecting_rows2() || this.take_inside_four() || this.take_outside_four() || this.pick_7() || this.check_outside_four())) {
                this.pick_best_position();
            }
        }
    }

    public boolean block_winning_move() {
        for (int i = 0; i < 76; ++i) {
            if (this.combinations[i][0] != 3) continue;
            for (int j = 2; j < 6; ++j) {
                int pos = this.combinations[i][j];
                if (this.occupied[pos] != 0) continue;
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("block_winning_move:  true");
                }
                return true;
            }
        }
        if (this.debug) {
            System.out.println("check_winning_move:  false");
        }
        return false;
    }

    public boolean block_outside_four() {
        int index = 0;
        int max = 0;
        for (int i = 0; i < 18; ++i) {
            if (this.outside_four[i][0] <= 0 || this.outside_four[i][1] != 1 || this.outside_four[i][0] <= max) continue;
            index = i;
            max = this.outside_four[i][0];
        }
        if (max > 0) {
            for (int j = 2; j < 6; ++j) {
                int pos = this.outside_four[index][j];
                if (this.occupied[pos] != 0) continue;
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("block_outside_four:  true");
                }
                return true;
            }
        }
        if (this.debug) {
            System.out.println("block_outside_four:  false");
        }
        return false;
    }

    public boolean block_central_four() {
        int index = 0;
        int max = 0;
        for (int i = 1; i < 3; ++i) {
            if (this.inside_four[i][0] <= 0 || this.inside_four[i][1] != 1 || this.inside_four[i][0] <= max) continue;
            index = i;
            max = this.inside_four[i][0];
        }
        if (max > 0) {
            for (int j = 2; j < 6; ++j) {
                int pos = this.inside_four[index][j];
                if (this.occupied[pos] != 0) continue;
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("block_central_four:  true");
                }
                return true;
            }
        }
        if (this.debug) {
            System.out.println("block_central_four:  false");
        }
        return false;
    }

    public boolean check_face_three() {
        boolean index = false;
        int human = 0;
        int machine = 0;
        for (int i = 0; i < 18; ++i) {
            int j;
            if (this.outside_four[i][0] != -1) continue;
            human = 0;
            machine = 0;
            for (j = 2; j < 6; ++j) {
                if (this.occupied[this.outside_four[i][j]] == 2) {
                    ++machine;
                    continue;
                }
                if (this.occupied[this.outside_four[i][j]] != 1) continue;
                ++human;
            }
            if (this.debug) {
                System.out.println("machine = " + machine);
            }
            if (this.debug) {
                System.out.println("human   = " + human);
            }
            if (human != 3 || machine != 1) continue;
            if (this.debug) {
                System.out.println("human == 3 && machine == 1");
            }
            for (j = 2; j < 18; ++j) {
                int pos = this.faces[i][j];
                if (this.occupied[pos] != 0) continue;
                for (int k = 0; k < 76; ++k) {
                    if (!(this.combinations[i][0] == 2 & this.combinations[i][1] == 1)) continue;
                    for (int l = 0; l < 4; ++l) {
                        if (this.combinations[i][l] != pos) continue;
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("check_face_three:  true");
                        }
                        return true;
                    }
                }
            }
        }
        if (this.debug) {
            System.out.println("check_face_three:  false");
        }
        return false;
    }

    public boolean block_inside_four() {
        int index = 0;
        int max = 0;
        for (int i = 0; i < 18; ++i) {
            if (this.inside_four[i][0] <= 0 || this.inside_four[i][1] != 1 || this.inside_four[i][0] <= max) continue;
            index = i;
            max = this.inside_four[i][0];
        }
        if (max > 0) {
            for (int j = 2; j < 6; ++j) {
                int pos = this.inside_four[index][j];
                if (this.occupied[pos] != 0) continue;
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("block_inside_four:  true");
                }
                return true;
            }
        }
        if (this.debug) {
            System.out.println("block_inside_four:  false");
        }
        return false;
    }

    public boolean block_chair_move() {
        int ncorners = 0;
        int corner = 0;
        if (this.debug) {
            System.out.println("inside block_chair_move");
        }
        for (int i = 0; i < 18; ++i) {
            if (this.occupied[this.faces[i][2]] == 1) {
                ++ncorners;
            } else if (this.occupied[this.faces[i][2]] == 2) {
                corner = 2;
            }
            if (this.occupied[this.faces[i][5]] == 1) {
                ++ncorners;
            } else if (this.occupied[this.faces[i][5]] == 2) {
                corner = 5;
            }
            if (this.occupied[this.faces[i][14]] == 1) {
                ++ncorners;
            } else if (this.occupied[this.faces[i][14]] == 2) {
                corner = 14;
            }
            if (this.occupied[this.faces[i][17]] == 1) {
                ++ncorners;
            } else if (this.occupied[this.faces[i][17]] == 2) {
                corner = 17;
            }
            if (ncorners == 3) {
                if (corner == 2) {
                    if (this.occupied[this.faces[i][3]] == 1 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][11];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][4]] == 1 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][12];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][6]] == 1 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][9]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][13]] == 0) {
                        int pos = this.faces[i][8];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][10]] == 1 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][9]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][13]] == 0) {
                        int pos = this.faces[i][11];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][7]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][11];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][12]] == 1 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][16];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                } else if (corner == 5) {
                    if (this.occupied[this.faces[i][9]] == 1 && this.occupied[this.faces[i][6]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][10]] == 0 && this.occupied[this.faces[i][12]] == 0) {
                        int pos = this.faces[i][7];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][13]] == 1 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][10]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0) {
                        int pos = this.faces[i][12];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][4]] == 1 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][12];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][3]] == 1 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][7];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][8]] == 1 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][12];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][11]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][7];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                } else if (corner == 14) {
                    if (this.occupied[this.faces[i][6]] == 1 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][9]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][13]] == 0) {
                        int pos = this.faces[i][7];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][10]] == 1 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][9]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][13]] == 0) {
                        int pos = this.faces[i][12];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][15]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0) {
                        int pos = this.faces[i][3];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][16]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][12]] == 0) {
                        int pos = this.faces[i][12];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][11]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][15]] == 0) {
                        int pos = this.faces[i][7];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][8]] == 1 && this.occupied[this.faces[i][6]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][9]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][13]] == 0) {
                        int pos = this.faces[i][7];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                } else if (corner == 17) {
                    if (this.occupied[this.faces[i][9]] == 1 && this.occupied[this.faces[i][6]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][10]] == 0 && this.occupied[this.faces[i][11]] == 0) {
                        int pos = this.faces[i][8];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][13]] == 1 && this.occupied[this.faces[i][6]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][10]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0) {
                        int pos = this.faces[i][11];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][15]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0) {
                        int pos = this.faces[i][11];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][16]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0) {
                        int pos = this.faces[i][8];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][12]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][16]] == 0) {
                        int pos = this.faces[i][8];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                    if (this.occupied[this.faces[i][7]] == 1 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][4]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][15]] == 0) {
                        int pos = this.faces[i][11];
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_chair_move: found");
                        }
                        return true;
                    }
                }
            }
            ncorners = 0;
            corner = -1;
        }
        if (this.debug) {
            System.out.println("block_chair_move: false");
        }
        return false;
    }

    public boolean block_walk_move() {
        if (this.debug) {
            System.out.println("inside block_walk_move");
        }
        for (int i = 0; i < 18; ++i) {
            if (this.occupied[this.faces[i][2]] == 1 && this.occupied[this.faces[i][14]] == 1 && this.occupied[this.faces[i][3]] == 1 && this.occupied[this.faces[i][15]] == 1 && this.occupied[this.faces[i][6]] == 0 && this.occupied[this.faces[i][10]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][11]] == 0) {
                if (this.occupied[this.faces[i][8]] == 1 && this.occupied[this.faces[i][9]] == 0) {
                    int pos = this.faces[i][6];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
                if (this.occupied[this.faces[i][12]] == 1 && this.occupied[this.faces[i][13]] == 0) {
                    int pos = this.faces[i][10];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
            }
            if (this.occupied[this.faces[i][14]] == 1 && this.occupied[this.faces[i][17]] == 1 && this.occupied[this.faces[i][10]] == 1 && this.occupied[this.faces[i][13]] == 1 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][12]] == 0) {
                if (this.occupied[this.faces[i][7]] == 1 && this.occupied[this.faces[i][3]] == 0) {
                    int pos = this.faces[i][15];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
                if (this.occupied[this.faces[i][8]] == 1 && this.occupied[this.faces[i][4]] == 0) {
                    int pos = this.faces[i][16];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
            }
            if (this.occupied[this.faces[i][4]] == 1 && this.occupied[this.faces[i][16]] == 1 && this.occupied[this.faces[i][5]] == 1 && this.occupied[this.faces[i][17]] == 1 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][12]] == 0 && this.occupied[this.faces[i][9]] == 0 && this.occupied[this.faces[i][13]] == 0) {
                if (this.occupied[this.faces[i][11]] == 1 && this.occupied[this.faces[i][10]] == 0) {
                    int pos = this.faces[i][18];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
                if (this.occupied[this.faces[i][7]] == 1 && this.occupied[this.faces[i][6]] == 0) {
                    int pos = this.faces[i][9];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
            }
            if (this.occupied[this.faces[i][6]] == 1 && this.occupied[this.faces[i][9]] == 1 && this.occupied[this.faces[i][2]] == 1 && this.occupied[this.faces[i][5]] == 1 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][3]] == 0 && this.occupied[this.faces[i][4]] == 0) {
                if (this.occupied[this.faces[i][11]] == 1 && this.occupied[this.faces[i][15]] == 0) {
                    int pos = this.faces[i][3];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
                if (this.occupied[this.faces[i][12]] == 1 && this.occupied[this.faces[i][16]] == 0) {
                    int pos = this.faces[i][4];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
            }
            if (this.occupied[this.faces[i][2]] == 1 && this.occupied[this.faces[i][14]] == 1 && this.occupied[this.faces[i][4]] == 1 && this.occupied[this.faces[i][16]] == 1 && this.occupied[this.faces[i][6]] == 0 && this.occupied[this.faces[i][10]] == 0 && this.occupied[this.faces[i][8]] == 0 && this.occupied[this.faces[i][12]] == 0) {
                if (this.occupied[this.faces[i][7]] == 1 && this.occupied[this.faces[i][9]] == 0 || this.occupied[this.faces[i][9]] == 1 && this.occupied[this.faces[i][7]] == 0) {
                    int pos = this.faces[i][6];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
                if (this.occupied[this.faces[i][11]] == 1 && this.occupied[this.faces[i][13]] == 0 || this.occupied[this.faces[i][13]] == 1 && this.occupied[this.faces[i][11]] == 0) {
                    int pos = this.faces[i][10];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
            }
            if (this.occupied[this.faces[i][14]] == 1 && this.occupied[this.faces[i][17]] == 1 && this.occupied[this.faces[i][6]] == 1 && this.occupied[this.faces[i][9]] == 1 && this.occupied[this.faces[i][15]] == 0 && this.occupied[this.faces[i][16]] == 0 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][8]] == 0) {
                if (this.occupied[this.faces[i][11]] == 1 && this.occupied[this.faces[i][3]] == 0 || this.occupied[this.faces[i][3]] == 1 && this.occupied[this.faces[i][11]] == 0) {
                    int pos = this.faces[i][15];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
                if (this.occupied[this.faces[i][12]] == 1 && this.occupied[this.faces[i][4]] == 0 || this.occupied[this.faces[i][4]] == 1 && this.occupied[this.faces[i][12]] == 0) {
                    int pos = this.faces[i][16];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
            }
            if (this.occupied[this.faces[i][3]] == 1 && this.occupied[this.faces[i][15]] == 1 && this.occupied[this.faces[i][5]] == 1 && this.occupied[this.faces[i][17]] == 1 && this.occupied[this.faces[i][7]] == 0 && this.occupied[this.faces[i][11]] == 0 && this.occupied[this.faces[i][9]] == 0 && this.occupied[this.faces[i][13]] == 0) {
                if (this.occupied[this.faces[i][6]] == 1 && this.occupied[this.faces[i][8]] == 0 || this.occupied[this.faces[i][8]] == 1 && this.occupied[this.faces[i][6]] == 0) {
                    int pos = this.faces[i][9];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
                if (this.occupied[this.faces[i][10]] == 1 && this.occupied[this.faces[i][12]] == 0 || this.occupied[this.faces[i][12]] == 1 && this.occupied[this.faces[i][10]] == 0) {
                    int pos = this.faces[i][13];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    return true;
                }
            }
            if (this.occupied[this.faces[i][10]] != 1 || this.occupied[this.faces[i][13]] != 1 || this.occupied[this.faces[i][2]] != 1 || this.occupied[this.faces[i][5]] != 1 || this.occupied[this.faces[i][11]] != 0 || this.occupied[this.faces[i][12]] != 0 || this.occupied[this.faces[i][3]] != 0 || this.occupied[this.faces[i][4]] != 0) continue;
            if (this.occupied[this.faces[i][7]] == 1 && this.occupied[this.faces[i][15]] == 0 || this.occupied[this.faces[i][15]] == 1 && this.occupied[this.faces[i][7]] == 0) {
                int pos = this.faces[i][3];
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                return true;
            }
            if ((this.occupied[this.faces[i][8]] != 1 || this.occupied[this.faces[i][16]] != 0) && (this.occupied[this.faces[i][16]] != 1 || this.occupied[this.faces[i][8]] != 0)) continue;
            int pos = this.faces[i][4];
            this.occupied[pos] = 2;
            this.positions.set(pos, 2);
            this.player = this.update_logic_arrays(pos);
            return true;
        }
        if (this.debug) {
            System.out.println("block_walk_move: false");
        }
        return false;
    }

    public boolean check_chair_move() {
        if (this.block_chair_flag) {
            int pos = this.faces[this.block_chair_face][this.block_chair_next_move];
            this.occupied[pos] = 2;
            this.positions.set(pos, 2);
            this.player = this.update_logic_arrays(pos);
            if (this.debug) {
                System.out.println("block_chair_move: march");
            }
            return true;
        }
        int ncorners = 0;
        int corner = 0;
        for (int i = 0; i < 18; ++i) {
            if (this.faces[i][2] == 1) {
                ++ncorners;
            } else {
                corner = 2;
            }
            if (this.faces[i][5] == 1) {
                ++ncorners;
            } else {
                corner = 5;
            }
            if (this.faces[i][14] == 1) {
                ++ncorners;
            } else {
                corner = 14;
            }
            if (this.faces[i][17] == 1) {
                ++ncorners;
            } else {
                corner = 17;
            }
            if (ncorners != 3) continue;
            if (corner == 2) {
                if (this.faces[i][3] == 1 && this.faces[i][7] == 0 && this.faces[i][8] == 0 && this.faces[i][11] == 0 && this.faces[i][15] == 0 && this.faces[i][16] == 0) {
                    this.block_chair_flag = true;
                    this.block_chair_next_move = 11;
                    this.block_chair_face = i;
                    int pos = this.faces[i][15];
                    this.occupied[pos] = 2;
                    this.positions.set(pos, 2);
                    this.player = this.update_logic_arrays(pos);
                    if (this.debug) {
                        System.out.println("block_chair_move: found");
                    }
                    return true;
                }
                if (this.faces[i][4] != 1 || this.faces[i][8] != 0 || this.faces[i][11] != 0 || this.faces[i][12] != 0 || this.faces[i][15] != 0 || this.faces[i][16] != 0) continue;
                this.block_chair_flag = true;
                this.block_chair_next_move = 16;
                this.block_chair_face = i;
                int pos = this.faces[i][8];
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("block_chair_move: found");
                }
                return true;
            }
            if (corner == 5) {
                this.block_chair_flag = true;
                this.block_chair_next_move = 11;
                this.block_chair_face = i;
                int pos = this.faces[i][15];
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("check_face_three:  true");
                }
                return true;
            }
            if (corner == 14) {
                this.block_chair_flag = true;
                this.block_chair_next_move = 11;
                this.block_chair_face = i;
                int pos = this.faces[i][15];
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("check_face_three:  true");
                }
                return true;
            }
            if (corner != 17) continue;
            this.block_chair_flag = true;
            this.block_chair_next_move = 11;
            this.block_chair_face = i;
            int pos = this.faces[i][15];
            this.occupied[pos] = 2;
            this.positions.set(pos, 2);
            this.player = this.update_logic_arrays(pos);
            if (this.debug) {
                System.out.println("check_face_three:  true");
            }
            return true;
        }
        return false;
    }

    public boolean take_inside_four() {
        int pos = 0;
        boolean found = false;
        if (this.occupied[21] == 0) {
            found = true;
            pos = 21;
        } else if (this.occupied[22] == 0) {
            found = true;
            pos = 22;
        } else if (this.occupied[25] == 0) {
            found = true;
            pos = 25;
        } else if (this.occupied[26] == 0) {
            found = true;
            pos = 26;
        } else if (this.occupied[37] == 0) {
            found = true;
            pos = 37;
        } else if (this.occupied[38] == 0) {
            found = true;
            pos = 38;
        } else if (this.occupied[41] == 0) {
            found = true;
            pos = 41;
        } else if (this.occupied[42] == 0) {
            found = true;
            pos = 42;
        }
        if (found) {
            this.occupied[pos] = 2;
            this.positions.set(pos, 2);
            this.player = this.update_logic_arrays(pos);
            if (this.debug) {
                System.out.println("take_inside_four:  true");
            }
            return true;
        }
        if (this.debug) {
            System.out.println("take_inside_four:  false");
        }
        return false;
    }

    public boolean check_outside_four() {
        int j;
        int i;
        int pos = 0;
        if (this.outside_four_flag) {
            if (this.occupied[this.faces[this.face_index][7]] == 0) {
                pos = this.faces[this.face_index][7];
            } else if (this.occupied[this.faces[this.face_index][6]] == 0) {
                pos = this.faces[this.face_index][6];
            }
            if (this.occupied[pos] == 0) {
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                return true;
            }
        }
        for (i = 0; i < 18; ++i) {
            if (this.outside_four[i][0] != 4 || this.outside_four[i][1] != 2 || this.faces[i][0] <= 0 || this.faces[i][1] != 2) continue;
            if (this.occupied[this.faces[i][8]] == 0) {
                pos = this.faces[i][8];
                this.outside_four_flag = true;
                this.face_index = i;
            }
            if (this.occupied[pos] != 0) continue;
            this.occupied[pos] = 2;
            this.positions.set(pos, 2);
            this.player = this.update_logic_arrays(pos);
            if (this.debug) {
                System.out.println("check_outside_four:  true");
            }
            return true;
        }
        for (i = 0; i < 18; ++i) {
            if (this.outside_four[i][0] <= 0 || this.outside_four[i][1] != 2 || this.faces[i][0] <= 0 || this.faces[i][1] != 2) continue;
            for (j = 2; j < 6; ++j) {
                pos = this.outside_four[i][j];
                if (this.occupied[pos] != 0) continue;
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("check_outside_four:  true");
                }
                return true;
            }
        }
        for (i = 0; i < 18; ++i) {
            if (this.outside_four[i][0] != 0 && (this.outside_four[i][0] <= 0 || this.outside_four[i][1] != 2)) continue;
            if (this.outside_four[i][1] == 2) {
                this.outside_four_flag = true;
            }
            for (j = 2; j < 6; ++j) {
                pos = this.outside_four[i][j];
                if (this.occupied[pos] != 0) continue;
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("check_outside_four:  true");
                }
                return true;
            }
        }
        if (this.debug) {
            System.out.println("check_outside_four:  false");
        }
        return false;
    }

    public boolean take_outside_four() {
        int pos = 0;
        boolean found = false;
        if (this.occupied[0] == 0) {
            found = true;
            pos = 0;
        } else if (this.occupied[3] == 0) {
            found = true;
            pos = 3;
        } else if (this.occupied[12] == 0) {
            found = true;
            pos = 12;
        } else if (this.occupied[15] == 0) {
            found = true;
            pos = 15;
        } else if (this.occupied[48] == 0) {
            found = true;
            pos = 48;
        } else if (this.occupied[51] == 0) {
            found = true;
            pos = 51;
        } else if (this.occupied[60] == 0) {
            found = true;
            pos = 60;
        } else if (this.occupied[63] == 0) {
            found = true;
            pos = 63;
        }
        if (found) {
            this.occupied[pos] = 2;
            this.positions.set(pos, 2);
            this.player = this.update_logic_arrays(pos);
            if (this.debug) {
                System.out.println("take_outside_four:  true");
            }
            return true;
        }
        if (this.debug) {
            System.out.println("take_outside_four:  false");
        }
        return false;
    }

    public boolean block_intersecting_rows() {
        for (int i = 0; i < 76; ++i) {
            if (this.combinations[i][0] != 2 || this.combinations[i][1] != 1) continue;
            if (this.debug) {
                System.out.println("   row " + i + "has 2 positions occupied by the human");
            }
            this.combinations[i][6] = 1;
            for (int j = 2; j < 6; ++j) {
                int pos = this.combinations[i][j];
                if (this.occupied[pos] != 0) continue;
                for (int k = 0; k < 76; ++k) {
                    if (this.debug) {
                        System.out.println("   row " + k);
                    }
                    if (this.combinations[k][0] != 2 || this.combinations[k][1] != 1 || this.combinations[k][6] != 0) continue;
                    if (this.debug) {
                        System.out.println("found an intersecting row:   row " + k);
                    }
                    for (int l = 2; l < 6; ++l) {
                        if (pos != this.combinations[k][l]) continue;
                        this.combinations[i][6] = 0;
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("block_intersecting_rows:  true");
                        }
                        return true;
                    }
                }
            }
            this.combinations[i][6] = 0;
        }
        if (this.debug) {
            System.out.println("block_intersecting_rows:  false");
        }
        return false;
    }

    public boolean check_intersecting_rows2() {
        for (int i = 0; i < 76; ++i) {
            if (this.combinations[i][0] != 2 || this.combinations[i][1] != 1) continue;
            if (this.debug) {
                System.out.println("   row " + i + "has 2 positions occupied by the human");
            }
            this.combinations[i][6] = 1;
            for (int j = 2; j < 6; ++j) {
                int pos = this.combinations[i][j];
                if (this.occupied[pos] != 0) continue;
                for (int k = 0; k < 76; ++k) {
                    if (this.debug) {
                        System.out.println("   row " + k);
                    }
                    if (this.combinations[k][0] != 1 || this.combinations[k][1] != 1 || this.combinations[k][6] != 0) continue;
                    if (this.debug) {
                        System.out.println("found an intersecting row:   row " + k);
                    }
                    for (int l = 2; l < 6; ++l) {
                        if (pos != this.combinations[k][l]) continue;
                        this.combinations[i][6] = 0;
                        this.occupied[pos] = 2;
                        this.positions.set(pos, 2);
                        this.player = this.update_logic_arrays(pos);
                        if (this.debug) {
                            System.out.println("check_intersecting_rows:  true");
                        }
                        return true;
                    }
                }
            }
            this.combinations[i][6] = 0;
        }
        if (this.debug) {
            System.out.println("check_intersecting_rows:  false");
        }
        return false;
    }

    public boolean check_for_two() {
        for (int i = 0; i < 76; ++i) {
            if (this.combinations[i][0] != 2 || this.combinations[i][1] != 1 || this.combinations[i][6] != 0) continue;
            for (int j = 2; j < 6; ++j) {
                int pos = this.combinations[i][j];
                if (this.occupied[pos] != 0) continue;
                this.occupied[pos] = 2;
                this.positions.set(pos, 2);
                this.player = this.update_logic_arrays(pos);
                if (this.debug) {
                    System.out.println("check_for_two:  true");
                }
                return true;
            }
        }
        if (this.debug) {
            System.out.println("check_for_two:  false");
        }
        return false;
    }

    public void undo_move() {
        int i;
        if (this.nmoves == 0) {
            return;
        }
        this.undoFlag = true;
        this.positions.clear(this.moves[--this.nmoves]);
        this.positions.clear(this.moves[--this.nmoves]);
        this.positions.noWinner();
        this.canvas.repaint();
        this.inside_four_flag = false;
        this.outside_four_flag = false;
        this.block_chair_flag = false;
        for (i = 0; i < 64; ++i) {
            this.occupied[i] = 0;
        }
        for (i = 0; i < 18; ++i) {
            this.inside_four[i][0] = 0;
            this.inside_four[i][1] = 0;
            this.outside_four[i][0] = 0;
            this.outside_four[i][1] = 0;
        }
        for (i = 0; i < 18; ++i) {
            this.faces[i][0] = 0;
            this.faces[i][1] = 0;
        }
        for (i = 0; i < 76; ++i) {
            this.combinations[i][0] = 0;
            this.combinations[i][1] = 0;
        }
        if (this.nmoves == 0) {
            this.undoFlag = false;
            this.player = 1;
            return;
        }
        this.player = 1;
        for (int i2 = 0; i2 < this.nmoves; ++i2) {
            int pos = this.moves[i2];
            this.occupied[pos] = this.player;
            this.player = this.update_logic_arrays(pos);
        }
        this.update_best_picks();
        this.player = 1;
        this.undoFlag = false;
    }

    public int update_logic_arrays(int pos) {
        int j;
        int i;
        if (!this.undoFlag) {
            this.moves[this.nmoves++] = pos;
        }
        int num_combinations = this.pos_to_comb[pos][0];
        for (int j2 = 0; j2 < num_combinations; ++j2) {
            int comb = this.pos_to_comb[pos][j2 + 1];
            if (this.combinations[comb][1] != this.player && this.combinations[comb][1] != 0) {
                this.combinations[comb][0] = -1;
                continue;
            }
            int[] nArray = this.combinations[comb];
            nArray[0] = nArray[0] + 1;
            if (this.combinations[comb][0] == 4) {
                this.end_time = System.currentTimeMillis();
                this.time = (this.end_time - this.beg_time) / 1000L;
                this.panel.winner(this.player, this.skill_level, this.nmoves, this.time);
                this.panel.repaint();
                this.canvas.repaint();
                this.positions.winner();
                return 3;
            }
            this.combinations[comb][1] = this.player;
        }
        this.update_best_picks();
        for (i = 0; i < 18; ++i) {
            for (j = 2; j < 6; ++j) {
                if (pos != this.inside_four[i][j]) continue;
                if (this.inside_four[i][0] == 0) {
                    this.inside_four[i][0] = 1;
                    this.inside_four[i][1] = this.player;
                    continue;
                }
                if (this.inside_four[i][1] == this.player) {
                    int[] nArray = this.inside_four[i];
                    nArray[0] = nArray[0] + 1;
                    this.inside_four[i][1] = this.player;
                    continue;
                }
                this.inside_four[i][0] = -1;
            }
        }
        for (i = 0; i < 18; ++i) {
            for (j = 2; j < 6; ++j) {
                if (pos != this.outside_four[i][j]) continue;
                if (this.outside_four[i][0] == 0) {
                    this.outside_four[i][0] = 1;
                    this.outside_four[i][1] = this.player;
                    continue;
                }
                if (this.outside_four[i][1] == this.player) {
                    int[] nArray = this.outside_four[i];
                    nArray[0] = nArray[0] + 1;
                    this.outside_four[i][1] = this.player;
                    continue;
                }
                this.outside_four[i][0] = -1;
            }
        }
        for (i = 0; i < 18; ++i) {
            for (j = 2; j < 18; ++j) {
                if (pos != this.faces[i][j]) continue;
                if (this.faces[i][0] == 0) {
                    this.faces[i][0] = 1;
                    this.faces[i][1] = this.player;
                    continue;
                }
                if (this.faces[i][1] == this.player) {
                    int[] nArray = this.faces[i];
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                this.faces[i][0] = -1;
            }
        }
        if (this.player == 1) {
            return 2;
        }
        return 1;
    }

    public void newGame() {
        int i;
        this.inside_four_flag = false;
        this.outside_four_flag = false;
        this.block_chair_flag = false;
        for (i = 0; i < 18; ++i) {
            this.inside_four[i][0] = 0;
            this.inside_four[i][1] = 0;
            this.outside_four[i][0] = 0;
            this.outside_four[i][1] = 0;
        }
        for (i = 0; i < 18; ++i) {
            this.faces[i][0] = 0;
            this.faces[i][1] = 0;
        }
        for (i = 0; i < 64; ++i) {
            this.occupied[i] = 0;
        }
        for (i = 0; i < 76; ++i) {
            this.combinations[i][0] = 0;
            this.combinations[i][1] = 0;
        }
        this.update_best_picks();
        this.player = 1;
        this.nmoves = 0;
        this.positions.newGame();
    }

    public void set_skill_level(int level) {
        this.skill_level = level;
    }

    public void setup_pos_to_comb() {
        int j;
        int i;
        for (i = 0; i < 64; ++i) {
            int count = 1;
            this.pos_to_comb[i][0] = 0;
            for (j = 0; j < 76; ++j) {
                for (int k = 2; k < 6; ++k) {
                    if (this.combinations[j][k] != i) continue;
                    int[] nArray = this.pos_to_comb[i];
                    nArray[0] = nArray[0] + 1;
                    this.pos_to_comb[i][count++] = j;
                }
            }
        }
        if (this.debug) {
            for (i = 0; i < 64; ++i) {
                System.out.println("");
                for (j = 0; j < 8; ++j) {
                    System.out.println("pos_to_comb[" + i + "][" + j + "] = " + this.pos_to_comb[i][j]);
                }
            }
        }
    }

    public void update_best_picks() {
        int j;
        int i;
        for (i = 0; i < 64; ++i) {
            int count = 1;
            this.best_picks[i][0] = 0;
            if (this.occupied[i] != 0) continue;
            for (j = 0; j < 76; ++j) {
                if (this.combinations[j][0] != 0 && this.combinations[j][1] != 2) continue;
                for (int k = 2; k < 6; ++k) {
                    if (this.combinations[j][k] != i) continue;
                    int[] nArray = this.best_picks[i];
                    nArray[0] = nArray[0] + 1;
                    this.best_picks[i][count++] = j;
                }
            }
        }
        if (this.debug) {
            for (i = 0; i < 64; ++i) {
                System.out.println("");
                for (j = 0; j < 8; ++j) {
                    System.out.println("best_picks[" + i + "][" + j + "] = " + this.best_picks[i][j]);
                }
            }
        }
    }

    public void pick_best_position() {
        int pos = 0;
        int max_num = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.best_picks[i][0] <= max_num || this.occupied[i] != 0) continue;
            pos = i;
            max_num = this.best_picks[i][0];
        }
        this.occupied[pos] = 2;
        this.positions.set(pos, 2);
        this.player = this.update_logic_arrays(pos);
    }

    public boolean pick_7() {
        for (int i = 0; i < 64; ++i) {
            if (this.best_picks[i][0] != 7) continue;
            this.occupied[i] = 2;
            this.positions.set(i, 2);
            this.player = this.update_logic_arrays(i);
            return true;
        }
        return false;
    }

    public void change_face() {
        ++this.current_face;
        this.current_face %= 18;
    }

    public void label() {
        this.label_flag ^= true;
    }

    public boolean unoccupied(int pos) {
        return this.occupied[pos] == 0;
    }
}

