/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.four_by_four;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;

public class Cylinder {
    float[] verts;
    float[] normals;
    QuadArray quad = null;
    float div = 3.0f;
    Shape3D shape;

    public Cylinder(float x, float z, float radius, float length, int quality, Appearance a) {
        if (quality < 3) {
            quality = 3;
        }
        this.div = quality;
        this.verts = new float[quality * 12];
        this.normals = new float[quality * 12];
        double inc = Math.PI * 2 / (double)this.div;
        for (int i = 0; i < quality; ++i) {
            float z1 = radius * (float)Math.sin((double)i * inc) + z;
            float x1 = radius * (float)Math.cos((double)i * inc) + x;
            float z2 = radius * (float)Math.sin((double)(i + 1) * inc) + z;
            float x2 = radius * (float)Math.cos((double)(i + 1) * inc) + x;
            this.verts[12 * i] = x1;
            this.verts[12 * i + 1] = -length / 2.0f;
            this.verts[12 * i + 2] = z1;
            this.verts[12 * i + 3] = x1;
            this.verts[12 * i + 4] = length / 2.0f;
            this.verts[12 * i + 5] = z1;
            this.verts[12 * i + 6] = x2;
            this.verts[12 * i + 7] = length / 2.0f;
            this.verts[12 * i + 8] = z2;
            this.verts[12 * i + 9] = x2;
            this.verts[12 * i + 10] = -length / 2.0f;
            this.verts[12 * i + 11] = z2;
            float nz1 = (float)Math.sin((double)i * inc);
            float nx1 = (float)Math.cos((double)i * inc);
            float nz2 = (float)Math.sin((double)(i + 1) * inc);
            float nx2 = (float)Math.cos((double)(i + 1) * inc);
            this.normals[12 * i] = nx1;
            this.normals[12 * i + 1] = 0.0f;
            this.normals[12 * i + 2] = nz1;
            this.normals[12 * i + 3] = nx1;
            this.normals[12 * i + 4] = 0.0f;
            this.normals[12 * i + 5] = nz1;
            this.normals[12 * i + 6] = nx2;
            this.normals[12 * i + 7] = 0.0f;
            this.normals[12 * i + 8] = nz2;
            this.normals[12 * i + 9] = nx2;
            this.normals[12 * i + 10] = 0.0f;
            this.normals[12 * i + 11] = nz2;
        }
        this.quad = new QuadArray(quality * 4, 3);
        this.quad.setCoordinates(0, this.verts);
        this.quad.setNormals(0, this.normals);
        this.shape = new Shape3D((Geometry)this.quad, a);
    }

    Shape3D getShape() {
        return this.shape;
    }
}

