/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.four_by_four;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.four_by_four.Board;
import org.jdesktop.j3d.examples.four_by_four.Canvas2D;
import org.jdesktop.j3d.examples.four_by_four.PickDragBehavior;
import org.jdesktop.j3d.examples.four_by_four.Poles;
import org.jdesktop.j3d.examples.four_by_four.Positions;

public class FourByFour
extends Applet
implements ActionListener {
    private static final boolean writeScoresFile = false;
    String host;
    int port;
    Image backbuffer2D;
    int width;
    int height;
    int score;
    int level_weight;
    int move_weight;
    int time_weight;
    int skill_level;
    Canvas2D canvas2D;
    Canvas3D canvas3D;
    Board board;
    Panel b_container;
    Panel c_container;
    Panel l_container;
    Panel skill_panel;
    Panel instruct_panel;
    Panel winner_panel;
    Panel high_panel;
    Button instruct_button;
    Button new_button;
    Button skill_button;
    Button high_button;
    Button undo_button;
    Label skill_label;
    Label winner_label;
    Label winner_score_label;
    Label winner_name_label;
    Label winner_top_label;
    Label high_label;
    Label[] high_places;
    Label[] high_names;
    Label[] high_scores;
    TextArea instruct_text;
    TextArea high_text;
    TextField winner_name;
    Button instruct_return_button;
    Button skill_return_button;
    Button winner_return_button;
    Button high_return_button;
    CheckboxGroup group;
    InputStream inStream;
    static boolean appletFlag = true;
    boolean winner_flag = false;
    byte[] text;
    byte[] outText;
    String textString;
    String scoresString;
    int[] places;
    int[] scores;
    String[] names;
    Positions positions;
    private SimpleUniverse universe = null;

    public void init() {
        String string;
        int count;
        boolean scoreFlag;
        int token;
        URL scoreURL;
        int count2;
        int character;
        URL instrURL;
        this.port = 4111;
        this.width = 350;
        this.height = 350;
        this.level_weight = 1311;
        this.move_weight = 111;
        this.time_weight = 1000;
        this.setBackground(new Color(200, 200, 200));
        if (appletFlag) {
            this.host = this.getCodeBase().getHost();
            try {
                instrURL = Resources.getResource("four_by_four/instructions.txt");
                this.inStream = new BufferedInputStream(instrURL.openStream(), 8192);
                this.text = new byte[5000];
                character = this.inStream.read();
                count2 = 0;
                while (character != -1) {
                    this.text[count2++] = (byte)character;
                    character = this.inStream.read();
                }
                this.textString = new String(this.text);
                this.inStream.close();
            }
            catch (Exception e) {
                System.out.println("Error: " + e.toString());
            }
        } else {
            try {
                instrURL = Resources.getResource("four_by_four/instructions.txt");
                this.inStream = new BufferedInputStream(instrURL.openStream(), 8192);
                this.text = new byte[5000];
                character = this.inStream.read();
                count2 = 0;
                while (character != -1) {
                    this.text[count2++] = (byte)character;
                    character = this.inStream.read();
                }
                this.textString = new String(this.text);
                this.inStream.close();
            }
            catch (Exception e) {
                System.out.println("Error: " + e.toString());
            }
        }
        this.places = new int[20];
        this.scores = new int[20];
        this.names = new String[20];
        if (appletFlag) {
            try {
                scoreURL = Resources.getResource("four_by_four/scores.txt");
                this.inStream = new BufferedInputStream(scoreURL.openStream(), 8192);
                BufferedReader read = new BufferedReader(new InputStreamReader(this.inStream));
                StreamTokenizer st = new StreamTokenizer(read);
                st.whitespaceChars(32, 44);
                st.eolIsSignificant(false);
                token = st.nextToken();
                scoreFlag = true;
                for (count = 0; count < 20; ++count) {
                    this.places[count] = (int)st.nval;
                    string = new String("");
                    token = st.nextToken();
                    while (token == -3) {
                        string = string + st.sval;
                        string = string + " ";
                        token = st.nextToken();
                    }
                    this.names[count] = string;
                    this.scores[count] = (int)st.nval;
                    token = st.nextToken();
                }
                this.inStream.close();
            }
            catch (Exception e) {
                System.out.println("Error: " + e.toString());
            }
        } else {
            try {
                scoreURL = Resources.getResource("four_by_four/scores.txt");
                this.inStream = new BufferedInputStream(scoreURL.openStream(), 8192);
                BufferedReader read = new BufferedReader(new InputStreamReader(this.inStream));
                StreamTokenizer st = new StreamTokenizer(read);
                st.whitespaceChars(32, 44);
                st.eolIsSignificant(false);
                token = st.nextToken();
                scoreFlag = true;
                for (count = 0; count < 20; ++count) {
                    this.places[count] = (int)st.nval;
                    string = new String("");
                    token = st.nextToken();
                    while (token == -3) {
                        string = string + st.sval;
                        string = string + " ";
                        token = st.nextToken();
                    }
                    this.names[count] = string;
                    this.scores[count] = (int)st.nval;
                    token = st.nextToken();
                }
                this.inStream.close();
            }
            catch (Exception e) {
                System.out.println("Error: " + e.toString());
            }
        }
        this.positions = new Positions();
        this.board = new Board(this, this.positions, this.width, this.height);
        this.positions.setBoard(this.board);
        this.canvas2D = new Canvas2D(this.board);
        this.canvas2D.setSize(this.width, this.height);
        this.canvas2D.setLocation(this.width + 10, 5);
        this.canvas2D.addMouseListener(this.canvas2D);
        this.board.setCanvas(this.canvas2D);
        this.backbuffer2D = this.createImage(this.width, this.height);
        this.canvas2D.setBuffer(this.backbuffer2D);
        this.canvas3D = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.canvas3D.setSize(this.width, this.height);
        this.canvas3D.setLocation(5, 5);
        BranchGroup scene3D = this.createScene3D();
        this.universe = new SimpleUniverse(this.canvas3D);
        this.universe.addBranchGraph(scene3D);
        View view = this.universe.getViewer().getView();
        view.setProjectionPolicy(0);
        TransformGroup tg = this.universe.getViewingPlatform().getViewPlatformTransform();
        Transform3D transform = new Transform3D();
        transform.set(65.0f, new Vector3f(0.0f, 0.0f, 400.0f));
        tg.setTransform(transform);
        this.c_container = new Panel();
        this.c_container.setSize(720, 360);
        this.c_container.setLocation(0, 0);
        this.c_container.setVisible(true);
        this.c_container.setLayout(null);
        this.add(this.c_container);
        this.c_container.add(this.canvas2D);
        this.c_container.add((Component)this.canvas3D);
        this.setLayout(null);
        this.b_container = new Panel();
        this.b_container.setSize(720, 70);
        this.b_container.setLocation(0, 360);
        this.b_container.setVisible(true);
        this.b_container.setLayout(null);
        this.instruct_button = new Button("Instructions");
        this.instruct_button.setSize(135, 25);
        this.instruct_button.setLocation(10, 10);
        this.instruct_button.setVisible(true);
        this.instruct_button.addActionListener(this);
        this.new_button = new Button("New Game");
        this.new_button.setSize(135, 25);
        this.new_button.setLocation(150, 10);
        this.new_button.setVisible(true);
        this.new_button.addActionListener(this);
        this.undo_button = new Button("Undo Move");
        this.undo_button.setSize(135, 25);
        this.undo_button.setLocation(290, 10);
        this.undo_button.setVisible(true);
        this.undo_button.addActionListener(this);
        this.skill_button = new Button("Skill Level");
        this.skill_button.setSize(135, 25);
        this.skill_button.setLocation(430, 10);
        this.skill_button.setVisible(true);
        this.skill_button.addActionListener(this);
        this.high_button = new Button("High Scores");
        this.high_button.setSize(135, 25);
        this.high_button.setLocation(570, 10);
        this.high_button.setVisible(true);
        this.high_button.addActionListener(this);
        this.b_container.add(this.new_button);
        this.b_container.add(this.undo_button);
        this.b_container.add(this.skill_button);
        this.b_container.add(this.high_button);
        this.b_container.add(this.instruct_button);
        this.add(this.b_container);
        this.skill_panel = new Panel();
        this.skill_panel.setSize(400, 300);
        this.skill_panel.setLocation(200, 20);
        this.skill_panel.setLayout(null);
        this.skill_label = new Label("Pick your skill level:");
        this.skill_label.setSize(200, 25);
        this.skill_label.setLocation(25, 20);
        this.skill_label.setVisible(true);
        this.skill_panel.add(this.skill_label);
        this.group = new CheckboxGroup();
        Checkbox skill_1 = new Checkbox("Babe in the Woods        ", this.group, false);
        Checkbox skill_2 = new Checkbox("Walk and Chew Gum        ", this.group, false);
        Checkbox skill_3 = new Checkbox("Jeopardy Contestant      ", this.group, false);
        Checkbox skill_4 = new Checkbox("Rocket Scientist         ", this.group, false);
        Checkbox skill_5 = new Checkbox("Be afraid, be very afraid", this.group, true);
        skill_1.setSize(170, 25);
        skill_1.setLocation(80, 60);
        skill_1.setVisible(true);
        skill_2.setSize(170, 25);
        skill_2.setLocation(80, 100);
        skill_2.setVisible(true);
        skill_3.setSize(170, 25);
        skill_3.setLocation(80, 140);
        skill_3.setVisible(true);
        skill_4.setSize(170, 25);
        skill_4.setLocation(80, 180);
        skill_4.setVisible(true);
        skill_5.setSize(170, 25);
        skill_5.setLocation(80, 220);
        skill_5.setVisible(true);
        this.skill_return_button = new Button("Return");
        this.skill_return_button.setSize(120, 25);
        this.skill_return_button.setLocation(300, 370);
        this.skill_return_button.setVisible(false);
        this.skill_return_button.addActionListener(this);
        this.skill_panel.add(skill_1);
        this.skill_panel.add(skill_2);
        this.skill_panel.add(skill_3);
        this.skill_panel.add(skill_4);
        this.skill_panel.add(skill_5);
        this.skill_panel.setVisible(false);
        this.add(this.skill_return_button);
        this.add(this.skill_panel);
        this.instruct_return_button = new Button("Return");
        this.instruct_return_button.setLocation(300, 370);
        this.instruct_return_button.setSize(120, 25);
        this.instruct_return_button.setVisible(false);
        this.instruct_return_button.addActionListener(this);
        this.instruct_text = new TextArea(this.textString, 100, 200, 1);
        this.instruct_text.setSize(715, 350);
        this.instruct_text.setLocation(0, 0);
        this.instruct_text.setVisible(false);
        this.add(this.instruct_text);
        this.add(this.instruct_return_button);
        this.high_panel = new Panel();
        this.high_panel.setSize(715, 350);
        this.high_panel.setLocation(0, 0);
        this.high_panel.setVisible(false);
        this.high_panel.setLayout(null);
        this.high_label = new Label("High Scores");
        this.high_label.setLocation(330, 5);
        this.high_label.setSize(200, 30);
        this.high_label.setVisible(true);
        this.high_panel.add(this.high_label);
        this.high_places = new Label[20];
        this.high_names = new Label[20];
        this.high_scores = new Label[20];
        for (int i = 0; i < 20; ++i) {
            this.high_places[i] = new Label(Integer.toString(i + 1));
            this.high_places[i].setSize(20, 30);
            this.high_places[i].setVisible(true);
            this.high_names[i] = new Label(this.names[i]);
            this.high_names[i].setSize(150, 30);
            this.high_names[i].setVisible(true);
            this.high_scores[i] = new Label(Integer.toString(this.scores[i]));
            this.high_scores[i].setSize(150, 30);
            this.high_scores[i].setVisible(true);
            if (i < 10) {
                this.high_places[i].setLocation(70, i * 30 + 40);
                this.high_names[i].setLocation(100, i * 30 + 40);
                this.high_scores[i].setLocation(260, i * 30 + 40);
            } else {
                this.high_places[i].setLocation(425, (i - 10) * 30 + 40);
                this.high_names[i].setLocation(455, (i - 10) * 30 + 40);
                this.high_scores[i].setLocation(615, (i - 10) * 30 + 40);
            }
            this.high_panel.add(this.high_places[i]);
            this.high_panel.add(this.high_names[i]);
            this.high_panel.add(this.high_scores[i]);
        }
        this.high_return_button = new Button("Return");
        this.high_return_button.setSize(120, 25);
        this.high_return_button.setLocation(300, 370);
        this.high_return_button.setVisible(false);
        this.high_return_button.addActionListener(this);
        this.add(this.high_return_button);
        this.add(this.high_panel);
        this.winner_panel = new Panel();
        this.winner_panel.setLayout(null);
        this.winner_panel.setSize(600, 500);
        this.winner_panel.setLocation(0, 0);
        this.winner_return_button = new Button("Return");
        this.winner_return_button.setSize(120, 25);
        this.winner_return_button.setLocation(300, 360);
        this.winner_return_button.addActionListener(this);
        this.winner_panel.add(this.winner_return_button);
        this.winner_label = new Label("");
        this.winner_label.setSize(200, 30);
        this.winner_label.setLocation(270, 110);
        this.winner_score_label = new Label("");
        this.winner_score_label.setSize(200, 30);
        this.winner_top_label = new Label("You have a score in the top 20.");
        this.winner_top_label.setSize(200, 25);
        this.winner_top_label.setLocation(260, 185);
        this.winner_top_label.setVisible(false);
        this.winner_name_label = new Label("Enter your name here:");
        this.winner_name_label.setSize(150, 25);
        this.winner_name_label.setLocation(260, 210);
        this.winner_name_label.setVisible(false);
        this.winner_name = new TextField("");
        this.winner_name.setSize(200, 30);
        this.winner_name.setLocation(260, 240);
        this.winner_name.setVisible(false);
        this.winner_panel.add(this.winner_label);
        this.winner_panel.add(this.winner_score_label);
        this.winner_panel.add(this.winner_top_label);
        this.winner_panel.add(this.winner_name_label);
        this.winner_panel.add(this.winner_name);
        this.winner_panel.setVisible(false);
        this.add(this.winner_panel);
    }

    public void destroy() {
        this.universe.cleanup();
    }

    public BranchGroup createScene3D() {
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f red = new Color3f(0.8f, 0.2f, 0.2f);
        Color3f ambient = new Color3f(0.25f, 0.25f, 0.25f);
        Color3f diffuse = new Color3f(0.7f, 0.7f, 0.7f);
        Color3f specular = new Color3f(0.9f, 0.9f, 0.9f);
        Color3f ambientRed = new Color3f(0.2f, 0.05f, 0.0f);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        BranchGroup branchGroup = new BranchGroup();
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
        BoundingLeaf boundingLeaf = new BoundingLeaf((Bounds)bounds);
        branchGroup.addChild((Node)boundingLeaf);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        branchGroup.addChild((Node)bg);
        AmbientLight ambLight = new AmbientLight(white);
        ambLight.setInfluencingBounds((Bounds)bounds);
        branchGroup.addChild((Node)ambLight);
        Vector3f dir = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight dirLight = new DirectionalLight(white, dir);
        dirLight.setInfluencingBounds((Bounds)bounds);
        branchGroup.addChild((Node)dirLight);
        Material poleMaterial = new Material(ambient, black, diffuse, specular, 110.0f);
        poleMaterial.setLightingEnable(true);
        Appearance poleAppearance = new Appearance();
        poleAppearance.setMaterial(poleMaterial);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        branchGroup.addChild((Node)transformGroup);
        Poles poles = new Poles(poleAppearance);
        transformGroup.addChild((Node)poles.getChild());
        transformGroup.addChild((Node)this.positions.getChild());
        this.positions.setTransformGroup(transformGroup);
        PickDragBehavior behavior = new PickDragBehavior(this.canvas2D, this.canvas3D, this.positions, branchGroup, transformGroup);
        behavior.setSchedulingBounds((Bounds)bounds);
        transformGroup.addChild((Node)behavior);
        return branchGroup;
    }

    public void actionPerformed(ActionEvent event) {
        Object target = event.getSource();
        if (target == this.skill_return_button) {
            this.skill_panel.setVisible(false);
            this.skill_return_button.setVisible(false);
            this.c_container.setVisible(true);
            this.b_container.setVisible(true);
            this.newGame();
        } else if (target == this.winner_return_button) {
            if (this.winner_flag) {
                String name = this.winner_name.getText();
                String tmp_name = new String("");
                int tmp_score = 0;
                boolean insert_flag = false;
                this.winner_flag = false;
                for (int i = 0; i < 20; ++i) {
                    if (insert_flag) {
                        name = this.names[i];
                        this.score = this.scores[i];
                        this.names[i] = tmp_name;
                        this.scores[i] = tmp_score;
                        tmp_name = name;
                        tmp_score = this.score;
                    }
                    if (!insert_flag && this.score > this.scores[i]) {
                        tmp_name = this.names[i];
                        tmp_score = this.scores[i];
                        this.scores[i] = this.score;
                        this.names[i] = name;
                        insert_flag = true;
                    }
                    this.high_names[i].setText(this.names[i]);
                    this.high_scores[i].setText(Integer.toString(this.scores[i]));
                }
                this.scoresString = new String("");
                for (int i = 0; i < 20; ++i) {
                    int place = this.places[i];
                    this.scoresString = this.scoresString + Integer.toString(place);
                    this.scoresString = this.scoresString + "\t";
                    this.scoresString = this.scoresString + this.names[i];
                    this.scoresString = this.scoresString + "   ";
                    this.scoresString = this.scoresString + Integer.toString(this.scores[i]);
                    this.scoresString = this.scoresString + "\n";
                }
            }
            this.winner_panel.setVisible(false);
            this.winner_return_button.setVisible(false);
            this.winner_label.setVisible(false);
            this.winner_score_label.setVisible(false);
            this.winner_name_label.setVisible(false);
            this.winner_top_label.setVisible(false);
            this.winner_name.setVisible(false);
            this.c_container.setVisible(true);
            this.b_container.setVisible(true);
        } else if (target == this.high_return_button) {
            this.high_return_button.setVisible(false);
            this.high_panel.setVisible(false);
            this.c_container.setVisible(true);
            this.b_container.setVisible(true);
        } else if (target == this.instruct_return_button) {
            this.instruct_text.setVisible(false);
            this.instruct_return_button.setVisible(false);
            this.instruct_text.repaint();
            this.c_container.setVisible(true);
            this.b_container.setVisible(true);
        } else if (target == this.undo_button) {
            this.board.undo_move();
            this.canvas2D.repaint();
        } else if (target == this.instruct_button) {
            this.c_container.setVisible(false);
            this.b_container.setVisible(false);
            this.instruct_text.setVisible(true);
            this.instruct_return_button.setVisible(true);
        } else if (target == this.new_button) {
            this.newGame();
        } else if (target == this.skill_button) {
            this.c_container.setVisible(false);
            this.b_container.setVisible(false);
            this.skill_panel.setVisible(true);
            this.skill_return_button.setVisible(true);
        } else if (target == this.high_button) {
            BufferedReader read;
            URL scoreURL;
            if (appletFlag) {
                try {
                    scoreURL = Resources.getResource("four_by_four/scores.txt");
                    this.inStream = new BufferedInputStream(scoreURL.openStream(), 8192);
                    read = new BufferedReader(new InputStreamReader(this.inStream));
                    StreamTokenizer st = new StreamTokenizer(read);
                    st.whitespaceChars(32, 44);
                    st.eolIsSignificant(false);
                    int token = st.nextToken();
                    boolean scoreFlag = true;
                    for (int count = 0; count < 20; ++count) {
                        this.places[count] = (int)st.nval;
                        String string = new String("");
                        token = st.nextToken();
                        while (token == -3) {
                            string = string + st.sval;
                            string = string + " ";
                            token = st.nextToken();
                        }
                        this.names[count] = string;
                        this.scores[count] = (int)st.nval;
                        token = st.nextToken();
                    }
                    this.inStream.close();
                }
                catch (Exception ioe) {
                    System.out.println("Error: " + ioe.toString());
                }
            } else {
                try {
                    scoreURL = Resources.getResource("four_by_four/scores.txt");
                    this.inStream = new BufferedInputStream(scoreURL.openStream(), 8192);
                    read = new BufferedReader(new InputStreamReader(this.inStream));
                    StreamTokenizer st = new StreamTokenizer(read);
                    st.whitespaceChars(32, 44);
                    st.eolIsSignificant(false);
                    int token = st.nextToken();
                    boolean scoreFlag = true;
                    for (int count = 0; count < 20; ++count) {
                        this.places[count] = (int)st.nval;
                        String string = new String("");
                        token = st.nextToken();
                        while (token == -3) {
                            string = string + st.sval;
                            string = string + " ";
                            token = st.nextToken();
                        }
                        this.names[count] = string;
                        this.scores[count] = (int)st.nval;
                        token = st.nextToken();
                    }
                    this.inStream.close();
                }
                catch (Exception ioe) {
                    System.out.println("Error: " + ioe.toString());
                }
            }
            this.c_container.setVisible(false);
            this.b_container.setVisible(false);
            this.high_panel.setVisible(true);
            this.high_return_button.setVisible(true);
        }
        Checkbox box = this.group.getSelectedCheckbox();
        String label = box.getLabel();
        if (label.equals("Babe in the Woods        ")) {
            this.board.set_skill_level(0);
        } else if (label.equals("Walk and Chew Gum        ")) {
            this.board.set_skill_level(1);
        } else if (label.equals("Jeopardy Contestant      ")) {
            this.board.set_skill_level(2);
        } else if (label.equals("Rocket Scientist         ")) {
            this.board.set_skill_level(3);
        } else if (label.equals("Be afraid, be very afraid")) {
            this.board.set_skill_level(4);
        }
    }

    public void newGame() {
        this.board.newGame();
        this.canvas2D.repaint();
    }

    public void start() {
        if (appletFlag) {
            this.showStatus("FourByFour");
        }
    }

    public void winner(int player, int level, int nmoves, long time) {
        if (player == 1) {
            this.score = level * this.level_weight + (66 - nmoves) * this.move_weight - (int)Math.min(time * (long)this.time_weight, 5000L);
            this.winner_label.setText("Game over, you win!");
            this.winner_label.setLocation(290, 90);
            this.winner_score_label.setText("Score = " + this.score);
            this.winner_score_label.setVisible(true);
            this.winner_score_label.setLocation(315, 120);
            if (this.score > this.scores[19]) {
                this.winner_name_label.setVisible(true);
                this.winner_top_label.setVisible(true);
                this.winner_name.setVisible(true);
                this.winner_flag = true;
            }
        } else {
            this.winner_label.setText("Game over, the computer wins!");
            this.winner_label.setLocation(250, 150);
        }
        this.c_container.setVisible(false);
        this.b_container.setVisible(false);
        this.winner_panel.setVisible(true);
        this.winner_label.setVisible(true);
        this.winner_return_button.setVisible(true);
        this.repaint();
    }

    public static void main(String[] args) {
        appletFlag = false;
        new MainFrame((Applet)new FourByFour(), 730, 450);
    }

    static class killAdapter
    extends WindowAdapter {
        killAdapter() {
        }

        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }
    }
}

