/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.four_by_four;

import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.examples.four_by_four.Canvas2D;
import org.jdesktop.j3d.examples.four_by_four.ID;
import org.jdesktop.j3d.examples.four_by_four.Positions;

public class PickDragBehavior
extends Behavior {
    WakeupCriterion[] mouseEvents;
    WakeupOr mouseCriterion;
    int x;
    int y;
    int x_last;
    int y_last;
    double x_angle;
    double y_angle;
    double x_factor;
    double y_factor;
    Transform3D modelTrans;
    Transform3D transformX;
    Transform3D transformY;
    TransformGroup transformGroup;
    BranchGroup branchGroup;
    Canvas2D canvas2D;
    Canvas3D canvas3D;
    Positions positions;
    PickRay pickRay = new PickRay();
    SceneGraphPath[] sceneGraphPath;
    Appearance highlight;
    boolean parallel;

    PickDragBehavior(Canvas2D canvas2D, Canvas3D canvas3D, Positions positions, BranchGroup branchGroup, TransformGroup transformGroup) {
        this.canvas2D = canvas2D;
        this.canvas3D = canvas3D;
        this.positions = positions;
        this.branchGroup = branchGroup;
        this.transformGroup = transformGroup;
        this.modelTrans = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f green = new Color3f(0.0f, 1.0f, 0.0f);
        this.highlight = new Appearance();
        this.highlight.setMaterial(new Material(green, black, green, white, 80.0f));
        this.parallel = true;
    }

    public void initialize() {
        this.x = 0;
        this.y = 0;
        this.x_last = 0;
        this.y_last = 0;
        this.x_angle = 0.0;
        this.y_angle = 0.0;
        this.x_factor = 0.02;
        this.y_factor = 0.02;
        this.mouseEvents = new WakeupCriterion[2];
        this.mouseEvents[0] = new WakeupOnAWTEvent(506);
        this.mouseEvents[1] = new WakeupOnAWTEvent(501);
        this.mouseCriterion = new WakeupOr(this.mouseEvents);
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            block3: for (int i = 0; i < event.length; ++i) {
                Vector3d mouseVec;
                int id = event[i].getID();
                if (id == 506) {
                    this.x = ((MouseEvent)event[i]).getX();
                    this.y = ((MouseEvent)event[i]).getY();
                    int dx = this.x - this.x_last;
                    int dy = this.y - this.y_last;
                    this.x_angle = (double)dy * this.y_factor;
                    this.y_angle = (double)dx * this.x_factor;
                    this.transformX.rotX(this.x_angle);
                    this.transformY.rotY(this.y_angle);
                    this.modelTrans.mul(this.transformX, this.modelTrans);
                    this.modelTrans.mul(this.transformY, this.modelTrans);
                    this.transformGroup.setTransform(this.modelTrans);
                    this.x_last = this.x;
                    this.y_last = this.y;
                    continue;
                }
                if (id != 501) continue;
                this.x = this.x_last = ((MouseEvent)event[i]).getX();
                this.y = this.y_last = ((MouseEvent)event[i]).getY();
                Point3d eyePos = new Point3d();
                this.canvas3D.getCenterEyeInImagePlate(eyePos);
                Point3d mousePos = new Point3d();
                this.canvas3D.getPixelLocationInImagePlate(this.x, this.y, mousePos);
                Transform3D transform3D = new Transform3D();
                this.canvas3D.getImagePlateToVworld(transform3D);
                transform3D.transform(eyePos);
                transform3D.transform(mousePos);
                if (this.parallel) {
                    mouseVec = new Vector3d(0.0, 0.0, -1.0);
                } else {
                    mouseVec = new Vector3d();
                    mouseVec.sub((Tuple3d)mousePos, (Tuple3d)eyePos);
                    mouseVec.normalize();
                }
                this.pickRay.set(mousePos, mouseVec);
                this.sceneGraphPath = this.branchGroup.pickAllSorted((PickShape)this.pickRay);
                if (this.sceneGraphPath == null) continue;
                for (int j = 0; j < this.sceneGraphPath.length; ++j) {
                    Node node;
                    if (this.sceneGraphPath[j] == null || !((node = this.sceneGraphPath[j].getObject()) instanceof Shape3D)) continue;
                    try {
                        ID posID = (ID)node.getUserData();
                        if (posID == null) continue;
                        int pos = posID.get();
                        this.positions.set(pos, 1);
                        this.canvas2D.repaint();
                        continue block3;
                    }
                    catch (CapabilityNotSetException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }
}

