/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.gears;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Gear
extends TransformGroup {
    static final int OutwardNormals = 1;
    static final int InwardNormals = -1;
    int toothCount;
    double gearStartAngle;
    float toothTopCenterAngle;
    float valleyCenterAngle;
    float circularPitchAngle;
    float toothValleyAngleIncrement;
    final Vector3f frontNormal = new Vector3f(0.0f, 0.0f, -1.0f);
    final Vector3f rearNormal = new Vector3f(0.0f, 0.0f, 1.0f);

    Gear(int toothCount) {
        this.toothCount = toothCount;
    }

    void addBodyDisks(float shaftRadius, float bodyOuterRadius, float thickness, Appearance look) {
        float yRoot4;
        float xRoot4;
        float yShaft4;
        float xShaft4;
        float yRoot3;
        float xRoot3;
        float yShaft3;
        float xShaft3;
        double nextToothStartAngle;
        double toothValleyStartAngle;
        double toothStartAngle;
        int index;
        int gearBodyTotalVertexCount;
        int[] gearBodyStripCount = new int[1];
        Point3f coordinate = new Point3f(0.0f, 0.0f, 0.0f);
        double gearStartAngle = -1.0 * (double)this.toothTopCenterAngle;
        float frontZ = -0.5f * thickness;
        float rearZ = 0.5f * thickness;
        int gearBodySegmentVertexCount = 4;
        gearBodyStripCount[0] = gearBodyTotalVertexCount = 2 + gearBodySegmentVertexCount * this.toothCount;
        TriangleStripArray frontGearBody = new TriangleStripArray(gearBodyTotalVertexCount, 3, gearBodyStripCount);
        float xDirection = (float)Math.cos(gearStartAngle);
        float yDirection = (float)Math.sin(gearStartAngle);
        float xShaft0 = shaftRadius * xDirection;
        float yShaft0 = shaftRadius * yDirection;
        float xRoot0 = bodyOuterRadius * xDirection;
        float yRoot0 = bodyOuterRadius * yDirection;
        coordinate.set(xRoot0, yRoot0, frontZ);
        frontGearBody.setCoordinate(0, coordinate);
        frontGearBody.setNormal(0, this.frontNormal);
        coordinate.set(xShaft0, yShaft0, frontZ);
        frontGearBody.setCoordinate(1, coordinate);
        frontGearBody.setNormal(1, this.frontNormal);
        for (int count = 0; count < this.toothCount; ++count) {
            index = 2 + count * 4;
            toothStartAngle = gearStartAngle + (double)this.circularPitchAngle * (double)count;
            toothValleyStartAngle = toothStartAngle + (double)this.toothValleyAngleIncrement;
            nextToothStartAngle = toothStartAngle + (double)this.circularPitchAngle;
            xDirection = (float)Math.cos(toothValleyStartAngle);
            yDirection = (float)Math.sin(toothValleyStartAngle);
            xShaft3 = shaftRadius * xDirection;
            yShaft3 = shaftRadius * yDirection;
            xRoot3 = bodyOuterRadius * xDirection;
            yRoot3 = bodyOuterRadius * yDirection;
            xDirection = (float)Math.cos(nextToothStartAngle);
            yDirection = (float)Math.sin(nextToothStartAngle);
            xShaft4 = shaftRadius * xDirection;
            yShaft4 = shaftRadius * yDirection;
            xRoot4 = bodyOuterRadius * xDirection;
            yRoot4 = bodyOuterRadius * yDirection;
            coordinate.set(xRoot3, yRoot3, frontZ);
            frontGearBody.setCoordinate(index, coordinate);
            frontGearBody.setNormal(index, this.frontNormal);
            coordinate.set(xShaft3, yShaft3, frontZ);
            frontGearBody.setCoordinate(index + 1, coordinate);
            frontGearBody.setNormal(index + 1, this.frontNormal);
            coordinate.set(xRoot4, yRoot4, frontZ);
            frontGearBody.setCoordinate(index + 2, coordinate);
            frontGearBody.setNormal(index + 2, this.frontNormal);
            coordinate.set(xShaft4, yShaft4, frontZ);
            frontGearBody.setCoordinate(index + 3, coordinate);
            frontGearBody.setNormal(index + 3, this.frontNormal);
        }
        Shape3D newShape = new Shape3D((Geometry)frontGearBody, look);
        this.addChild((Node)newShape);
        TriangleStripArray rearGearBody = new TriangleStripArray(gearBodyTotalVertexCount, 3, gearBodyStripCount);
        xDirection = (float)Math.cos(gearStartAngle);
        yDirection = (float)Math.sin(gearStartAngle);
        xShaft0 = shaftRadius * xDirection;
        yShaft0 = shaftRadius * yDirection;
        xRoot0 = bodyOuterRadius * xDirection;
        yRoot0 = bodyOuterRadius * yDirection;
        coordinate.set(xShaft0, yShaft0, rearZ);
        rearGearBody.setCoordinate(0, coordinate);
        rearGearBody.setNormal(0, this.rearNormal);
        coordinate.set(xRoot0, yRoot0, rearZ);
        rearGearBody.setCoordinate(1, coordinate);
        rearGearBody.setNormal(1, this.rearNormal);
        for (int count = 0; count < this.toothCount; ++count) {
            index = 2 + count * 4;
            toothStartAngle = gearStartAngle + (double)this.circularPitchAngle * (double)count;
            toothValleyStartAngle = toothStartAngle + (double)this.toothValleyAngleIncrement;
            nextToothStartAngle = toothStartAngle + (double)this.circularPitchAngle;
            xDirection = (float)Math.cos(toothValleyStartAngle);
            yDirection = (float)Math.sin(toothValleyStartAngle);
            xShaft3 = shaftRadius * xDirection;
            yShaft3 = shaftRadius * yDirection;
            xRoot3 = bodyOuterRadius * xDirection;
            yRoot3 = bodyOuterRadius * yDirection;
            xDirection = (float)Math.cos(nextToothStartAngle);
            yDirection = (float)Math.sin(nextToothStartAngle);
            xShaft4 = shaftRadius * xDirection;
            yShaft4 = shaftRadius * yDirection;
            xRoot4 = bodyOuterRadius * xDirection;
            yRoot4 = bodyOuterRadius * yDirection;
            coordinate.set(xShaft3, yShaft3, rearZ);
            rearGearBody.setCoordinate(index, coordinate);
            rearGearBody.setNormal(index, this.rearNormal);
            coordinate.set(xRoot3, yRoot3, rearZ);
            rearGearBody.setCoordinate(index + 1, coordinate);
            rearGearBody.setNormal(index + 1, this.rearNormal);
            coordinate.set(xShaft4, yShaft4, rearZ);
            rearGearBody.setCoordinate(index + 2, coordinate);
            rearGearBody.setNormal(index + 2, this.rearNormal);
            coordinate.set(xRoot4, yRoot4, rearZ);
            rearGearBody.setCoordinate(index + 3, coordinate);
            rearGearBody.setNormal(index + 3, this.rearNormal);
        }
        newShape = new Shape3D((Geometry)rearGearBody, look);
        this.addChild((Node)newShape);
    }

    void addCylinderSkins(float shaftRadius, float length, int normalDirection, Appearance look) {
        int secondIndex;
        int firstIndex;
        int insideShaftVertexCount;
        int[] insideShaftStripCount = new int[1];
        float frontZ = -0.5f * length;
        float rearZ = 0.5f * length;
        Point3f coordinate = new Point3f(0.0f, 0.0f, 0.0f);
        Vector3f surfaceNormal = new Vector3f();
        insideShaftStripCount[0] = insideShaftVertexCount = 4 * this.toothCount + 2;
        TriangleStripArray insideShaft = new TriangleStripArray(insideShaftVertexCount, 3, insideShaftStripCount);
        float xShaft3 = shaftRadius * (float)Math.cos(this.gearStartAngle);
        float yShaft3 = shaftRadius * (float)Math.sin(this.gearStartAngle);
        if (normalDirection == 1) {
            surfaceNormal.set(1.0f, 0.0f, 0.0f);
            firstIndex = 1;
            secondIndex = 0;
        } else {
            surfaceNormal.set(-1.0f, 0.0f, 0.0f);
            firstIndex = 0;
            secondIndex = 1;
        }
        coordinate.set(shaftRadius, 0.0f, frontZ);
        insideShaft.setCoordinate(firstIndex, coordinate);
        insideShaft.setNormal(firstIndex, surfaceNormal);
        coordinate.set(shaftRadius, 0.0f, rearZ);
        insideShaft.setCoordinate(secondIndex, coordinate);
        insideShaft.setNormal(secondIndex, surfaceNormal);
        for (int count = 0; count < this.toothCount; ++count) {
            int index = 2 + count * 4;
            double toothStartAngle = (double)this.circularPitchAngle * (double)count;
            double toothValleyStartAngle = toothStartAngle + (double)this.toothValleyAngleIncrement;
            double nextToothStartAngle = toothStartAngle + (double)this.circularPitchAngle;
            float xDirection = (float)Math.cos(toothValleyStartAngle);
            float yDirection = (float)Math.sin(toothValleyStartAngle);
            xShaft3 = shaftRadius * xDirection;
            yShaft3 = shaftRadius * yDirection;
            if (normalDirection == 1) {
                surfaceNormal.set(xDirection, yDirection, 0.0f);
            } else {
                surfaceNormal.set(-xDirection, -yDirection, 0.0f);
            }
            coordinate.set(xShaft3, yShaft3, frontZ);
            insideShaft.setCoordinate(index + firstIndex, coordinate);
            insideShaft.setNormal(index + firstIndex, surfaceNormal);
            coordinate.set(xShaft3, yShaft3, rearZ);
            insideShaft.setCoordinate(index + secondIndex, coordinate);
            insideShaft.setNormal(index + secondIndex, surfaceNormal);
            xDirection = (float)Math.cos(nextToothStartAngle);
            yDirection = (float)Math.sin(nextToothStartAngle);
            float xShaft4 = shaftRadius * xDirection;
            float yShaft4 = shaftRadius * yDirection;
            if (normalDirection == 1) {
                surfaceNormal.set(xDirection, yDirection, 0.0f);
            } else {
                surfaceNormal.set(-xDirection, -yDirection, 0.0f);
            }
            coordinate.set(xShaft4, yShaft4, frontZ);
            insideShaft.setCoordinate(index + 2 + firstIndex, coordinate);
            insideShaft.setNormal(index + 2 + firstIndex, surfaceNormal);
            coordinate.set(xShaft4, yShaft4, rearZ);
            insideShaft.setCoordinate(index + 2 + secondIndex, coordinate);
            insideShaft.setNormal(index + 2 + secondIndex, surfaceNormal);
        }
        Shape3D newShape = new Shape3D((Geometry)insideShaft, look);
        this.addChild((Node)newShape);
    }

    public float getToothTopCenterAngle() {
        return this.toothTopCenterAngle;
    }

    public float getValleyCenterAngle() {
        return this.valleyCenterAngle;
    }

    public float getCircularPitchAngle() {
        return this.circularPitchAngle;
    }
}

