/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.gears;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.gears.Shaft;
import org.jdesktop.j3d.examples.gears.SpurGear;
import org.jdesktop.j3d.examples.gears.SpurGearThinBody;

public class GearBox
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private int toothCount = 48;
    private JPanel drawingPanel;

    public BranchGroup createSceneGraph() {
        int i;
        int i2;
        Transform3D tempTransform = new Transform3D();
        BranchGroup branchRoot = this.createBranchEnvironment();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        branchRoot.addChild((Node)objScale);
        Appearance look = new Appearance();
        Color3f objColor = new Color3f(0.5f, 0.5f, 0.6f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        look.setMaterial(new Material(objColor, black, objColor, white, 100.0f));
        TransformGroup gearboxTrans = new TransformGroup();
        gearboxTrans.setCapability(18);
        gearboxTrans.setCapability(17);
        objScale.addChild((Node)gearboxTrans);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        int shaftCount = 4;
        int secondsPerRevolution = 8000;
        Shaft[] shafts = new Shaft[shaftCount];
        TransformGroup[] shaftTGs = new TransformGroup[shaftCount];
        Alpha[] shaftAlphas = new Alpha[shaftCount];
        RotationInterpolator[] shaftRotors = new RotationInterpolator[shaftCount];
        Transform3D[] shaftAxis = new Transform3D[shaftCount];
        float[] shaftRatios = new float[shaftCount];
        shaftRatios[0] = 1.0f;
        shaftRatios[1] = 0.5f;
        shaftRatios[2] = 0.75f;
        shaftRatios[3] = 5.0f;
        float[] shaftRadius = new float[shaftCount];
        shaftRadius[0] = 0.2f;
        shaftRadius[1] = 0.2f;
        shaftRadius[2] = 0.2f;
        shaftRadius[3] = 0.2f;
        float[] shaftLength = new float[shaftCount];
        shaftLength[0] = 1.8f;
        shaftLength[1] = 0.8f;
        shaftLength[2] = 0.8f;
        shaftLength[3] = 0.8f;
        float[] shaftDirection = new float[shaftCount];
        shaftDirection[0] = 1.0f;
        shaftDirection[1] = -1.0f;
        shaftDirection[2] = 1.0f;
        shaftDirection[3] = -1.0f;
        Vector3d[] shaftPlacement = new Vector3d[shaftCount];
        shaftPlacement[0] = new Vector3d(-0.75, -0.9, 0.0);
        shaftPlacement[1] = new Vector3d(0.75, -0.9, 0.0);
        shaftPlacement[2] = new Vector3d(0.75, 0.35, 0.0);
        shaftPlacement[3] = new Vector3d(-0.75, 0.6, -0.7);
        for (i2 = 0; i2 < shaftCount; ++i2) {
            shafts[i2] = new Shaft(shaftRadius[i2], shaftLength[i2], 25, look);
        }
        for (i2 = 0; i2 < shaftCount; ++i2) {
            shaftTGs[i2] = new TransformGroup();
            gearboxTrans.addChild((Node)shaftTGs[i2]);
            shaftTGs[i2].getTransform(tempTransform);
            tempTransform.setTranslation(shaftPlacement[i2]);
            shaftTGs[i2].setTransform(tempTransform);
            shaftTGs[i2].addChild((Node)shafts[i2]);
        }
        for (i2 = 0; i2 < shaftCount; ++i2) {
            shaftAlphas[i2] = new Alpha(-1, 1, 0L, 0L, (long)((float)secondsPerRevolution * shaftRatios[i2]), 0L, 0L, 0L, 0L, 0L);
            shaftAxis[i2] = new Transform3D();
            shaftAxis[i2].rotX(1.5707963267948966);
            shaftRotors[i2] = new RotationInterpolator(shaftAlphas[i2], (TransformGroup)shafts[i2], shaftAxis[i2], 0.0f, shaftDirection[i2] * (float)Math.PI * 2.0f);
            shaftRotors[i2].setSchedulingBounds((Bounds)bounds);
            shaftTGs[i2].addChild((Node)shaftRotors[i2]);
        }
        int gearCount = 5;
        float valleyToCircularPitchRatio = 0.15f;
        float pitchCircleRadius = 1.0f;
        float addendum = 0.05f;
        float dedendum = 0.05f;
        float gearThickness = 0.3f;
        float toothTipThickness = 0.27f;
        SpurGear[] gears = new SpurGear[gearCount];
        TransformGroup[] gearTGs = new TransformGroup[gearCount];
        int[] gearShaft = new int[gearCount];
        gearShaft[0] = 0;
        gearShaft[1] = 1;
        gearShaft[2] = 2;
        gearShaft[3] = 0;
        gearShaft[4] = 3;
        float[] ratio = new float[gearCount];
        ratio[0] = 1.0f;
        ratio[1] = 0.5f;
        ratio[2] = 0.75f;
        ratio[3] = 0.25f;
        ratio[4] = 1.25f;
        Vector3d[] placement = new Vector3d[gearCount];
        placement[0] = new Vector3d(0.0, 0.0, 0.0);
        placement[1] = new Vector3d(0.0, 0.0, 0.0);
        placement[2] = new Vector3d(0.0, 0.0, 0.0);
        placement[3] = new Vector3d(0.0, 0.0, -0.7);
        placement[4] = new Vector3d(0.0, 0.0, 0.0);
        for (i = 0; i < gearCount; ++i) {
            gears[i] = new SpurGearThinBody((int)((float)this.toothCount * ratio[i]), pitchCircleRadius * ratio[i], shaftRadius[0], addendum, dedendum, gearThickness, toothTipThickness, valleyToCircularPitchRatio, look);
        }
        for (i = 0; i < gearCount; ++i) {
            gearTGs[i] = new TransformGroup();
            gearTGs[i].getTransform(tempTransform);
            tempTransform.rotZ((double)shaftDirection[gearShaft[i]] == -1.0 ? (double)(gears[i].getCircularPitchAngle() / -2.0f) : 0.0);
            tempTransform.setTranslation(placement[i]);
            gearTGs[i].setTransform(tempTransform);
            gearTGs[i].addChild((Node)gears[i]);
            shafts[gearShaft[i]].addChild((Node)gearTGs[i]);
        }
        branchRoot.compile();
        return branchRoot;
    }

    BranchGroup createBranchEnvironment() {
        BranchGroup branchRoot = new BranchGroup();
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        branchRoot.addChild((Node)bgNode);
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        branchRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        branchRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        branchRoot.addChild((Node)light2);
        return branchRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.univ.getViewingPlatform();
        OrbitBehavior orbit = new OrbitBehavior(c, 112);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public GearBox(String[] args) {
        if (args.length > 1) {
            System.out.println("Usage: java GearBox  #teeth (LCD 4)");
            System.exit(0);
        } else if (args.length == 1) {
            int value;
            try {
                value = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.out.println("Illegal integer specified");
                System.out.println("Usage: java GearBox  #teeth (LCD 4)");
                value = 0;
                System.exit(0);
            }
            if (value <= 0 | value % 4 != 0) {
                System.out.println("Integer not a positive multiple of 4");
                System.out.println("Usage: java GearBox  #teeth (LCD 4)");
                System.exit(0);
            }
            this.toothCount = value;
        }
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("GearBox");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                GearBox gb = new GearBox(args);
                gb.setVisible(true);
            }
        });
    }
}

