/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.geometry_by_ref;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class TiledImage
implements RenderedImage {
    WritableRaster[][] tile = new WritableRaster[3][3];
    WritableRaster bigTile;
    ComponentColorModel colorModel;
    BufferedImage checkBoard;
    int minX = -2;
    int minY = -1;

    TiledImage() {
        int j;
        int i;
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        int cc = 255;
        int[] bandOffset = new int[4];
        this.colorModel = new ComponentColorModel(cs, nBits, true, false, 1, 0);
        bandOffset[0] = 3;
        bandOffset[1] = 2;
        bandOffset[2] = 1;
        bandOffset[3] = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.tile[i][j] = Raster.createInterleavedRaster(0, 8, 8, 32, 4, bandOffset, null);
            }
        }
        byte[] byteData = ((DataBufferByte)this.tile[0][0].getDataBuffer()).getData();
        i = 4;
        int k = 144;
        while (i < 8) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = (byte)cc;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            ++i;
            k += 16;
        }
        byteData = ((DataBufferByte)this.tile[1][0].getDataBuffer()).getData();
        k = 128;
        for (i = 4; i < 8; ++i) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = (byte)cc;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
        }
        byteData = ((DataBufferByte)this.tile[2][0].getDataBuffer()).getData();
        i = 4;
        k = 128;
        while (i < 8) {
            j = 0;
            while (j < 4) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            ++i;
            k += 16;
        }
        byteData = ((DataBufferByte)this.tile[0][1].getDataBuffer()).getData();
        i = 0;
        k = 16;
        while (i < 4) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = (byte)cc;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            ++i;
            k += 16;
        }
        i = 4;
        k = 144;
        while (i < 8) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = 0;
                ++j;
                k += 4;
            }
            ++i;
            k += 16;
        }
        byteData = ((DataBufferByte)this.tile[1][1].getDataBuffer()).getData();
        k = 0;
        for (i = 0; i < 4; ++i) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = (byte)cc;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
        }
        k = 128;
        for (i = 0; i < 4; ++i) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = 0;
                ++j;
                k += 4;
            }
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
        }
        byteData = ((DataBufferByte)this.tile[2][1].getDataBuffer()).getData();
        i = 0;
        k = 0;
        while (i < 4) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            ++i;
            k += 16;
        }
        i = 4;
        k = 128;
        while (i < 8) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            ++i;
            k += 16;
        }
        byteData = ((DataBufferByte)this.tile[0][2].getDataBuffer()).getData();
        i = 4;
        k = 16;
        while (i < 8) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = 0;
                ++j;
                k += 4;
            }
            ++i;
            k += 16;
        }
        byteData = ((DataBufferByte)this.tile[1][2].getDataBuffer()).getData();
        k = 0;
        for (i = 0; i < 8; ++i) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = 0;
                ++j;
                k += 4;
            }
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
        }
        byteData = ((DataBufferByte)this.tile[2][2].getDataBuffer()).getData();
        i = 4;
        k = 0;
        while (i < 8) {
            j = 4;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            ++i;
            k += 16;
        }
        this.bigTile = Raster.createInterleavedRaster(0, 16, 16, 64, 4, bandOffset, null);
        byteData = ((DataBufferByte)this.bigTile.getDataBuffer()).getData();
        k = 0;
        for (i = 0; i < 8; ++i) {
            j = 0;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = (byte)cc;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            while (j < 16) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = 0;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
        }
        while (i < 16) {
            j = 0;
            while (j < 8) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = 0;
                ++j;
                k += 4;
            }
            while (j < 16) {
                byteData[k] = 0;
                byteData[k + 1] = 0;
                byteData[k + 2] = (byte)cc;
                byteData[k + 3] = (byte)cc;
                ++j;
                k += 4;
            }
            ++i;
        }
        this.checkBoard = new BufferedImage(this.colorModel, this.bigTile, false, null);
    }

    public WritableRaster copyData(WritableRaster raster) {
        return this.checkBoard.copyData(raster);
    }

    public ColorModel getColorModel() {
        return this.checkBoard.getColorModel();
    }

    public Raster getData() {
        return this.checkBoard.getData();
    }

    public Raster getData(Rectangle rect) {
        return this.checkBoard.getData(rect);
    }

    public int getHeight() {
        return 16;
    }

    public int getMinTileX() {
        return this.minX;
    }

    public int getMinTileY() {
        return this.minY;
    }

    public int getMinX() {
        return -8;
    }

    public int getMinY() {
        return -8;
    }

    public int getNumXTiles() {
        return 3;
    }

    public int getNumYTiles() {
        return 3;
    }

    public Object getProperty(String name) {
        return this.checkBoard.getProperty(name);
    }

    public String[] getPropertyNames() {
        return this.checkBoard.getPropertyNames();
    }

    public SampleModel getSampleModel() {
        return this.checkBoard.getSampleModel();
    }

    public Vector getSources() {
        return null;
    }

    public Raster getTile(int tileX, int tileY) {
        return this.tile[tileX - this.minX][tileY - this.minY];
    }

    public int getTileGridXOffset() {
        return 4;
    }

    public int getTileGridYOffset() {
        return -4;
    }

    public int getTileHeight() {
        return 8;
    }

    public int getTileWidth() {
        return 8;
    }

    public int getWidth() {
        return 16;
    }
}

