/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.geometry_compression;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.geometry.compression.CompressedGeometryData;
import com.sun.j3d.utils.geometry.compression.CompressedGeometryFile;
import com.sun.j3d.utils.geometry.compression.CompressionStream;
import com.sun.j3d.utils.geometry.compression.GeometryCompressor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import javax.media.j3d.Shape3D;

public class ObjectFileCompressor
extends ObjectFile {
    private GeometryCompressor compressor = new GeometryCompressor();
    private int positionQuant = 10;
    private int colorQuant = 8;
    private int normalQuant = 3;

    public ObjectFileCompressor() {
        super(640);
    }

    public ObjectFileCompressor(int flags) {
        super(flags | 0x200 | 0x80);
    }

    public ObjectFileCompressor(int flags, float radians) {
        super(flags | 0x200 | 0x80, radians);
    }

    public void setFlags(int flags) {
        super.setFlags(flags | 0x200 | 0x80);
    }

    public void setQuantization(int positionQuant, int colorQuant, int normalQuant) {
        this.positionQuant = positionQuant;
        this.colorQuant = colorQuant;
        this.normalQuant = normalQuant;
    }

    public CompressedGeometryData compress(String objFileName) {
        return this.compressScene(this.getScene(objFileName));
    }

    public void compress(String objFileName, CompressedGeometryFile file) throws IOException {
        this.compressScene(this.getScene(objFileName), file);
    }

    public CompressedGeometryData compress(Reader reader) {
        return this.compressScene(this.getScene(reader));
    }

    public void compress(Reader reader, CompressedGeometryFile file) throws IOException {
        this.compressScene(this.getScene(reader), file);
    }

    public CompressedGeometryData compress(URL url) {
        return this.compressScene(this.getScene(url));
    }

    public void compress(URL url, CompressedGeometryFile file) throws IOException {
        this.compressScene(this.getScene(url), file);
    }

    private CompressedGeometryData compressScene(Scene scene) {
        return this.compressor.compress(this.getStream(scene));
    }

    private void compressScene(Scene scene, CompressedGeometryFile file) throws IOException {
        this.compressor.compress(this.getStream(scene), file);
    }

    private CompressionStream getStream(Scene scene) {
        Hashtable objs = scene.getNamedObjects();
        Shape3D[] shapes = new Shape3D[objs.size()];
        objs.values().toArray(shapes);
        return new CompressionStream(this.positionQuant, this.colorQuant, this.normalQuant, shapes);
    }

    private Scene getScene(String objFileName) {
        Scene scene = null;
        try {
            scene = this.load(objFileName);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (ParsingErrorException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        catch (IncorrectFormatException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        return scene;
    }

    private Scene getScene(Reader reader) {
        Scene scene = null;
        try {
            scene = this.load(reader);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (ParsingErrorException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        catch (IncorrectFormatException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        return scene;
    }

    private Scene getScene(URL url) {
        Scene scene = null;
        try {
            scene = this.load(url);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (ParsingErrorException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        catch (IncorrectFormatException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        return scene;
    }
}

