/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.geometry_compression;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.compression.CompressedGeometryData;
import com.sun.j3d.utils.geometry.compression.CompressedGeometryFile;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class cgview
extends Applet {
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph(CompressedGeometryData cg) {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.7);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objScale.addChild((Node)objTrans);
        CompressedGeometryData.Header hdr = new CompressedGeometryData.Header();
        cg.getCompressedGeometryHeader(hdr);
        Shape3D[] shapes = cg.decompress();
        if (shapes != null) {
            for (int i = 0; i < shapes.length; ++i) {
                objTrans.addChild((Node)shapes[i]);
            }
        }
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bgNode);
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(1.0f, 1.0f, 1.0f);
        Color3f light2Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light2Direction = new Vector3f(-1.0f, -1.0f, -0.9f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light2);
        return objRoot;
    }

    private void usage() {
        System.out.println("Usage: cgview <.cg file> <object index>");
        System.exit(0);
    }

    public cgview(String[] args) {
        if (args.length < 1) {
            this.usage();
        }
        int index = args.length < 2 ? 0 : Integer.parseInt(args[1]);
        String filename = args[0];
        if (filename == null) {
            this.usage();
        }
        CompressedGeometryData cg = null;
        try {
            CompressedGeometryFile cgf = new CompressedGeometryFile(filename, false);
            if (cgf.getObjectCount() == 0) {
                System.out.println("no objects were found in " + filename);
                System.exit(0);
            }
            cg = cgf.read(index);
            cgf.close();
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(0);
        }
        this.setLayout(new BorderLayout());
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph(cg);
        this.u = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(c, 112);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new cgview(args), 700, 700);
    }
}

