/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.glsl_shader;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.shader.StringIO;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.io.IOException;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GLSLShaderProgram;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shader;
import javax.media.j3d.ShaderAppearance;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderAttributeValue;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderErrorListener;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.SourceCodeShader;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import org.jdesktop.j3d.examples.Resources;

public class EnvironmentMappingGLSL
extends JFrame {
    private URL textureURL = null;
    private static final int NUM_TEX_UNITS = 1;
    private static final int TEX_UNIT = 0;
    SimpleUniverse univ = null;
    private JPanel drawingPanel;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        this.textureURL = Resources.getResource("resources/images/duke-gears.jpg");
        Texture tex = new TextureLoader(this.textureURL, (Component)this).getTexture();
        String vertexProgram = null;
        String fragmentProgram = null;
        try {
            vertexProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/envmap.vert"));
            fragmentProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/envmap.frag"));
        }
        catch (IOException e) {
            System.err.println(e);
        }
        Shader[] shaders = new Shader[]{new SourceCodeShader(1, 1, vertexProgram), new SourceCodeShader(1, 2, fragmentProgram)};
        String[] shaderAttrNames = new String[]{"LightPos", "BaseColor", "MixRatio", "EnvMap"};
        Object[] shaderAttrValues = new Object[]{new Point3f(1.0f, -1.0f, 2.0f), new Color3f(0.2f, 0.9f, 0.5f), new Float(0.4f), new Integer(0)};
        GLSLShaderProgram shaderProgram = new GLSLShaderProgram();
        shaderProgram.setShaders(shaders);
        shaderProgram.setShaderAttrNames(shaderAttrNames);
        ShaderAttributeSet shaderAttributeSet = new ShaderAttributeSet();
        for (int i = 0; i < shaderAttrNames.length; ++i) {
            ShaderAttributeValue shaderAttribute = new ShaderAttributeValue(shaderAttrNames[i], shaderAttrValues[i]);
            shaderAttributeSet.put((ShaderAttribute)shaderAttribute);
        }
        ShaderAppearance app = new ShaderAppearance();
        app.setShaderProgram((ShaderProgram)shaderProgram);
        app.setShaderAttributeSet(shaderAttributeSet);
        TextureUnitState[] tus = new TextureUnitState[]{new TextureUnitState()};
        tus[0].setTexture(tex);
        app.setTextureUnitState(tus);
        Sphere sph = new Sphere(0.4f, 1, 20, (Appearance)app);
        objTrans.addChild((Node)sph);
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 4000L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)rotator);
        return objRoot;
    }

    private Canvas3D initScene() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        BranchGroup scene = this.createSceneGraph();
        this.univ = new SimpleUniverse(c);
        this.univ.addShaderErrorListener(new ShaderErrorListener(){

            public void errorOccurred(ShaderError error) {
                error.printVerbose();
                JOptionPane.showMessageDialog(EnvironmentMappingGLSL.this, error.toString(), "ShaderError", 0);
            }
        });
        ViewingPlatform viewingPlatform = this.univ.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        this.univ.addBranchGraph(scene);
        return c;
    }

    public EnvironmentMappingGLSL() {
        this.initComponents();
        Canvas3D c = this.initScene();
        this.drawingPanel.add((Component)c, "Center");
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("EnvironmentMappingGLSL");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new EnvironmentMappingGLSL().setVisible(true);
            }
        });
    }
}

