/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.glsl_shader;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.shader.StringIO;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GLSLShaderProgram;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PositionInterpolator;
import javax.media.j3d.Shader;
import javax.media.j3d.ShaderAppearance;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeObject;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderAttributeValue;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderErrorListener;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SourceCodeShader;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.examples.Resources;

public class ShaderTestGLSL
extends JFrame {
    static final int GOLD = 1;
    static final int SILVER = 2;
    static final int DIMPLE_SHADER = 1;
    static final int BRICK_SHADER = 2;
    static final int WOOD_SHADER = 3;
    static final int POLKADOT3D_SHADER = 4;
    static final String[] shaderAttrNames1 = new String[]{"Density", "Size", "LightPosition", "Color"};
    static final String[] shaderAttrNames2 = new String[]{"BrickColor", "LightPosition"};
    private SimpleUniverse univ = null;
    private View view;
    private BranchGroup transpObj;
    private BranchGroup scene = null;
    private int shaderSelected = 1;
    private float density = 16.0f;
    private int color = 1;
    private Color3f eColor = new Color3f(0.2f, 0.2f, 0.2f);
    private Color3f sColor = new Color3f(0.8f, 0.8f, 0.8f);
    private Color3f objColor = new Color3f(0.6f, 0.6f, 0.6f);
    private Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
    private Color3f gold = new Color3f(0.7f, 0.6f, 0.18f);
    private Color3f silver = new Color3f(0.75f, 0.75f, 0.75f);
    private ShaderAppearance sApp1 = null;
    private ShaderAppearance sApp2 = null;
    private ShaderAppearance sApp3 = null;
    private ShaderAppearance sApp4 = null;
    private ShaderProgram sp1 = null;
    private ShaderProgram sp2 = null;
    private ShaderProgram sp3 = null;
    private ShaderProgram sp4 = null;
    private ShaderAttributeSet sas1 = null;
    private ShaderAttributeSet sas2 = null;
    private ShaderAttributeObject sao1 = null;
    private ShaderAttributeObject sao2 = null;
    private Sphere sphere = null;
    private Shape3D s3d = null;
    private JToggleButton AttachButton;
    private JToggleButton DetachButton;
    private ButtonGroup colorButtonGroup;
    private JPanel colorPanel;
    private ButtonGroup densityButtonGroup;
    private JPanel densityPanel;
    private JPanel drawingPanel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JRadioButton fullButton;
    private JRadioButton goldButton;
    private JPanel guiPanel;
    private JRadioButton halfButton;
    private JMenuBar jMenuBar1;
    private JPanel mainPanel;
    private JButton replaceSPButton;
    private ButtonGroup sceneGraphButtonGroup;
    private JPanel sceneGraphPanel;
    private JRadioButton silverButton;
    private JRadioButton zeroButton;

    private Material createMaterial() {
        Material m = new Material(this.objColor, this.eColor, this.objColor, this.sColor, 100.0f);
        m.setLightingEnable(true);
        return m;
    }

    private ShaderProgram createGLSLShaderProgram(int index) {
        String vertexProgram = null;
        String fragmentProgram = null;
        try {
            switch (index) {
                case 1: {
                    vertexProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/dimple.vert"));
                    fragmentProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/dimple.frag"));
                    break;
                }
                case 2: {
                    vertexProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/aabrick.vert"));
                    fragmentProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/aabrick.frag"));
                    break;
                }
                case 3: {
                    vertexProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/wood.vert"));
                    fragmentProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/wood.frag"));
                    break;
                }
                case 4: {
                    vertexProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/polkadot3d.vert"));
                    fragmentProgram = StringIO.readFully((URL)Resources.getResource("glsl_shader/polkadot3d.frag"));
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Shader[] shaders = new Shader[]{new SourceCodeShader(1, 1, vertexProgram), new SourceCodeShader(1, 2, fragmentProgram)};
        GLSLShaderProgram shaderProgram = new GLSLShaderProgram();
        shaderProgram.setShaders(shaders);
        return shaderProgram;
    }

    private ShaderAttributeSet createShaderAttributeSet(int index) {
        ShaderAttributeSet shaderAttributeSet = new ShaderAttributeSet();
        ShaderAttributeValue shaderAttribute = null;
        switch (index) {
            case 1: {
                shaderAttribute = new ShaderAttributeValue("Size", (Object)new Float(0.25));
                shaderAttributeSet.put((ShaderAttribute)shaderAttribute);
                shaderAttribute = new ShaderAttributeValue("LightPosition", (Object)new Point3f(0.0f, 0.0f, 0.5f));
                shaderAttributeSet.put((ShaderAttribute)shaderAttribute);
                this.sao1 = new ShaderAttributeValue("Density", (Object)new Float(this.density));
                this.sao1.setCapability(0);
                this.sao1.setCapability(1);
                shaderAttributeSet.put((ShaderAttribute)this.sao1);
                if (this.color == 1) {
                    this.sao2 = new ShaderAttributeValue("Color", (Object)this.gold);
                } else if (this.color == 2) {
                    this.sao2 = new ShaderAttributeValue("Color", (Object)this.silver);
                }
                this.sao2.setCapability(0);
                this.sao2.setCapability(1);
                shaderAttributeSet.put((ShaderAttribute)this.sao2);
                break;
            }
            case 2: {
                shaderAttribute = new ShaderAttributeValue("BrickColor", (Object)new Color3f(1.0f, 0.3f, 0.2f));
                shaderAttributeSet.put((ShaderAttribute)shaderAttribute);
                shaderAttribute = new ShaderAttributeValue("LightPosition", (Object)new Point3f(0.0f, 0.0f, 0.5f));
                shaderAttributeSet.put((ShaderAttribute)shaderAttribute);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return shaderAttributeSet;
    }

    private ShaderAppearance createShaderAppearance() {
        ShaderAppearance sApp = new ShaderAppearance();
        sApp.setMaterial(this.createMaterial());
        return sApp;
    }

    private BranchGroup createSubSceneGraph() {
        BranchGroup subRoot = new BranchGroup();
        this.sApp1 = this.createShaderAppearance();
        this.sApp1.setCapability(22);
        this.sApp1.setCapability(23);
        this.sApp1.setCapability(24);
        this.sApp1.setCapability(25);
        this.sp1 = this.createGLSLShaderProgram(1);
        this.sp1.setShaderAttrNames(shaderAttrNames1);
        this.sas1 = this.createShaderAttributeSet(1);
        this.sas1.setCapability(0);
        this.sas1.setCapability(1);
        this.sApp1.setShaderProgram(this.sp1);
        this.sApp1.setShaderAttributeSet(this.sas1);
        this.sp2 = this.createGLSLShaderProgram(2);
        this.sp2.setShaderAttrNames(shaderAttrNames2);
        this.sas2 = this.createShaderAttributeSet(2);
        this.sApp2 = this.createShaderAppearance();
        this.sApp2.setShaderProgram(this.sp2);
        this.sApp2.setShaderAttributeSet(this.sas2);
        this.sp3 = this.createGLSLShaderProgram(3);
        this.sApp3 = this.createShaderAppearance();
        this.sApp3.setShaderProgram(this.sp3);
        this.sp4 = this.createGLSLShaderProgram(4);
        this.sApp4 = this.createShaderAppearance();
        this.sApp4.setShaderProgram(this.sp4);
        this.sphere = new Sphere(1.5f, 1, 200, null);
        this.s3d = this.sphere.getShape();
        this.s3d.setCapability(14);
        this.s3d.setCapability(15);
        this.s3d.setAppearance((Appearance)this.sApp1);
        Transform3D t = new Transform3D();
        t.set(new Vector3d(0.0, 0.0, 0.0));
        TransformGroup objTG = new TransformGroup(t);
        objTG.addChild((Node)this.sphere);
        subRoot.addChild((Node)objTG);
        return subRoot;
    }

    private BranchGroup createSceneGraph(int selectedScene) {
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(17);
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Background bg = new Background(this.bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objScale.addChild((Node)bg);
        objScale.addChild((Node)this.createSubSceneGraph());
        TransformGroup vpTrans = this.univ.getViewingPlatform().getViewPlatformTransform();
        Transform3D axisOfTranslation = new Transform3D();
        Alpha transAlpha = new Alpha(-1, 3, 0L, 0L, 5000L, 0L, 0L, 5000L, 0L, 0L);
        axisOfTranslation.rotY(-1.5707963267948966);
        PositionInterpolator translator = new PositionInterpolator(transAlpha, vpTrans, axisOfTranslation, 2.0f, 3.5f);
        translator.setSchedulingBounds((Bounds)bounds);
        objScale.addChild((Node)translator);
        objRoot.compile();
        return objRoot;
    }

    private Canvas3D initScene() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.addShaderErrorListener(new ShaderErrorListener(){

            public void errorOccurred(ShaderError error) {
                error.printVerbose();
                JOptionPane.showMessageDialog(ShaderTestGLSL.this, error.toString(), "ShaderError", 0);
            }
        });
        ViewingPlatform viewingPlatform = this.univ.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        this.view = this.univ.getViewer().getView();
        return c;
    }

    public ShaderTestGLSL() {
        this.initComponents();
        Canvas3D c = this.initScene();
        this.drawingPanel.add((Component)c, "Center");
    }

    private void initComponents() {
        this.densityButtonGroup = new ButtonGroup();
        this.colorButtonGroup = new ButtonGroup();
        this.sceneGraphButtonGroup = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.guiPanel = new JPanel();
        this.densityPanel = new JPanel();
        this.zeroButton = new JRadioButton();
        this.halfButton = new JRadioButton();
        this.fullButton = new JRadioButton();
        this.colorPanel = new JPanel();
        this.goldButton = new JRadioButton();
        this.silverButton = new JRadioButton();
        this.sceneGraphPanel = new JPanel();
        this.DetachButton = new JToggleButton();
        this.AttachButton = new JToggleButton();
        this.replaceSPButton = new JButton();
        this.drawingPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.setTitle("Window Title");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ShaderTestGLSL.this.exitForm(evt);
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.guiPanel.setLayout(new BoxLayout(this.guiPanel, 0));
        this.guiPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.densityPanel.setLayout(new GridBagLayout());
        this.densityPanel.setBorder(new TitledBorder("Density"));
        this.densityButtonGroup.add(this.zeroButton);
        this.zeroButton.setText("Zero");
        this.zeroButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.zeroButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.densityPanel.add((Component)this.zeroButton, gridBagConstraints);
        this.densityButtonGroup.add(this.halfButton);
        this.halfButton.setText("Half");
        this.halfButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.halfButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.densityPanel.add((Component)this.halfButton, gridBagConstraints);
        this.densityButtonGroup.add(this.fullButton);
        this.fullButton.setSelected(true);
        this.fullButton.setText("Full");
        this.fullButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.fullButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.densityPanel.add((Component)this.fullButton, gridBagConstraints);
        this.guiPanel.add(this.densityPanel);
        this.densityPanel.getAccessibleContext().setAccessibleName("ShaderAttributeValue \n");
        this.colorPanel.setLayout(new GridBagLayout());
        this.colorPanel.setBorder(new TitledBorder("Color"));
        this.colorButtonGroup.add(this.goldButton);
        this.goldButton.setSelected(true);
        this.goldButton.setText("Gold");
        this.goldButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.goldButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.colorPanel.add((Component)this.goldButton, gridBagConstraints);
        this.colorButtonGroup.add(this.silverButton);
        this.silverButton.setText("Silver");
        this.silverButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.silverButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.colorPanel.add((Component)this.silverButton, gridBagConstraints);
        this.guiPanel.add(this.colorPanel);
        this.sceneGraphPanel.setLayout(new GridBagLayout());
        this.sceneGraphPanel.setBorder(new TitledBorder("Scene Graph"));
        this.sceneGraphButtonGroup.add(this.DetachButton);
        this.DetachButton.setSelected(true);
        this.DetachButton.setText("Detach");
        this.DetachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.DetachButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.sceneGraphPanel.add((Component)this.DetachButton, gridBagConstraints);
        this.sceneGraphButtonGroup.add(this.AttachButton);
        this.AttachButton.setText("Create");
        this.AttachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.AttachButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.sceneGraphPanel.add((Component)this.AttachButton, gridBagConstraints);
        this.replaceSPButton.setText("Replace Shader");
        this.replaceSPButton.setEnabled(false);
        this.replaceSPButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.replaceSPButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.sceneGraphPanel.add((Component)this.replaceSPButton, gridBagConstraints);
        this.guiPanel.add(this.sceneGraphPanel);
        this.mainPanel.add((Component)this.guiPanel, "North");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.mainPanel.add((Component)this.drawingPanel, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.fileMenu.setText("File");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ShaderTestGLSL.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void silverButtonActionPerformed(ActionEvent evt) {
        this.color = 2;
        if (this.scene != null) {
            this.sao2.setValue((Object)this.silver);
        }
    }

    private void goldButtonActionPerformed(ActionEvent evt) {
        this.color = 1;
        if (this.scene != null) {
            this.sao2.setValue((Object)this.gold);
        }
    }

    private void replaceSPButtonActionPerformed(ActionEvent evt) {
        if (this.shaderSelected != 1) {
            this.goldButton.setEnabled(false);
            this.silverButton.setEnabled(false);
            this.zeroButton.setEnabled(false);
            this.halfButton.setEnabled(false);
            this.fullButton.setEnabled(false);
        }
        switch (this.shaderSelected) {
            case 1: {
                this.s3d.setAppearance((Appearance)this.sApp1);
                this.goldButton.setEnabled(true);
                this.silverButton.setEnabled(true);
                this.zeroButton.setEnabled(true);
                this.halfButton.setEnabled(true);
                this.fullButton.setEnabled(true);
                this.shaderSelected = 2;
                break;
            }
            case 2: {
                this.s3d.setAppearance((Appearance)this.sApp2);
                this.shaderSelected = 3;
                break;
            }
            case 3: {
                this.s3d.setAppearance((Appearance)this.sApp3);
                this.shaderSelected = 4;
                break;
            }
            case 4: {
                this.s3d.setAppearance((Appearance)this.sApp4);
                this.shaderSelected = 1;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void fullButtonActionPerformed(ActionEvent evt) {
        this.density = 16.0f;
        if (this.scene != null) {
            this.sao1.setValue((Object)new Float(this.density));
        }
    }

    private void DetachButtonActionPerformed(ActionEvent evt) {
        if (this.scene != null) {
            this.scene.detach();
            this.scene = null;
            this.replaceSPButton.setEnabled(false);
            this.goldButton.setEnabled(true);
            this.silverButton.setEnabled(true);
            this.zeroButton.setEnabled(true);
            this.halfButton.setEnabled(true);
            this.fullButton.setEnabled(true);
            this.shaderSelected = 1;
        }
    }

    private void AttachButtonActionPerformed(ActionEvent evt) {
        if (this.scene == null) {
            this.scene = this.createSceneGraph(1);
            this.univ.addBranchGraph(this.scene);
            this.replaceSPButton.setEnabled(true);
            this.shaderSelected = 2;
        }
    }

    private void halfButtonActionPerformed(ActionEvent evt) {
        this.density = 8.0f;
        if (this.scene != null) {
            this.sao1.setValue((Object)new Float(this.density));
        }
    }

    private void zeroButtonActionPerformed(ActionEvent evt) {
        this.density = 0.0f;
        if (this.scene != null) {
            this.sao1.setValue((Object)new Float(this.density));
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new ShaderTestGLSL().setVisible(true);
    }
}

