/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.glsl_shader;

import com.sun.j3d.utils.shader.StringIO;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GLSLShaderProgram;
import javax.media.j3d.Geometry;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.Node;
import javax.media.j3d.Shader;
import javax.media.j3d.ShaderAppearance;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderErrorListener;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SourceCodeShader;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleArray;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.examples.Resources;

public class VertexAttrTestGLSL
extends JFrame {
    SimpleUniverse univ = null;
    BranchGroup scene = null;
    private JButton createButton;
    private JButton destroyButton;
    private JPanel drawingPanel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JPanel geometryPanel;
    private JPanel guiPanel;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel mainPanel;
    private JCheckBox vertexAttrsBox;
    private JPanel vertexCheckBoxPanel;

    public BranchGroup createSceneGraph(boolean hasVertexAttrs) {
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(17);
        Color3f bgColor = new Color3f(0.1f, 0.1f, 0.1f);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bg);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        objTrans.addChild((Node)new MyShape(this, hasVertexAttrs));
        return objRoot;
    }

    private Canvas3D initScene() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.addShaderErrorListener(new ShaderErrorListener(){

            public void errorOccurred(ShaderError error) {
                error.printVerbose();
                JOptionPane.showMessageDialog(VertexAttrTestGLSL.this, error.toString(), "ShaderError", 0);
            }
        });
        ViewingPlatform viewingPlatform = this.univ.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        return c;
    }

    public VertexAttrTestGLSL() {
        this.initComponents();
        Canvas3D c = this.initScene();
        this.drawingPanel.add((Component)c, "Center");
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.guiPanel = new JPanel();
        this.vertexCheckBoxPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.vertexAttrsBox = new JCheckBox();
        this.geometryPanel = new JPanel();
        this.createButton = new JButton();
        this.destroyButton = new JButton();
        this.drawingPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.setTitle("VertexAttrTestGLSL");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                VertexAttrTestGLSL.this.exitForm(evt);
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        this.guiPanel.setLayout(new GridBagLayout());
        this.guiPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.vertexCheckBoxPanel.setLayout(new GridBagLayout());
        this.vertexCheckBoxPanel.setBorder(BorderFactory.createTitledBorder(null, "vertexFormat", 0, 0, new Font("Lucida Sans", 0, 10)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jSeparator1.setPreferredSize(new Dimension(0, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jSeparator2.setPreferredSize(new Dimension(0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.vertexCheckBoxPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.vertexAttrsBox.setSelected(true);
        this.vertexAttrsBox.setText("VertexAttrs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.vertexAttrsBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.vertexCheckBoxPanel.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.guiPanel.add((Component)this.vertexCheckBoxPanel, gridBagConstraints);
        this.geometryPanel.setLayout(new GridBagLayout());
        this.createButton.setText("Create Geometry");
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VertexAttrTestGLSL.this.createButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.geometryPanel.add((Component)this.createButton, gridBagConstraints);
        this.destroyButton.setText("Destroy Geometry");
        this.destroyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VertexAttrTestGLSL.this.destroyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.geometryPanel.add((Component)this.destroyButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.guiPanel.add((Component)this.geometryPanel, gridBagConstraints);
        this.mainPanel.add((Component)this.guiPanel, "North");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.mainPanel.add((Component)this.drawingPanel, "Center");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.fileMenu.setText("File");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VertexAttrTestGLSL.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void destroyButtonActionPerformed(ActionEvent evt) {
        if (this.scene != null) {
            this.univ.getLocale().removeBranchGraph(this.scene);
            this.scene = null;
        }
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        if (this.scene == null) {
            boolean hasVertexAttrs = this.vertexAttrsBox.isSelected();
            this.scene = this.createSceneGraph(hasVertexAttrs);
            this.univ.addBranchGraph(this.scene);
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new VertexAttrTestGLSL().setVisible(true);
            }
        });
    }

    static class MyShape
    extends Shape3D {
        private static String vertexProgName = "glsl_shader/vertexshader.vert";
        private static final float[] coords = new float[]{0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f};
        private static final int[] sizes = new int[]{1, 3};
        private static final float[] weights = new float[]{0.45f, 0.15f, 0.95f};
        private static final float[] temps = new float[]{1.0f, 0.5f, 0.5f, 0.5f, 1.0f, 0.5f, 0.5f, 0.5f, 1.0f};
        private static final String[] vaNames = new String[]{"weight", "temperature"};

        J3DBuffer createDirectFloatBuffer(float[] arr) {
            ByteOrder order = ByteOrder.nativeOrder();
            FloatBuffer nioBuf = ByteBuffer.allocateDirect(arr.length * 4).order(order).asFloatBuffer();
            nioBuf.put(arr);
            return new J3DBuffer((Buffer)nioBuf);
        }

        MyShape(JFrame frame, boolean hasVertexAttrs) {
            int vertexFormat = 1;
            int vertexAttrCount = 0;
            int[] vertexAttrSizes = null;
            String[] vertexAttrNames = null;
            String[] shaderAttrNames = null;
            if (hasVertexAttrs) {
                vertexFormat |= 0x1000;
                vertexAttrCount = vaNames.length;
                vertexAttrSizes = sizes;
                vertexAttrNames = vaNames;
            }
            TriangleArray tri = new TriangleArray(6, vertexFormat, 0, null, vertexAttrCount, vertexAttrSizes);
            tri.setValidVertexCount(3);
            tri.setCoordinates(0, coords);
            if (hasVertexAttrs) {
                tri.setVertexAttrs(0, 0, weights);
                tri.setVertexAttrs(1, 0, temps);
                String vertexProgram = null;
                try {
                    vertexProgram = StringIO.readFully((URL)Resources.getResource(vertexProgName));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Shader[] shaders = new Shader[]{new SourceCodeShader(1, 1, vertexProgram)};
                GLSLShaderProgram shaderProgram = new GLSLShaderProgram();
                shaderProgram.setShaders(shaders);
                shaderProgram.setVertexAttrNames(vertexAttrNames);
                shaderProgram.setShaderAttrNames(shaderAttrNames);
                ShaderAppearance app = new ShaderAppearance();
                app.setShaderProgram((ShaderProgram)shaderProgram);
                this.setGeometry((Geometry)tri);
                this.setAppearance((Appearance)app);
            } else {
                this.setGeometry((Geometry)tri);
                this.setAppearance(new Appearance());
            }
        }
    }
}

