/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.lightwave;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.lw3d.Lw3dLoader;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Matrix4d;

public class Viewer
extends Applet {
    private URL filename;
    private SimpleUniverse u;

    public Viewer(URL url) {
        this.filename = url;
    }

    public Viewer() {
    }

    public void init() {
        if (this.filename == null) {
            try {
                URL path = this.getCodeBase();
                this.filename = new URL(path.toString() + "./ballcone.lws");
            }
            catch (MalformedURLException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                System.exit(1);
            }
        }
        Lw3dLoader lw3dLoader = new Lw3dLoader(-1);
        Scene loaderScene = null;
        try {
            loaderScene = lw3dLoader.load(this.filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        this.u = new SimpleUniverse(c);
        BranchGroup sceneRoot = new BranchGroup();
        View theView = this.u.getViewer().getView();
        theView.setBackClipDistance(50000.0);
        if (loaderScene.getSceneGroup() != null) {
            TransformGroup[] viewGroups = loaderScene.getViewGroups();
            Transform3D t = new Transform3D();
            viewGroups[0].getTransform(t);
            Matrix4d m = new Matrix4d();
            t.get(m);
            m.invert();
            t.set(m);
            TransformGroup sceneTransform = new TransformGroup(t);
            sceneTransform.addChild((Node)loaderScene.getSceneGroup());
            sceneRoot.addChild((Node)sceneTransform);
        }
        this.u.addBranchGraph(sceneRoot);
    }

    public void destroy() {
        this.u.cleanup();
    }

    private static void usage() {
        System.out.println("Usage: java Viewer <.lws>");
        System.exit(0);
    }

    public static void main(String[] args) {
        URL url;
        block6: {
            url = null;
            Object pathUrl = null;
            if (args.length > 0) {
                try {
                    if (args[0].indexOf("file:") == 0 || args[0].indexOf("http") == 0) {
                        url = new URL(args[0]);
                        break block6;
                    }
                    if (args[0].charAt(0) != '/') {
                        url = new URL("file:./" + args[0]);
                        break block6;
                    }
                    url = new URL("file:" + args[0]);
                }
                catch (MalformedURLException ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                    System.exit(1);
                }
            } else {
                Viewer.usage();
            }
        }
        new MainFrame((Applet)new Viewer(url), 500, 500);
    }
}

