/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.morphing;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.morphing.MorphingBehavior;

public class Morphing
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private URL[] objFiles = new URL[3];
    private JPanel drawingPanel;

    private BranchGroup createSceneGraph() {
        int i;
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objScale.addChild((Node)bg);
        Color3f lColor1 = new Color3f(0.7f, 0.7f, 0.7f);
        Vector3f lDir1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        Color3f alColor = new Color3f(0.2f, 0.2f, 0.2f);
        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds((Bounds)bounds);
        DirectionalLight lgt1 = new DirectionalLight(lColor1, lDir1);
        lgt1.setInfluencingBounds((Bounds)bounds);
        objScale.addChild((Node)aLgt);
        objScale.addChild((Node)lgt1);
        TransformGroup[] objTrans = new TransformGroup[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            objTrans[i2] = new TransformGroup();
            objScale.addChild((Node)objTrans[i2]);
        }
        Transform3D tr = new Transform3D();
        Transform3D rotX90 = new Transform3D();
        rotX90.rotX(1.5707963267948966);
        objTrans[0].getTransform(tr);
        tr.setTranslation(new Vector3d(-2.0, 1.5, -2.0));
        tr.mul(rotX90);
        objTrans[0].setTransform(tr);
        objTrans[1].getTransform(tr);
        tr.setTranslation(new Vector3d(0.0, 1.5, -2.0));
        tr.mul(rotX90);
        objTrans[1].setTransform(tr);
        objTrans[2].getTransform(tr);
        tr.setTranslation(new Vector3d(2.0, 1.5, -2.0));
        tr.mul(rotX90);
        objTrans[2].setTransform(tr);
        objTrans[3].getTransform(tr);
        tr.setTranslation(new Vector3d(0.0, -2.0, -2.0));
        tr.mul(rotX90);
        objTrans[3].setTransform(tr);
        Scene[] s = new Scene[3];
        GeometryArray[] g = new GeometryArray[3];
        Shape3D[] shape = new Shape3D[3];
        ObjectFile loader = new ObjectFile(64);
        for (i = 0; i < 3; ++i) {
            s[i] = null;
            g[i] = null;
            shape[i] = null;
        }
        for (i = 0; i < 3; ++i) {
            try {
                s[i] = loader.load(this.objFiles[i]);
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
                System.exit(1);
            }
            catch (ParsingErrorException e) {
                System.err.println((Object)e);
                System.exit(1);
            }
            catch (IncorrectFormatException e) {
                System.err.println((Object)e);
                System.exit(1);
            }
            BranchGroup b = s[i].getSceneGroup();
            shape[i] = (Shape3D)b.getChild(0);
            g[i] = (GeometryArray)shape[i].getGeometry();
            shape[i].setGeometry((Geometry)g[i]);
            objTrans[i].addChild((Node)b);
        }
        Appearance app = new Appearance();
        Color3f objColor = new Color3f(1.0f, 0.7f, 0.8f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        app.setMaterial(new Material(objColor, black, objColor, black, 80.0f));
        Morph morph = new Morph(g, app);
        morph.setCapability(16);
        morph.setCapability(17);
        objTrans[3].addChild((Node)morph);
        Alpha morphAlpha = new Alpha(-1, 3, 0L, 0L, 2000L, 1000L, 200L, 2000L, 1000L, 200L);
        MorphingBehavior mBeh = new MorphingBehavior(morphAlpha, morph);
        mBeh.setSchedulingBounds((Bounds)bounds);
        objScale.addChild((Node)mBeh);
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public Morphing(String[] args) {
        for (int i = 0; i < 3; ++i) {
            this.objFiles[i] = Resources.getResource("resources/geometry/hand" + (i + 1) + ".obj");
            if (this.objFiles[i] != null) continue;
            System.err.println("resources/geometry/hand" + (i + 1) + ".obj not found");
            System.exit(1);
        }
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Morphing");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Morphing morphing = new Morphing(args);
                morphing.setVisible(true);
            }
        });
    }
}

