/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.morphing;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.examples.morphing.ColorCube;
import org.jdesktop.j3d.examples.morphing.ColorPyramidDown;
import org.jdesktop.j3d.examples.morphing.ColorPyramidUp;
import org.jdesktop.j3d.examples.morphing.MorphingBehavior;

public class Pyramid2Cube
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private JPanel drawingPanel;

    private BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.2f);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)bounds);
        objScale.addChild((Node)bg);
        TransformGroup[] objTrans = new TransformGroup[4];
        for (int i = 0; i < 4; ++i) {
            objTrans[i] = new TransformGroup();
            objScale.addChild((Node)objTrans[i]);
        }
        Transform3D tr = new Transform3D();
        Transform3D rotY15 = new Transform3D();
        rotY15.rotY(0.2617993877991494);
        objTrans[0].getTransform(tr);
        tr.setTranslation(new Vector3d(-3.0, 1.5, -6.5));
        tr.mul(rotY15);
        objTrans[0].setTransform(tr);
        objTrans[1].getTransform(tr);
        tr.setTranslation(new Vector3d(0.0, 1.5, -6.5));
        tr.mul(rotY15);
        objTrans[1].setTransform(tr);
        objTrans[2].getTransform(tr);
        tr.setTranslation(new Vector3d(3.0, 1.5, -6.5));
        tr.mul(rotY15);
        objTrans[2].setTransform(tr);
        objTrans[3].getTransform(tr);
        tr.setTranslation(new Vector3d(0.0, -2.0, -5.0));
        tr.mul(rotY15);
        objTrans[3].setTransform(tr);
        QuadArray[] g = new QuadArray[3];
        Shape3D[] shape = new Shape3D[3];
        for (int i = 0; i < 3; ++i) {
            g[i] = null;
            shape[i] = null;
        }
        g[0] = new ColorPyramidUp();
        g[1] = new ColorCube();
        g[2] = new ColorPyramidDown();
        Appearance a = new Appearance();
        for (int i = 0; i < 3; ++i) {
            shape[i] = new Shape3D((Geometry)g[i], a);
            objTrans[i].addChild((Node)shape[i]);
        }
        Morph morph = new Morph((GeometryArray[])g, a);
        morph.setCapability(16);
        morph.setCapability(17);
        objTrans[3].addChild((Node)morph);
        Alpha morphAlpha = new Alpha(-1, 3, 0L, 0L, 4000L, 1000L, 500L, 4000L, 1000L, 500L);
        MorphingBehavior mBeh = new MorphingBehavior(morphAlpha, morph);
        mBeh.setSchedulingBounds((Bounds)bounds);
        objScale.addChild((Node)mBeh);
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public Pyramid2Cube() {
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Pyramid2Cube");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(700, 700));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Pyramid2Cube().setVisible(true);
            }
        });
    }
}

