/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.offscreen_canvas3d;

import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;

class OffScreenCanvas3D
extends Canvas3D {
    Raster drawRaster;
    boolean printing = false;

    public OffScreenCanvas3D(GraphicsConfiguration gconfig, boolean offscreenflag, Raster drawRaster) {
        super(gconfig, offscreenflag);
        this.drawRaster = drawRaster;
    }

    public void print(boolean toWait) {
        if (!toWait) {
            this.printing = true;
        }
        BufferedImage bImage = new BufferedImage(200, 200, 2);
        ImageComponent2D buffer = new ImageComponent2D(2, bImage, true, true);
        buffer.setCapability(2);
        this.setOffScreenBuffer(buffer);
        this.renderOffScreenBuffer();
        if (toWait) {
            this.waitForOffScreenRendering();
            this.drawOffScreenBuffer();
        }
    }

    public void postSwap() {
        if (this.printing) {
            super.postSwap();
            this.drawOffScreenBuffer();
            this.printing = false;
        }
    }

    void drawOffScreenBuffer() {
        BufferedImage bImage = this.getOffScreenBuffer().getImage();
        ImageComponent2D newImageComponent = new ImageComponent2D(2, bImage, true, true);
        this.drawRaster.setImage(newImageComponent);
    }
}

