/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.oriented_shape3d;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class MouseRotateY
extends MouseBehavior {
    double y_angle;
    double y_factor;

    public MouseRotateY(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MouseRotateY() {
        super(0);
    }

    public MouseRotateY(int flags) {
        super(flags);
    }

    public void initialize() {
        super.initialize();
        this.y_angle = 0.0;
        this.y_factor = 0.03;
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.y_factor *= -1.0;
        }
    }

    public double getYFactor() {
        return this.y_factor;
    }

    public void setFactor(double factor) {
        this.y_factor = factor;
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                this.processMouseEvent((MouseEvent)event[i]);
                if ((!this.buttonPress || (this.flags & 1) != 0) && (!this.wakeUp || (this.flags & 1) == 0)) continue;
                int id = event[i].getID();
                if (id == 506 && !((MouseEvent)event[i]).isMetaDown() && !((MouseEvent)event[i]).isAltDown()) {
                    this.x = ((MouseEvent)event[i]).getX();
                    int dx = this.x - this.x_last;
                    if (!this.reset) {
                        this.y_angle = (double)dx * this.y_factor;
                        this.transformY.rotY(this.y_angle);
                        this.transformGroup.getTransform(this.currXform);
                        Matrix4d mat = new Matrix4d();
                        this.currXform.get(mat);
                        this.currXform.setTranslation(new Vector3d(0.0, 0.0, 0.0));
                        if (this.invert) {
                            this.currXform.mul(this.currXform, this.transformX);
                            this.currXform.mul(this.currXform, this.transformY);
                        } else {
                            this.currXform.mul(this.transformX, this.currXform);
                            this.currXform.mul(this.transformY, this.currXform);
                        }
                        Vector3d translation = new Vector3d(mat.m03, mat.m13, mat.m23);
                        this.currXform.setTranslation(translation);
                        this.transformGroup.setTransform(this.currXform);
                    } else {
                        this.reset = false;
                    }
                    this.x_last = this.x;
                    continue;
                }
                if (id != 501) continue;
                this.x_last = ((MouseEvent)event[i]).getX();
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }
}

