/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.picking;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.pickfast.PickCanvas;
import com.sun.j3d.utils.pickfast.PickIntersection;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class IntersectInfoBehavior
extends Behavior {
    float size;
    PickCanvas pickCanvas;
    PickInfo[] pickInfoArr;
    Appearance oldlook;
    Appearance redlookwf;
    Appearance redlook;
    Appearance greenlook;
    Appearance bluelook;
    Node oldNode = null;
    GeometryArray oldGeom = null;
    Color3f redColor = new Color3f(1.0f, 0.0f, 0.0f);
    TransformGroup[] sphTrans = new TransformGroup[6];
    Sphere[] sph = new Sphere[6];
    Transform3D spht3 = new Transform3D();

    public IntersectInfoBehavior(Canvas3D canvas3D, BranchGroup branchGroup, float size) {
        this.pickCanvas = new PickCanvas(canvas3D, branchGroup);
        this.pickCanvas.setTolerance(5.0f);
        this.pickCanvas.setMode(2);
        this.pickCanvas.setFlags(36);
        this.size = size;
        this.redlook = new Appearance();
        Color3f objColor = new Color3f(0.5f, 0.0f, 0.0f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        this.redlook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));
        this.redlook.setCapability(1);
        this.redlookwf = new Appearance();
        this.redlookwf.setMaterial(new Material(objColor, black, objColor, white, 50.0f));
        PolygonAttributes pa = new PolygonAttributes();
        pa.setPolygonMode(1);
        pa.setCullFace(0);
        this.redlookwf.setPolygonAttributes(pa);
        this.oldlook = new Appearance();
        objColor = new Color3f(1.0f, 1.0f, 1.0f);
        this.oldlook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));
        this.greenlook = new Appearance();
        objColor = new Color3f(0.0f, 0.8f, 0.0f);
        this.greenlook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));
        this.bluelook = new Appearance();
        objColor = new Color3f(0.0f, 0.0f, 0.8f);
        this.bluelook.setMaterial(new Material(objColor, black, objColor, white, 50.0f));
        for (int i = 0; i < 6; ++i) {
            switch (i) {
                case 0: {
                    this.sph[i] = new Sphere(size * 1.15f, this.redlook);
                    break;
                }
                case 1: {
                    this.sph[i] = new Sphere(size * 1.1f, this.greenlook);
                    break;
                }
                default: {
                    this.sph[i] = new Sphere(size, this.bluelook);
                }
            }
            this.sph[i].setPickable(false);
            this.sphTrans[i] = new TransformGroup();
            this.sphTrans[i].setCapability(17);
            this.sphTrans[i].setCapability(18);
            branchGroup.addChild((Node)this.sphTrans[i]);
            this.sphTrans[i].addChild((Node)this.sph[i]);
        }
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)new WakeupOnAWTEvent(501));
    }

    public void processStimulus(Enumeration criteria) {
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
            for (int i = 0; i < event.length; ++i) {
                int eventId = event[i].getID();
                if (eventId != 501) continue;
                int x = ((MouseEvent)event[i]).getX();
                int y = ((MouseEvent)event[i]).getY();
                this.pickCanvas.setShapeLocation(x, y);
                this.pickInfoArr = this.pickCanvas.pickAllSorted();
                if (this.pickInfoArr == null) continue;
                Transform3D l2vw = this.pickInfoArr[0].getLocalToVWorld();
                PickInfo.IntersectionInfo[] iInfoArr = this.pickInfoArr[0].getIntersectionInfos();
                PickIntersection pi = new PickIntersection(l2vw, iInfoArr[0]);
                GeometryArray curGeomArray = (GeometryArray)iInfoArr[0].getGeometry();
                Vector3d v = new Vector3d();
                Point3d intPt = pi.getPointCoordinatesVW();
                v.set((Tuple3d)intPt);
                this.spht3.setTranslation(v);
                this.sphTrans[0].setTransform(this.spht3);
                Point3d closestVert = pi.getClosestVertexCoordinatesVW();
                v.set((Tuple3d)closestVert);
                this.spht3.setTranslation(v);
                this.sphTrans[1].setTransform(this.spht3);
                Point3d[] ptw = pi.getPrimitiveCoordinatesVW();
                Point3d[] pt = pi.getPrimitiveCoordinates();
                int[] coordidx = pi.getPrimitiveCoordinateIndices();
                Point3d ptcoord = new Point3d();
                for (int k = 0; k < pt.length; ++k) {
                    v.set((Tuple3d)ptw[k]);
                    this.spht3.setTranslation(v);
                    this.sphTrans[k + 2].setTransform(this.spht3);
                }
                Color4f iColor4 = null;
                Color3f iColor = null;
                Vector3f iNormal = null;
                if (curGeomArray != null) {
                    int vf = curGeomArray.getVertexFormat();
                    if ((vf & 0xC) != 0 && null != (iColor4 = pi.getPointColor())) {
                        iColor = new Color3f(iColor4.x, iColor4.y, iColor4.z);
                        this.redlook.setMaterial(new Material(iColor, new Color3f(0.0f, 0.0f, 0.0f), iColor, new Color3f(1.0f, 1.0f, 1.0f), 50.0f));
                    }
                    if ((vf & 2) != 0 && null != (iNormal = pi.getPointNormal())) {
                        System.out.println("Interpolated normal: " + iNormal);
                    }
                }
                System.out.println("=============");
                System.out.println("Coordinates of intersection pt:" + intPt);
                System.out.println("Coordinates of vertices: ");
                for (int k = 0; k < pt.length; ++k) {
                    System.out.println(k + ":" + ptw[k].x + " " + ptw[k].y + " " + ptw[k].z);
                }
                System.out.println("Closest vertex: " + closestVert);
                if (iColor != null) {
                    System.out.println("Interpolated color: " + iColor);
                }
                if (iNormal == null) continue;
                System.out.println("Interpolated normal: " + iNormal);
            }
        }
        this.wakeupOn((WakeupCondition)new WakeupOnAWTEvent(501));
    }
}

