/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.picking;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.picking.IntersectInfoBehavior;
import org.jdesktop.j3d.examples.picking.RandomColorCube;
import org.jdesktop.j3d.examples.picking.RandomColorTetrahedron;

public class IntersectTest
extends Applet {
    BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)this.bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(4.0f, -7.0f, -12.0f);
        Color3f light2Color = new Color3f(0.3f, 0.3f, 0.4f);
        Vector3f light2Direction = new Vector3f(-6.0f, -2.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)this.bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)this.bounds);
        objRoot.addChild((Node)light2);
        Transform3D t3 = new Transform3D();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    t3.setTranslation(new Vector3d(-4.0 + (double)x * 4.0, -4.0 + (double)y * 4.0, -20.0 - (double)z * 4.0));
                    TransformGroup objTrans = new TransformGroup(t3);
                    objRoot.addChild((Node)objTrans);
                    Object geom = null;
                    geom = (x + y + z) % 2 == 0 ? new RandomColorCube() : new RandomColorTetrahedron();
                    Shape3D shape = new Shape3D((Geometry)geom);
                    objTrans.addChild((Node)shape);
                }
            }
        }
        Point3f[] verts = new Point3f[]{new Point3f(-2.0f, 0.0f, 0.0f), new Point3f(2.0f, 0.0f, 0.0f)};
        Color3f grey = new Color3f(0.7f, 0.7f, 0.7f);
        Color3f[] colors = new Color3f[]{grey, grey};
        for (int y = 0; y < 5; ++y) {
            for (int z = 0; z < 5; ++z) {
                t3.setTranslation(new Vector3d(7.0, -4.0 + (double)y * 2.0, -20.0 - (double)z * 2.0));
                TransformGroup objTrans = new TransformGroup(t3);
                objRoot.addChild((Node)objTrans);
                LineArray la = new LineArray(verts.length, 5);
                la.setCoordinates(0, verts);
                la.setColors(0, colors);
                Shape3D shape = new Shape3D();
                shape.setGeometry((Geometry)la);
                objTrans.addChild((Node)shape);
            }
        }
        for (double x = -2.0; x <= 2.0; x += 1.0) {
            for (double y = -2.0; y <= 2.0; y += 1.0) {
                for (double z = -2.0; z <= 2.0; z += 1.0) {
                    t3.setTranslation(new Vector3d(-10.0 + 2.0 * x, 0.0 + 2.0 * y, -20.0 + 2.0 * z));
                    TransformGroup objTrans = new TransformGroup(t3);
                    objRoot.addChild((Node)objTrans);
                    PointArray pa = new PointArray(1, 5);
                    pa.setCoordinate(0, new Point3d(0.0, 0.0, 0.0));
                    pa.setColor(0, grey);
                    Shape3D shape = new Shape3D();
                    shape.setGeometry((Geometry)pa);
                    objTrans.addChild((Node)shape);
                }
            }
        }
        return objRoot;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        IntersectInfoBehavior behavior = new IntersectInfoBehavior(c, scene, 0.05f);
        behavior.setSchedulingBounds((Bounds)this.bounds);
        scene.addChild((Node)behavior);
        TransformGroup vpTrans = this.u.getViewingPlatform().getViewPlatformTransform();
        KeyNavigatorBehavior keybehavior = new KeyNavigatorBehavior(vpTrans);
        keybehavior.setSchedulingBounds((Bounds)this.bounds);
        scene.addChild((Node)keybehavior);
        scene.setCapability(14);
        scene.compile();
        this.u.addBranchGraph(scene);
        View view = this.u.getViewer().getView();
        view.setBackClipDistance(100000.0);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        String s = "\n\nIntersectTest:\n-----------\n";
        s = s + "Pick with the mouse over the primitives\n";
        s = s + "- A sphere will be placed to indicate the picked point.\n";
        s = s + "If color information is available, the sphere will change color to reflect\n";
        s = s + "the interpolated color.\n";
        s = s + "- Other spheres will be placed to show the vertices of the selected polygon\n";
        s = s + "- Information will be displayed about the picking operation\n\n\n";
        System.out.println(s);
        new MainFrame((Applet)new IntersectTest(), 640, 640);
    }
}

