/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.picking;

import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.behaviors.PickMouseBehavior;
import javax.media.j3d.Appearance;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;

public class PickHighlightBehavior
extends PickMouseBehavior {
    Appearance savedAppearance = null;
    Shape3D oldShape = null;
    Appearance highlightAppearance;

    public PickHighlightBehavior(Canvas3D canvas, BranchGroup root, Bounds bounds) {
        super(canvas, root, bounds);
        this.setSchedulingBounds(bounds);
        root.addChild((Node)this);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f highlightColor = new Color3f(0.0f, 1.0f, 0.0f);
        Material highlightMaterial = new Material(highlightColor, black, highlightColor, white, 80.0f);
        this.highlightAppearance = new Appearance();
        this.highlightAppearance.setMaterial(new Material(highlightColor, black, highlightColor, white, 80.0f));
        this.pickCanvas.setMode(512);
    }

    public void updateScene(int xpos, int ypos) {
        PickResult pickResult = null;
        Shape3D shape = null;
        this.pickCanvas.setShapeLocation(xpos, ypos);
        pickResult = this.pickCanvas.pickClosest();
        if (pickResult != null) {
            shape = (Shape3D)pickResult.getNode(1);
        }
        if (this.oldShape != null) {
            this.oldShape.setAppearance(this.savedAppearance);
        }
        if (shape != null) {
            this.savedAppearance = shape.getAppearance();
            this.oldShape = shape;
            shape.setAppearance(this.highlightAppearance);
        }
    }
}

