/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.picking;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.pickfast.behaviors.PickRotateBehavior;
import com.sun.j3d.utils.pickfast.behaviors.PickTranslateBehavior;
import com.sun.j3d.utils.pickfast.behaviors.PickZoomBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.picking.ColorCube;
import org.jdesktop.j3d.examples.picking.ColorPyramidDown;
import org.jdesktop.j3d.examples.picking.ColorPyramidUp;
import org.jdesktop.j3d.examples.picking.CubeIQA;
import org.jdesktop.j3d.examples.picking.GullCG;
import org.jdesktop.j3d.examples.picking.IcosahedronITSA;
import org.jdesktop.j3d.examples.picking.IcosahedronTSA;
import org.jdesktop.j3d.examples.picking.MorphingBehavior;
import org.jdesktop.j3d.examples.picking.OctahedronITFA;
import org.jdesktop.j3d.examples.picking.OctahedronTFA;
import org.jdesktop.j3d.examples.picking.TetrahedronILA;
import org.jdesktop.j3d.examples.picking.TetrahedronILSA;
import org.jdesktop.j3d.examples.picking.TetrahedronIPA;
import org.jdesktop.j3d.examples.picking.TetrahedronITA;
import org.jdesktop.j3d.examples.picking.TetrahedronLA;
import org.jdesktop.j3d.examples.picking.TetrahedronLSA;
import org.jdesktop.j3d.examples.picking.TetrahedronPA;
import org.jdesktop.j3d.examples.picking.TetrahedronTA;

public class PickTest
extends Applet
implements ActionListener {
    private View view = null;
    private QuadArray[] geomMorph = new QuadArray[3];
    private Morph morph;
    private PickRotateBehavior behavior1;
    private PickZoomBehavior behavior2;
    private PickTranslateBehavior behavior3;
    private SimpleUniverse u = null;
    String pickModeString = new String("Pick Mode");
    String boundsString = new String("BOUNDS");
    String geometryString = new String("GEOMETRY");
    String toleranceString = new String("Pick Tolerance");
    String tolerance0String = new String("0");
    String tolerance2String = new String("2");
    String tolerance4String = new String("4");
    String tolerance8String = new String("8");
    String viewModeString = new String("View Mode");
    String perspectiveString = new String("Perspective");
    String parallelString = new String("Parallel");

    public BranchGroup createSceneGraph(Canvas3D canvas) {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(1.0);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        int numRows = 4;
        int numCols = 4;
        for (int i = 0; i < numRows; ++i) {
            double ypos = (double)(i - numRows / 2) * 0.45 + 0.25;
            for (int j = 0; j < numCols; ++j) {
                double xpos = (double)(j - numCols / 2) * 0.45 + 0.25;
                objScale.addChild((Node)this.createObject(i * numCols + j, 0.1, xpos, ypos));
            }
        }
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f lColor = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f lDir = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight lgt = new DirectionalLight(lColor, lDir);
        lgt.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)lgt);
        Alpha morphAlpha = new Alpha(-1, 3, 0L, 0L, 4000L, 1000L, 500L, 4000L, 1000L, 500L);
        MorphingBehavior mBeh = new MorphingBehavior(morphAlpha, this.morph);
        mBeh.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)mBeh);
        this.behavior1 = new PickRotateBehavior(objRoot, canvas, (Bounds)bounds);
        objRoot.addChild((Node)this.behavior1);
        this.behavior2 = new PickZoomBehavior(objRoot, canvas, (Bounds)bounds);
        objRoot.addChild((Node)this.behavior2);
        this.behavior3 = new PickTranslateBehavior(objRoot, canvas, (Bounds)bounds);
        objRoot.addChild((Node)this.behavior3);
        objRoot.compile();
        return objRoot;
    }

    private Group createObject(int index, double scale, double xpos, double ypos) {
        Shape3D shape = null;
        Object geom = null;
        Transform3D t = new Transform3D();
        t.set(scale, new Vector3d(xpos, ypos, 0.0));
        TransformGroup objTrans = new TransformGroup(t);
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objTrans.setCapability(1);
        TransformGroup spinTg = new TransformGroup();
        spinTg.setCapability(18);
        spinTg.setCapability(17);
        spinTg.setCapability(1);
        Appearance appearance = new Appearance();
        switch (index) {
            case 0: {
                geom = new GullCG();
                break;
            }
            case 1: {
                geom = new TetrahedronTA();
                break;
            }
            case 2: {
                geom = new OctahedronTFA();
                break;
            }
            case 3: {
                geom = new IcosahedronTSA();
                break;
            }
            case 4: {
                geom = new CubeIQA();
                break;
            }
            case 5: {
                geom = new TetrahedronITA();
                break;
            }
            case 6: {
                geom = new OctahedronITFA();
                break;
            }
            case 7: {
                geom = new IcosahedronITSA();
                break;
            }
            case 8: {
                this.geomMorph[0] = new ColorPyramidUp();
                this.geomMorph[1] = new ColorCube();
                this.geomMorph[2] = new ColorPyramidDown();
                break;
            }
            case 9: {
                geom = new TetrahedronLA();
                break;
            }
            case 10: {
                geom = new TetrahedronILA();
                break;
            }
            case 11: {
                geom = new TetrahedronLSA();
                break;
            }
            case 12: {
                geom = new TetrahedronILSA();
                break;
            }
            case 13: {
                geom = new TetrahedronPA();
                break;
            }
            case 14: {
                geom = new TetrahedronIPA();
                break;
            }
            case 15: {
                geom = new TetrahedronTA();
            }
        }
        Material m = new Material();
        if (index == 8) {
            m.setLightingEnable(false);
            appearance.setMaterial(m);
            this.morph = new Morph((GeometryArray[])this.geomMorph, appearance);
            this.morph.setCapability(16);
            this.morph.setCapability(17);
            spinTg.addChild((Node)this.morph);
        } else {
            if (index == 0) {
                m.setLightingEnable(true);
            } else {
                m.setLightingEnable(false);
            }
            appearance.setMaterial(m);
            if (index == 13 || index == 14) {
                PointAttributes pa = new PointAttributes();
                pa.setPointSize(4.0f);
                appearance.setPointAttributes(pa);
            }
            shape = new Shape3D((Geometry)geom, appearance);
            shape.setCapability(14);
            shape.setCapability(15);
            shape.setCapability(1);
            spinTg.addChild((Node)shape);
        }
        objTrans.addChild((Node)spinTg);
        return objTrans;
    }

    private void setPickMode(int mode) {
        this.behavior1.setMode(mode);
        this.behavior2.setMode(mode);
        this.behavior3.setMode(mode);
    }

    private void setPickTolerance(float tolerance) {
        this.behavior1.setTolerance(tolerance);
        this.behavior2.setTolerance(tolerance);
        this.behavior3.setTolerance(tolerance);
    }

    private void setViewMode(int mode) {
        this.view.setProjectionPolicy(mode);
    }

    private void addRadioButton(JPanel panel, ButtonGroup bg, String ownerName, String buttonName, boolean selected) {
        JRadioButton item = new JRadioButton(buttonName);
        item.setName(ownerName);
        item.addActionListener(this);
        if (selected) {
            item.setSelected(true);
        }
        panel.add(item);
        bg.add(item);
    }

    private void setupGUI(JPanel panel) {
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new BevelBorder(0));
        panel.add(new JLabel(this.pickModeString));
        ButtonGroup bg = new ButtonGroup();
        this.addRadioButton(panel, bg, this.pickModeString, this.boundsString, true);
        this.addRadioButton(panel, bg, this.pickModeString, this.geometryString, false);
        panel.add(new JLabel(this.toleranceString));
        bg = new ButtonGroup();
        this.addRadioButton(panel, bg, this.toleranceString, this.tolerance0String, false);
        this.addRadioButton(panel, bg, this.toleranceString, this.tolerance2String, true);
        this.addRadioButton(panel, bg, this.toleranceString, this.tolerance4String, false);
        this.addRadioButton(panel, bg, this.toleranceString, this.tolerance8String, false);
        panel.add(new JLabel(this.viewModeString));
        bg = new ButtonGroup();
        this.addRadioButton(panel, bg, this.viewModeString, this.perspectiveString, true);
        this.addRadioButton(panel, bg, this.viewModeString, this.parallelString, false);
    }

    public void actionPerformed(ActionEvent e) {
        String name = ((Component)e.getSource()).getName();
        String value = e.getActionCommand();
        if (name == this.pickModeString) {
            if (value == this.boundsString) {
                this.setPickMode(1);
            } else if (value == this.geometryString) {
                this.setPickMode(2);
            } else {
                System.out.println("Unknown pick mode: " + value);
            }
        } else if (name == this.toleranceString) {
            if (value == this.tolerance0String) {
                this.setPickTolerance(0.0f);
            } else if (value == this.tolerance2String) {
                this.setPickTolerance(2.0f);
            } else if (value == this.tolerance4String) {
                this.setPickTolerance(4.0f);
            } else if (value == this.tolerance8String) {
                this.setPickTolerance(8.0f);
            } else {
                System.out.println("Unknown tolerance: " + value);
            }
        } else if (name == this.viewModeString) {
            if (value == this.perspectiveString) {
                this.setViewMode(1);
            } else if (value == this.parallelString) {
                this.setViewMode(0);
            }
        } else {
            System.out.println("Unknown action name: " + name);
        }
    }

    public void init() {
        this.setLayout(new BorderLayout());
        Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.add("Center", (Component)c);
        JPanel guiPanel = new JPanel();
        this.setupGUI(guiPanel);
        this.add((Component)guiPanel, "East");
        BranchGroup scene = this.createSceneGraph(c);
        this.u = new SimpleUniverse(c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.view = this.u.getViewer().getView();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] argv) {
        new MainFrame((Applet)new PickTest(), 750, 550);
    }
}

