/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.platform_geometry;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class SimpleGeometry
extends Applet {
    SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objScale.addChild((Node)objTrans);
        objTrans.addChild((Node)new ColorCube());
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        objRoot.compile();
        return objRoot;
    }

    PlatformGeometry createAimer() {
        PlatformGeometry pg = new PlatformGeometry();
        TransformGroup moveTG = new TransformGroup();
        moveTG.setCapability(17);
        moveTG.setCapability(18);
        MouseTranslate mouseT = new MouseTranslate(moveTG);
        moveTG.addChild((Node)mouseT);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        mouseT.setSchedulingBounds((Bounds)bounds);
        pg.addChild((Node)moveTG);
        Transform3D xForm = new Transform3D();
        xForm.rotX(1.5707963267948966);
        xForm.setTranslation(new Vector3d(0.0, 0.0, -0.7));
        TransformGroup placementTG = new TransformGroup(xForm);
        moveTG.addChild((Node)placementTG);
        Appearance cylinderAppearance = new Appearance();
        TransparencyAttributes transAttrs = new TransparencyAttributes(0, 0.5f);
        Cylinder aimer = new Cylinder(0.06f, 0.005f, 0, cylinderAppearance);
        placementTG.addChild((Node)aimer);
        return pg;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        BranchGroup scene = this.createSceneGraph();
        this.u = new SimpleUniverse(c);
        PlatformGeometry pg = this.createAimer();
        ViewingPlatform vp = this.u.getViewingPlatform();
        vp.setPlatformGeometry(pg);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public SimpleGeometry(String[] args) {
    }

    public SimpleGeometry() {
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new SimpleGeometry(args), 256, 256);
    }
}

