/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.print_canvas3d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.jdesktop.j3d.examples.print_canvas3d.ImagePrinter;

class ImageDisplayer
extends JFrame
implements ActionListener {
    BufferedImage bImage;
    private JMenuItem printItem;
    private JMenuItem closeItem;

    private void freeResources() {
        this.removeAll();
        this.setVisible(false);
        this.bImage = null;
    }

    public void actionPerformed(ActionEvent event) {
        Object target = event.getSource();
        if (target == this.printItem) {
            new ImagePrinter(this.bImage).print();
        } else if (target == this.closeItem) {
            this.freeResources();
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.printItem = new JMenuItem("Print...");
        this.printItem.addActionListener(this);
        this.closeItem = new JMenuItem("Close");
        this.closeItem.addActionListener(this);
        fileMenu.add(this.printItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(this.closeItem);
        menuBar.add(fileMenu);
        return menuBar;
    }

    ImageDisplayer(BufferedImage bImage) {
        this.bImage = bImage;
        this.setTitle("Off-screen Canvas3D Snapshot");
        this.setJMenuBar(this.createMenuBar());
        ImagePanel imagePanel = new ImagePanel();
        JScrollPane scrollPane = new JScrollPane(imagePanel);
        scrollPane.getViewport().setPreferredSize(new Dimension(700, 700));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent winEvent) {
                ImageDisplayer.this.freeResources();
            }
        });
        this.getContentPane().add(scrollPane);
        this.pack();
        this.setVisible(true);
    }

    private class ImagePanel
    extends JPanel {
        public void paint(Graphics g) {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.drawImage(ImageDisplayer.this.bImage, 0, 0, this);
        }

        private ImagePanel() {
            this.setPreferredSize(new Dimension(ImageDisplayer.this.bImage.getWidth(), ImageDisplayer.this.bImage.getHeight()));
        }
    }
}

