/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.print_canvas3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Node;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.print_canvas3d.ImageDisplayer;
import org.jdesktop.j3d.examples.print_canvas3d.ImagePrinter;
import org.jdesktop.j3d.examples.print_canvas3d.OffScreenCanvas3D;

public class PrintCanvas3D
extends JFrame {
    private static final boolean noTriangulate = false;
    private static final boolean noStripify = false;
    private static final double creaseAngle = 60.0;
    private Canvas3D onScreenCanvas3D;
    private OffScreenCanvas3D offScreenCanvas3D;
    private URL filename = null;
    private static final int OFF_SCREEN_SCALE = 3;
    private SimpleUniverse univ = null;
    private JPanel drawingPanel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private JMenuItem printMenuItem;
    private JMenuItem snapShotMenuItem;

    public BranchGroup createSceneGraph(String[] args) {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.7);
        objScale.setTransform(t3d);
        objRoot.addChild((Node)objScale);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objTrans.setCapability(17);
        objScale.addChild((Node)objTrans);
        int flags = 64;
        flags |= 0x80;
        ObjectFile f = new ObjectFile(flags |= 0x200, 1.0471976f);
        Scene scene = null;
        try {
            scene = f.load(this.filename);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (ParsingErrorException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        catch (IncorrectFormatException e) {
            System.err.println((Object)e);
            System.exit(1);
        }
        objTrans.addChild((Node)scene.getSceneGroup());
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        MouseRotate behavior = new MouseRotate();
        behavior.setTransformGroup(objTrans);
        objTrans.addChild((Node)behavior);
        behavior.setSchedulingBounds((Bounds)bounds);
        MouseZoom behavior2 = new MouseZoom();
        behavior2.setTransformGroup(objTrans);
        objTrans.addChild((Node)behavior2);
        behavior2.setSchedulingBounds((Bounds)bounds);
        MouseTranslate behavior3 = new MouseTranslate();
        behavior3.setTransformGroup(objTrans);
        objTrans.addChild((Node)behavior3);
        behavior3.setSchedulingBounds((Bounds)bounds);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bgNode);
        Color3f ambientColor = new Color3f(0.1f, 0.1f, 0.1f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(1.0f, 1.0f, 0.9f);
        Vector3f light1Direction = new Vector3f(4.0f, -7.0f, -12.0f);
        Color3f light2Color = new Color3f(0.3f, 0.3f, 0.4f);
        Vector3f light2Direction = new Vector3f(-6.0f, -2.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light2);
        return objRoot;
    }

    private void usage() {
        System.out.println("Usage: java PrintCanvas3D <.obj file>");
        System.exit(0);
    }

    private OffScreenCanvas3D createOffScreenCanvas(Canvas3D onScreenCanvas3D) {
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        template.setDoubleBuffer(3);
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template);
        this.offScreenCanvas3D = new OffScreenCanvas3D(gc, true);
        Screen3D sOn = onScreenCanvas3D.getScreen3D();
        Screen3D sOff = this.offScreenCanvas3D.getScreen3D();
        Dimension dim = sOn.getSize();
        dim.width *= 3;
        dim.height *= 3;
        sOff.setSize(dim);
        sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth() * 3.0);
        sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight() * 3.0);
        this.univ.getViewer().getView().addCanvas3D((Canvas3D)this.offScreenCanvas3D);
        return this.offScreenCanvas3D;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public PrintCanvas3D(String[] args) {
        if (args.length == 0) {
            this.filename = Resources.getResource("resources/geometry/beethoven.obj");
            if (this.filename == null) {
                System.err.println("resources/geometry/beethoven.obj not found");
                System.exit(1);
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    System.err.println("Argument '" + args[i] + "' ignored.");
                    continue;
                }
                try {
                    this.filename = new URL(args[i]);
                    continue;
                }
                catch (MalformedURLException e) {
                    System.err.println(e.getMessage());
                    System.exit(1);
                }
            }
        }
        if (this.filename == null) {
            this.usage();
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.initComponents();
        this.onScreenCanvas3D = this.createUniverse();
        this.drawingPanel.add((Component)this.onScreenCanvas3D, "Center");
        BranchGroup scene = this.createSceneGraph(args);
        this.createOffScreenCanvas(this.onScreenCanvas3D);
        this.univ.addBranchGraph(scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.snapShotMenuItem = new JMenuItem();
        this.printMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Window Title");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.fileMenu.setText("File");
        this.snapShotMenuItem.setText("Snapshot");
        this.snapShotMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintCanvas3D.this.snapShotMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.snapShotMenuItem);
        this.printMenuItem.setText("Print");
        this.printMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintCanvas3D.this.printMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.printMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PrintCanvas3D.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void printMenuItemActionPerformed(ActionEvent evt) {
        Point loc = this.onScreenCanvas3D.getLocationOnScreen();
        this.offScreenCanvas3D.setOffScreenLocation(loc);
        Dimension dim = this.onScreenCanvas3D.getSize();
        dim.width *= 3;
        dim.height *= 3;
        BufferedImage bImage = this.offScreenCanvas3D.doRender(dim.width, dim.height);
        new ImagePrinter(bImage).print();
    }

    private void snapShotMenuItemActionPerformed(ActionEvent evt) {
        Point loc = this.onScreenCanvas3D.getLocationOnScreen();
        this.offScreenCanvas3D.setOffScreenLocation(loc);
        Dimension dim = this.onScreenCanvas3D.getSize();
        dim.width *= 3;
        dim.height *= 3;
        BufferedImage bImage = this.offScreenCanvas3D.doRender(dim.width, dim.height);
        new ImageDisplayer(bImage);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PrintCanvas3D(args).setVisible(true);
            }
        });
    }
}

