/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.read_raster;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import javax.media.j3d.Alpha;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.Raster;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import org.jdesktop.j3d.examples.read_raster.myCanvas3D;
import org.jdesktop.j3d.examples.read_raster.myRotationInterpolator;

public class ReadRaster
extends Applet {
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph(BufferedImage bImage, Raster readRaster) {
        BranchGroup objRoot = new BranchGroup();
        ImageComponent2D drawImageComponent = new ImageComponent2D(1, bImage, true, true);
        Raster drawRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, bImage.getWidth(), bImage.getHeight(), drawImageComponent, null);
        Shape3D shape = new Shape3D((Geometry)drawRaster);
        drawRaster.setCapability(5);
        objRoot.addChild((Node)shape);
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        TransformGroup cubeScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setTranslation(new Vector3d(-0.5, 0.5, 0.0));
        cubeScale.setTransform(t3d);
        cubeScale.addChild((Node)objTrans);
        objRoot.addChild((Node)cubeScale);
        objTrans.addChild((Node)new ColorCube(0.3));
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        myRotationInterpolator rotator = new myRotationInterpolator(drawRaster, readRaster, rotationAlpha, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        objRoot.compile();
        return objRoot;
    }

    public void init() {
        int width = 128;
        int height = 128;
        ImageComponent2D readImageComponent = new ImageComponent2D(1, width, height, false, true);
        Raster readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, readImageComponent, null);
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        myCanvas3D c = new myCanvas3D(config, readRaster);
        this.add("Center", (Component)((Object)c));
        BufferedImage bImage = new BufferedImage(width, height, 1);
        BranchGroup scene = this.createSceneGraph(bImage, readRaster);
        this.u = new SimpleUniverse((Canvas3D)c);
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new ReadRaster(), 256, 256);
    }
}

