/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.sound;

import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.net.URL;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BackgroundSound;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Sound;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.sound.BackgroundSoundBehavior;

public class BackgroundSoundTest
extends JFrame {
    private URL url = null;
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private float activationRadius = 1.0f;
    private JPanel drawingPanel;

    private Shape3D getDefaultGrid(int noOfLines, double size, double height) {
        int i;
        Shape3D shape = new Shape3D();
        double lineLength = (double)noOfLines * size / 2.0;
        LineArray la = new LineArray(noOfLines * 4, 1);
        int count = 0;
        for (i = 0; i < noOfLines; ++i) {
            la.setCoordinate(count, new Point3d(-lineLength, height, (double)i * size - lineLength));
            la.setCoordinate(++count, new Point3d(lineLength, height, (double)i * size - lineLength));
            ++count;
        }
        for (i = 0; i < noOfLines; ++i) {
            la.setCoordinate(count, new Point3d((double)i * size - lineLength, height, -lineLength));
            la.setCoordinate(++count, new Point3d((double)i * size - lineLength, height, lineLength));
            ++count;
        }
        shape.setGeometry((Geometry)la);
        Appearance a = new Appearance();
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(0.3f, 0.3f, 0.3f);
        a.setColoringAttributes(ca);
        LineAttributes sla = new LineAttributes();
        sla.setLineWidth(1.0f);
        a.setLineAttributes(sla);
        shape.setAppearance(a);
        return shape;
    }

    private Sphere createSoundBoundingGeometry(Sound sound) {
        Bounds bounds = sound.getSchedulingBounds();
        assert (bounds != null && bounds instanceof BoundingSphere);
        BoundingSphere bs = (BoundingSphere)bounds;
        float radius = (float)bs.getRadius();
        return this.getSphere(radius);
    }

    private Sphere getSphere(float radius) {
        Appearance a = new Appearance();
        Material m = new Material();
        m.setDiffuseColor(1.0f, 0.0f, 0.0f);
        m.setAmbientColor(1.0f, 0.0f, 0.0f);
        m.setShininess(8.0f);
        a.setMaterial(m);
        PolygonAttributes pa = new PolygonAttributes();
        pa.setPolygonMode(1);
        pa.setCullFace(0);
        a.setPolygonAttributes(pa);
        return new Sphere(radius, a);
    }

    private TransformGroup createSoundNodeGeometry(float x, float y, float z) {
        TransformGroup rootTransformGroup = new TransformGroup();
        Transform3D t3D = new Transform3D();
        t3D.setTranslation(new Vector3f(x, y, z));
        rootTransformGroup.setTransform(t3D);
        ColorCube cc = new ColorCube(0.1);
        rootTransformGroup.addChild((Node)cc);
        return rootTransformGroup;
    }

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        AmbientLight al = new AmbientLight();
        al.setInfluencingBounds((Bounds)bounds);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(-1.0f, -1.0f, -1.0f);
        dl.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)al);
        objRoot.addChild((Node)dl);
        BackgroundSound bgs = new BackgroundSound();
        BackgroundSoundBehavior player = new BackgroundSoundBehavior(bgs, this.url);
        player.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)bgs);
        objRoot.addChild((Node)player);
        objRoot.addChild((Node)this.getDefaultGrid(40, 1.0, -1.0));
        objRoot.addChild((Node)this.createSoundNodeGeometry(0.0f, 0.0f, 0.0f));
        objRoot.addChild((Node)this.createSoundBoundingGeometry((Sound)bgs));
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        ViewingPlatform viewingPlatform = this.univ.getViewingPlatform();
        TransformGroup viewingPlatformTransformGroup = viewingPlatform.getViewPlatformTransform();
        viewingPlatform.setNominalViewingTransform();
        Viewer viewer = this.univ.getViewer();
        viewer.createAudioDevice();
        viewer.getView().setBackClipDistance(1000.0);
        viewer.getView().setMinimumFrameCycleTime(30L);
        viewer.getView().getViewPlatform().setActivationRadius(this.activationRadius);
        BranchGroup bg = new BranchGroup();
        KeyNavigatorBehavior knb = new KeyNavigatorBehavior((Component)c, viewingPlatformTransformGroup);
        BoundingSphere b = new BoundingSphere(new Point3d(), Double.POSITIVE_INFINITY);
        knb.setSchedulingBounds((Bounds)b);
        bg.addChild((Node)knb);
        this.univ.addBranchGraph(bg);
        return c;
    }

    public BackgroundSoundTest() {
        this.initComponents();
        this.url = Resources.getResource("resources/audio/magic_bells.wav");
        if (this.url == null) {
            System.err.println("resources/audio/magic_bells.wav not found");
            System.exit(1);
        }
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("BackgroundSoundTest");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new BackgroundSoundTest().setVisible(true);
            }
        });
    }
}

