/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.sound;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.net.URL;
import javax.media.j3d.Alpha;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PointSound;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Soundscape;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.examples.Resources;
import org.jdesktop.j3d.examples.sound.AudioReverberate;

public class ReverberateSound
extends Applet {
    private static URL url = null;
    private SimpleUniverse u = null;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTrans = new TransformGroup();
        objTrans.setCapability(18);
        objRoot.addChild((Node)objTrans);
        objTrans.addChild((Node)new ColorCube(0.4));
        Transform3D yAxis = new Transform3D();
        Alpha rotation = new Alpha(-1, 1, 0L, 0L, 20000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotation, objTrans, yAxis, 0.0f, (float)Math.PI * 2);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        rotator.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)rotator);
        Soundscape soundScape2 = new Soundscape();
        AuralAttributes attributes2 = new AuralAttributes();
        attributes2.setReverbOrder(6);
        attributes2.setCapability(9);
        attributes2.setCapability(7);
        attributes2.setCapability(5);
        soundScape2.setApplicationBounds((Bounds)bounds);
        soundScape2.setAuralAttributes(attributes2);
        objRoot.addChild((Node)soundScape2);
        PointSound sound = new PointSound();
        sound.setCapability(23);
        sound.setCapability(15);
        sound.setCapability(13);
        sound.setCapability(28);
        sound.setCapability(33);
        sound.setCapability(17);
        sound.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)sound);
        AudioReverberate player = new AudioReverberate(sound, url, attributes2);
        player.setSchedulingBounds((Bounds)bounds);
        objTrans.addChild((Node)player);
        return objRoot;
    }

    public void init() {
        url = Resources.getResource("resources/audio/hello_universe.au");
        if (url == null) {
            System.err.println("resources/audio/hello_universe.au not found");
            System.exit(1);
        }
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", (Component)c);
        this.u = new SimpleUniverse(c);
        AudioDevice audioDev = this.u.getViewer().createAudioDevice();
        BranchGroup scene = this.createSceneGraph();
        this.u.getViewingPlatform().setNominalViewingTransform();
        this.u.addBranchGraph(scene);
        JOptionPane.showMessageDialog(this, "This program is still a work in progress.\nPlease check back in Java 3D 1.5.\n", "Incomplete Work", 1);
    }

    public void destroy() {
        this.u.cleanup();
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new ReverberateSound(), 256, 256);
    }
}

