/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.spline_anim;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.KBRotPosScaleSplinePathInterpolator;
import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class SplineAnim
extends Applet
implements ActionListener,
AdjustmentListener,
ItemListener {
    Canvas3D canvas;
    Panel controlPanel;
    Panel canvasPanel;
    Button animateButton;
    Choice interpChoice;
    Scrollbar speedSlider;
    Label speedLabel;
    Label interpLabel;
    BoundingSphere bounds;
    BranchGroup root;
    BranchGroup behaviorBranch;
    Transform3D sceneTransform;
    TransformGroup sceneTransformGroup;
    Transform3D objTransform;
    TransformGroup objTransformGroup;
    Transform3D lightTransform1;
    Transform3D lightTransform2;
    TransformGroup light1TransformGroup;
    TransformGroup light2TransformGroup;
    int duration = 5000;
    Alpha animAlpha;
    Transform3D yAxis;
    KBKeyFrame[] linearKeyFrames = new KBKeyFrame[6];
    KBKeyFrame[] splineKeyFrames = new KBKeyFrame[6];
    KBRotPosScaleSplinePathInterpolator splineInterpolator;
    KBRotPosScaleSplinePathInterpolator linearInterpolator;
    Vector3f pos0 = new Vector3f(-5.0f, -5.0f, 0.0f);
    Vector3f pos1 = new Vector3f(-5.0f, 5.0f, 0.0f);
    Vector3f pos2 = new Vector3f(0.0f, 5.0f, 0.0f);
    Vector3f pos3 = new Vector3f(0.0f, -5.0f, 0.0f);
    Vector3f pos4 = new Vector3f(5.0f, -5.0f, 0.0f);
    Vector3f pos5 = new Vector3f(5.0f, 5.0f, 0.0f);
    TransformGroup k0TransformGroup;
    TransformGroup k1TransformGroup;
    TransformGroup k2TransformGroup;
    TransformGroup k3TransformGroup;
    TransformGroup k4TransformGroup;
    TransformGroup k5TransformGroup;
    boolean animationOn = true;
    boolean linear = false;
    private SimpleUniverse u = null;

    public void init() {
        this.setLayout(new FlowLayout());
        this.canvasPanel = new Panel();
        this.controlPanel = new Panel();
        this.createCanvasPanel(this.canvasPanel);
        this.add(this.canvasPanel);
        this.createControlPanel(this.controlPanel);
        this.add(this.controlPanel);
        BranchGroup scene = this.createSceneGraph();
        this.setupSplineKeyFrames();
        this.setupLinearKeyFrames();
        this.setupAnimationData();
        this.createInterpolators();
        this.startInterpolator();
        this.u = new SimpleUniverse(this.canvas);
        ViewingPlatform viewingPlatform = this.u.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        OrbitBehavior orbit = new OrbitBehavior(this.canvas, 112);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        orbit.setSchedulingBounds((Bounds)bounds);
        viewingPlatform.setViewPlatformBehavior((ViewPlatformBehavior)orbit);
        this.u.addBranchGraph(scene);
    }

    public void destroy() {
        this.u.cleanup();
    }

    private void createControlPanel(Panel p) {
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        p.setLayout(gl);
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        this.interpLabel = new Label("Interpolation Type", 0);
        p.add((Component)this.interpLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        this.interpChoice = new Choice();
        this.interpChoice.add("Spline");
        this.interpChoice.add("Linear");
        p.add((Component)this.interpChoice, gbc);
        this.interpChoice.addItemListener(this);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        this.speedSlider = new Scrollbar(0, 2, 1, 0, 11);
        this.speedSlider.setUnitIncrement(1);
        p.add((Component)this.speedSlider, gbc);
        this.speedSlider.addAdjustmentListener(this);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        this.speedLabel = new Label(" - Animation Speed +", 1);
        p.add((Component)this.speedLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        this.animateButton = new Button("Stop Animation");
        p.add((Component)this.animateButton, gbc);
        this.animateButton.addActionListener(this);
    }

    private void createCanvasPanel(Panel p) {
        GridBagLayout gl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        p.setLayout(gl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 5;
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.canvas = new Canvas3D(config);
        this.canvas.setSize(490, 490);
        p.add((Component)this.canvas, gbc);
    }

    public BranchGroup createSceneGraph() {
        Color3f aColor = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f eColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f sColor = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f coneColor = new Color3f(0.9f, 0.1f, 0.1f);
        Color3f sphereColor = new Color3f(0.1f, 0.7f, 0.9f);
        Color3f bgColor = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f lightColor = new Color3f(1.0f, 1.0f, 1.0f);
        BranchGroup root = new BranchGroup();
        this.sceneTransform = new Transform3D();
        this.sceneTransform.setScale((double)0.14f);
        Transform3D yrot = new Transform3D();
        yrot.rotY(-0.6283185307179586);
        this.sceneTransform.mul(yrot);
        this.sceneTransformGroup = new TransformGroup(this.sceneTransform);
        this.sceneTransformGroup.setCapability(18);
        this.sceneTransformGroup.setCapability(17);
        root.addChild((Node)this.sceneTransformGroup);
        this.bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds((Bounds)this.bounds);
        this.sceneTransformGroup.addChild((Node)bg);
        this.lightTransform1 = new Transform3D();
        this.lightTransform2 = new Transform3D();
        Vector3d lightPos1 = new Vector3d(0.0, 0.0, 2.0);
        Vector3d lightPos2 = new Vector3d(1.0, 0.0, -2.0);
        this.lightTransform1.set(lightPos1);
        this.lightTransform2.set(lightPos2);
        this.light1TransformGroup = new TransformGroup(this.lightTransform1);
        this.light2TransformGroup = new TransformGroup(this.lightTransform2);
        this.sceneTransformGroup.addChild((Node)this.light1TransformGroup);
        this.sceneTransformGroup.addChild((Node)this.light2TransformGroup);
        AmbientLight ambLight = new AmbientLight(aColor);
        Vector3f lightDir1 = new Vector3f(lightPos1);
        Vector3f lightDir2 = new Vector3f(lightPos2);
        lightDir1.negate();
        lightDir2.negate();
        DirectionalLight dirLight1 = new DirectionalLight(lightColor, lightDir1);
        DirectionalLight dirLight2 = new DirectionalLight(lightColor, lightDir2);
        ambLight.setInfluencingBounds((Bounds)this.bounds);
        dirLight1.setInfluencingBounds((Bounds)this.bounds);
        dirLight2.setInfluencingBounds((Bounds)this.bounds);
        this.sceneTransformGroup.addChild((Node)ambLight);
        this.sceneTransformGroup.addChild((Node)dirLight1);
        this.sceneTransformGroup.addChild((Node)dirLight2);
        this.objTransform = new Transform3D();
        this.objTransformGroup = new TransformGroup(this.objTransform);
        this.objTransformGroup.setCapability(18);
        this.sceneTransformGroup.addChild((Node)this.objTransformGroup);
        Material m = new Material(coneColor, eColor, coneColor, sColor, 100.0f);
        Appearance a = new Appearance();
        m.setLightingEnable(true);
        a.setMaterial(m);
        Cone cone = new Cone(0.4f, 1.0f);
        cone.setAppearance(a);
        this.objTransformGroup.addChild((Node)cone);
        Transform3D t3dKnot = new Transform3D();
        t3dKnot.set(this.pos0);
        TransformGroup k0TransformGroup = new TransformGroup(t3dKnot);
        this.sceneTransformGroup.addChild((Node)k0TransformGroup);
        t3dKnot = new Transform3D();
        t3dKnot.set(this.pos1);
        TransformGroup k1TransformGroup = new TransformGroup(t3dKnot);
        this.sceneTransformGroup.addChild((Node)k1TransformGroup);
        t3dKnot = new Transform3D();
        t3dKnot.set(this.pos2);
        TransformGroup k2TransformGroup = new TransformGroup(t3dKnot);
        this.sceneTransformGroup.addChild((Node)k2TransformGroup);
        t3dKnot = new Transform3D();
        t3dKnot.set(this.pos3);
        TransformGroup k3TransformGroup = new TransformGroup(t3dKnot);
        this.sceneTransformGroup.addChild((Node)k3TransformGroup);
        t3dKnot = new Transform3D();
        t3dKnot.set(this.pos4);
        TransformGroup k4TransformGroup = new TransformGroup(t3dKnot);
        this.sceneTransformGroup.addChild((Node)k4TransformGroup);
        t3dKnot = new Transform3D();
        t3dKnot.set(this.pos5);
        TransformGroup k5TransformGroup = new TransformGroup(t3dKnot);
        this.sceneTransformGroup.addChild((Node)k5TransformGroup);
        ColoringAttributes sphereColorAttr = new ColoringAttributes();
        sphereColorAttr.setColor(sphereColor);
        Appearance sphereAppearance = new Appearance();
        sphereAppearance.setColoringAttributes(sphereColorAttr);
        k0TransformGroup.addChild((Node)new Sphere(0.1f, sphereAppearance));
        k1TransformGroup.addChild((Node)new Sphere(0.1f, sphereAppearance));
        k2TransformGroup.addChild((Node)new Sphere(0.1f, sphereAppearance));
        k3TransformGroup.addChild((Node)new Sphere(0.1f, sphereAppearance));
        k4TransformGroup.addChild((Node)new Sphere(0.1f, sphereAppearance));
        k5TransformGroup.addChild((Node)new Sphere(0.1f, sphereAppearance));
        return root;
    }

    private void setupSplineKeyFrames() {
        Point3f p = new Point3f((Tuple3f)this.pos0);
        float head = 1.5707964f;
        float pitch = 0.0f;
        float bank = 0.0f;
        Point3f s = new Point3f(1.0f, 1.0f, 1.0f);
        this.splineKeyFrames[0] = new KBKeyFrame(0.0f, 0, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos1);
        head = 0.0f;
        pitch = 0.0f;
        bank = -1.5707964f;
        s = new Point3f(1.0f, 1.0f, 1.0f);
        this.splineKeyFrames[1] = new KBKeyFrame(0.2f, 0, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos2);
        head = 0.0f;
        pitch = 0.0f;
        bank = 0.0f;
        s = new Point3f(0.7f, 0.7f, 0.7f);
        this.splineKeyFrames[2] = new KBKeyFrame(0.4f, 0, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos3);
        head = 1.5707964f;
        pitch = 0.0f;
        bank = 1.5707964f;
        s = new Point3f(0.5f, 0.5f, 0.5f);
        this.splineKeyFrames[3] = new KBKeyFrame(0.6f, 0, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos4);
        head = -1.5707964f;
        pitch = -1.5707964f;
        bank = 1.5707964f;
        s = new Point3f(0.4f, 0.4f, 0.4f);
        this.splineKeyFrames[4] = new KBKeyFrame(0.8f, 0, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos5);
        head = 0.0f;
        pitch = 0.0f;
        bank = 0.0f;
        s = new Point3f(1.0f, 1.0f, 1.0f);
        this.splineKeyFrames[5] = new KBKeyFrame(1.0f, 0, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
    }

    private void setupLinearKeyFrames() {
        Point3f p = new Point3f((Tuple3f)this.pos0);
        float head = 0.0f;
        float pitch = 0.0f;
        float bank = 0.0f;
        Point3f s = new Point3f(1.0f, 1.0f, 1.0f);
        this.linearKeyFrames[0] = new KBKeyFrame(0.0f, 1, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos1);
        this.linearKeyFrames[1] = new KBKeyFrame(0.2f, 1, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos2);
        this.linearKeyFrames[2] = new KBKeyFrame(0.4f, 1, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos3);
        this.linearKeyFrames[3] = new KBKeyFrame(0.6f, 1, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos4);
        this.linearKeyFrames[4] = new KBKeyFrame(0.8f, 1, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
        p = new Point3f((Tuple3f)this.pos5);
        this.linearKeyFrames[5] = new KBKeyFrame(1.0f, 1, p, head, pitch, bank, s, 0.0f, 0.0f, 0.0f);
    }

    private void setupAnimationData() {
        this.yAxis = new Transform3D();
        this.animAlpha = new Alpha(-1, 1, 0L, 0L, (long)this.duration, 0L, 0L, 0L, 0L, 0L);
    }

    private void createInterpolators() {
        this.behaviorBranch = new BranchGroup();
        this.splineInterpolator = new KBRotPosScaleSplinePathInterpolator(this.animAlpha, this.objTransformGroup, this.yAxis, this.splineKeyFrames);
        this.splineInterpolator.setSchedulingBounds((Bounds)this.bounds);
        this.behaviorBranch.addChild((Node)this.splineInterpolator);
        this.linearInterpolator = new KBRotPosScaleSplinePathInterpolator(this.animAlpha, this.objTransformGroup, this.yAxis, this.linearKeyFrames);
        this.linearInterpolator.setSchedulingBounds((Bounds)this.bounds);
        this.behaviorBranch.addChild((Node)this.linearInterpolator);
        this.objTransformGroup.addChild((Node)this.behaviorBranch);
    }

    public void startInterpolator() {
        if (this.animationOn) {
            if (this.linear) {
                this.splineInterpolator.setEnable(false);
                this.linearInterpolator.setEnable(true);
            } else {
                this.linearInterpolator.setEnable(false);
                this.splineInterpolator.setEnable(true);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.animateButton) {
            try {
                if (this.animationOn) {
                    this.animationOn = false;
                    this.splineInterpolator.setEnable(false);
                    this.linearInterpolator.setEnable(false);
                    this.animateButton.setLabel("Start Animation");
                } else {
                    this.animationOn = true;
                    this.startInterpolator();
                    this.animateButton.setLabel("Stop Animation");
                }
            }
            catch (Exception e) {
                System.err.println("Exception " + e);
            }
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        ItemSelectable ie = event.getItemSelectable();
        if (source == this.interpChoice) {
            try {
                if (ie.getSelectedObjects()[0] == "Spline") {
                    this.linear = false;
                }
                if (ie.getSelectedObjects()[0] == "Linear") {
                    this.linear = true;
                }
                this.startInterpolator();
            }
            catch (Exception e) {
                System.err.println("Exception " + e);
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int value = e.getValue();
        this.duration = 6000 - 500 * value;
        this.animAlpha.setIncreasingAlphaDuration((long)this.duration);
    }

    public static void main(String[] args) {
        MainFrame frame = new MainFrame((Applet)new SplineAnim(), 500, 600);
    }
}

