/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.examples.swing_interaction;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.vecmath.Point3d;

public class SwingInteraction
extends JFrame {
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    private TransformGroup objTrans;
    private RotateBehavior awtBehavior;
    private JPanel drawingPanel;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JPanel guiPanel;
    private JMenuBar jMenuBar1;
    private JButton rotateButton;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.objTrans = new TransformGroup();
        this.objTrans.setCapability(18);
        objRoot.addChild((Node)this.objTrans);
        this.objTrans.addChild((Node)new ColorCube(0.4));
        this.awtBehavior = new RotateBehavior(this.objTrans);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.awtBehavior.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)this.awtBehavior);
        return objRoot;
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public SwingInteraction() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    private void initComponents() {
        this.guiPanel = new JPanel();
        this.rotateButton = new JButton();
        this.drawingPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Swing Interaction Test");
        this.guiPanel.setLayout(new GridBagLayout());
        this.rotateButton.setText("Rotate");
        this.rotateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingInteraction.this.rotateButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.guiPanel.add((Component)this.rotateButton, gridBagConstraints);
        this.getContentPane().add((Component)this.guiPanel, "North");
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.fileMenu.setText("File");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingInteraction.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.jMenuBar1.add(this.fileMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void rotateButtonActionPerformed(ActionEvent evt) {
        this.awtBehavior.rotate();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SwingInteraction().setVisible(true);
            }
        });
    }

    class RotateBehavior
    extends Behavior {
        private TransformGroup transformGroup;
        private Transform3D trans = new Transform3D();
        private WakeupCriterion criterion;
        private float angle = 0.0f;
        private final int ROTATE = 1;

        RotateBehavior(TransformGroup tg) {
            this.transformGroup = tg;
        }

        public void initialize() {
            this.criterion = new WakeupOnBehaviorPost((Behavior)this, 1);
            this.wakeupOn((WakeupCondition)this.criterion);
        }

        public void processStimulus(Enumeration criteria) {
            this.angle = (float)((double)this.angle + Math.toRadians(10.0));
            this.trans.rotY((double)this.angle);
            this.transformGroup.setTransform(this.trans);
            this.wakeupOn((WakeupCondition)this.criterion);
        }

        void rotate() {
            this.postId(1);
        }
    }
}

